/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.configuration;

import java.security.NoSuchAlgorithmException;
import org.apache.nifi.toolkit.tls.configuration.TlsConfig;
import org.apache.nifi.toolkit.tls.service.client.TlsCertificateSigningRequestPerformer;
import org.apache.nifi.util.StringUtils;

public class TlsClientConfig
extends TlsConfig {
    private String trustStore;
    private String trustStorePassword;
    private String trustStoreType = "jks";

    public TlsClientConfig() {
    }

    public TlsClientConfig(TlsConfig tlsConfig) {
        this.setToken(tlsConfig.getToken());
        this.setCaHostname(tlsConfig.getCaHostname());
        this.setPort(tlsConfig.getPort());
        this.setKeyStoreType(tlsConfig.getKeyStoreType());
        this.setKeyPairAlgorithm(tlsConfig.getKeyPairAlgorithm());
        this.setKeySize(tlsConfig.getKeySize());
        this.setSigningAlgorithm(tlsConfig.getSigningAlgorithm());
        this.setDnPrefix(tlsConfig.getDnPrefix());
        this.setDnSuffix(tlsConfig.getDnSuffix());
        this.setDomainAlternativeNames(tlsConfig.getDomainAlternativeNames());
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public TlsCertificateSigningRequestPerformer createCertificateSigningRequestPerformer() throws NoSuchAlgorithmException {
        return new TlsCertificateSigningRequestPerformer(this);
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        if (StringUtils.isEmpty((String)this.trustStoreType)) {
            this.trustStoreType = "jks";
        }
    }
}

