/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.manager.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.toolkit.tls.configuration.TlsClientConfig;
import org.apache.nifi.toolkit.tls.manager.writer.ConfigurationWriter;
import org.apache.nifi.toolkit.tls.properties.NiFiPropertiesWriter;
import org.apache.nifi.toolkit.tls.properties.NiFiPropertiesWriterFactory;
import org.apache.nifi.toolkit.tls.util.OutputStreamFactory;
import org.apache.nifi.util.StringUtils;

public class NifiPropertiesTlsClientConfigWriter
implements ConfigurationWriter<TlsClientConfig> {
    public static final String HOSTNAME_PROPERTIES = "hostname.properties";
    public static final String OVERLAY_PROPERTIES = "overlay.properties";
    public static final String INCREMENTING_PROPERTIES = "incrementing.properties";
    public static final String CONF = "./conf/";
    private final NiFiPropertiesWriterFactory niFiPropertiesWriterFactory;
    private final File outputFile;
    private final String hostname;
    private final int hostNum;
    private final Properties overlayProperties;
    private final Set<String> metaProperties;

    public NifiPropertiesTlsClientConfigWriter(NiFiPropertiesWriterFactory niFiPropertiesWriterFactory, File outputFile, String hostname, int hostNum) throws IOException {
        this.niFiPropertiesWriterFactory = niFiPropertiesWriterFactory;
        this.outputFile = outputFile;
        this.hostname = hostname;
        this.hostNum = hostNum;
        this.overlayProperties = new Properties();
        this.overlayProperties.load(this.getClass().getClassLoader().getResourceAsStream(OVERLAY_PROPERTIES));
        HashSet<String> metaProperties = new HashSet<String>();
        metaProperties.add(HOSTNAME_PROPERTIES);
        metaProperties.add(INCREMENTING_PROPERTIES);
        this.getIncrementingPropertiesStream().forEach(metaProperties::add);
        this.metaProperties = Collections.unmodifiableSet(metaProperties);
    }

    @Override
    public void write(TlsClientConfig tlsClientConfig, OutputStreamFactory outputStreamFactory) throws IOException {
        NiFiPropertiesWriter niFiPropertiesWriter = this.niFiPropertiesWriterFactory.create();
        this.updateProperties(niFiPropertiesWriter, tlsClientConfig);
        try (OutputStream stream = outputStreamFactory.create(this.outputFile);){
            niFiPropertiesWriter.writeNiFiProperties(stream);
        }
    }

    protected void updateProperties(NiFiPropertiesWriter niFiPropertiesWriter, TlsClientConfig tlsClientConfig) throws IOException {
        niFiPropertiesWriter.setPropertyValue("nifi.security.keystore", CONF + new File(tlsClientConfig.getKeyStore()).getName());
        niFiPropertiesWriter.setPropertyValue("nifi.security.keystoreType", tlsClientConfig.getKeyStoreType());
        niFiPropertiesWriter.setPropertyValue("nifi.security.keystorePasswd", tlsClientConfig.getKeyStorePassword());
        niFiPropertiesWriter.setPropertyValue("nifi.security.keyPasswd", tlsClientConfig.getKeyPassword());
        niFiPropertiesWriter.setPropertyValue("nifi.security.truststore", CONF + new File(tlsClientConfig.getTrustStore()).getName());
        niFiPropertiesWriter.setPropertyValue("nifi.security.truststoreType", tlsClientConfig.getTrustStoreType());
        niFiPropertiesWriter.setPropertyValue("nifi.security.truststorePasswd", tlsClientConfig.getTrustStorePassword());
        this.getHostnamePropertyStream().forEach(s -> niFiPropertiesWriter.setPropertyValue((String)s, this.hostname));
        this.overlayProperties.stringPropertyNames().stream().filter(s -> !this.metaProperties.contains(s)).forEach(s -> niFiPropertiesWriter.setPropertyValue((String)s, this.overlayProperties.getProperty((String)s)));
        this.getIncrementingPropertyMap().entrySet().forEach(nameToIntegerEntry -> niFiPropertiesWriter.setPropertyValue((String)nameToIntegerEntry.getKey(), Integer.toString((Integer)nameToIntegerEntry.getValue())));
    }

    protected Properties getOverlayProperties() {
        return this.overlayProperties;
    }

    protected Map<String, Integer> getIncrementingPropertyMap() {
        return this.getIncrementingPropertiesStream().collect(Collectors.toMap(Function.identity(), portProperty -> {
            int startingPort;
            String portVal = this.overlayProperties.getProperty((String)portProperty);
            try {
                startingPort = Integer.parseInt(portVal);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Expected numeric values in overlay.properties (" + portProperty + " was " + portVal + ")");
            }
            return startingPort + this.hostNum - 1;
        }));
    }

    protected Stream<String> getIncrementingPropertiesStream() {
        return this.getCommaSeparatedPropertyStream(INCREMENTING_PROPERTIES);
    }

    protected Stream<String> getHostnamePropertyStream() {
        return this.getCommaSeparatedPropertyStream(HOSTNAME_PROPERTIES);
    }

    private Stream<String> getCommaSeparatedPropertyStream(String property) {
        String hostnamePropertyString = this.overlayProperties.getProperty(property);
        if (!StringUtils.isEmpty((String)hostnamePropertyString)) {
            return Arrays.stream(hostnamePropertyString.split(",")).map(String::trim);
        }
        return Stream.of(new String[0]);
    }
}

