/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.zkmigrator;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;

class ZooKeeperEndpointConfig {
    private final String connectString;
    private final List<String> servers;
    private final String path;

    ZooKeeperEndpointConfig(String connectString) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)connectString) ? 1 : 0) != 0, (Object)"connectString can not be null or empty");
        this.connectString = connectString;
        String[] connectStringPath = connectString.split("/", 2);
        this.servers = Lists.newArrayList((Object[])connectStringPath[0].split(","));
        this.path = connectStringPath.length == 2 ? '/' + Joiner.on((char)'/').join(Splitter.on((char)'/').omitEmptyStrings().trimResults().split((CharSequence)connectStringPath[1])) : "/";
    }

    public String getConnectString() {
        return this.connectString;
    }

    public List getServers() {
        return this.servers;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZooKeeperEndpointConfig that = (ZooKeeperEndpointConfig)o;
        return Objects.equals(this.connectString, that.connectString) && Objects.equals(this.servers, that.servers) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.connectString, this.servers, this.path);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectString", (Object)this.connectString).add("servers", this.servers).add("path", (Object)this.path).toString();
    }
}

