/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.apache.nifi.util.console.ConsoleException;
import org.apache.nifi.util.console.TextDevice;

class CharacterDevice
extends TextDevice {
    private final BufferedReader reader;
    private final PrintWriter writer;

    public CharacterDevice(BufferedReader reader, PrintWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    public CharacterDevice printf(String fmt, Object ... params) throws ConsoleException {
        this.writer.printf(fmt, params);
        return this;
    }

    @Override
    public String readLine() throws ConsoleException {
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public char[] readPassword() throws ConsoleException {
        return this.readLine().toCharArray();
    }

    @Override
    public Reader reader() throws ConsoleException {
        return this.reader;
    }

    @Override
    public PrintWriter writer() throws ConsoleException {
        return this.writer;
    }
}

