/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.net.URL;
import java.time.Instant;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.core.ClaimAccessor;

public interface OAuth2TokenIntrospectionClaimAccessor
extends ClaimAccessor {
    default public boolean isActive() {
        return Boolean.TRUE.equals(this.getClaimAsBoolean("active"));
    }

    @Nullable
    default public String getUsername() {
        return this.getClaimAsString("username");
    }

    @Nullable
    default public String getClientId() {
        return this.getClaimAsString("client_id");
    }

    @Nullable
    default public List<String> getScopes() {
        return this.getClaimAsStringList("scope");
    }

    @Nullable
    default public String getTokenType() {
        return this.getClaimAsString("token_type");
    }

    @Nullable
    default public Instant getExpiresAt() {
        return this.getClaimAsInstant("exp");
    }

    @Nullable
    default public Instant getIssuedAt() {
        return this.getClaimAsInstant("iat");
    }

    @Nullable
    default public Instant getNotBefore() {
        return this.getClaimAsInstant("nbf");
    }

    @Nullable
    default public String getSubject() {
        return this.getClaimAsString("sub");
    }

    @Nullable
    default public List<String> getAudience() {
        return this.getClaimAsStringList("aud");
    }

    @Nullable
    default public URL getIssuer() {
        return this.getClaimAsURL("iss");
    }

    @Nullable
    default public String getId() {
        return this.getClaimAsString("jti");
    }
}

