/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.kafkamigrator;

import org.apache.nifi.toolkit.kafkamigrator.descriptor.ProcessorDescriptor;
import org.apache.nifi.toolkit.kafkamigrator.descriptor.PropertyXpathDescriptor;

public class MigratorConfiguration {
    private final String kafkaBrokers;
    private final boolean transaction;
    private final boolean isVersion8Processor;
    private final ProcessorDescriptor processorDescriptor;
    private final PropertyXpathDescriptor propertyXpathDescriptor;

    public MigratorConfiguration(String kafkaBrokers, boolean transaction, boolean isVersion8Processor, ProcessorDescriptor processorDescriptor, PropertyXpathDescriptor propertyXpathDescriptor) {
        this.kafkaBrokers = kafkaBrokers;
        this.transaction = transaction;
        this.isVersion8Processor = isVersion8Processor;
        this.processorDescriptor = processorDescriptor;
        this.propertyXpathDescriptor = propertyXpathDescriptor;
    }

    public String getKafkaBrokers() {
        return this.kafkaBrokers;
    }

    public boolean isTransaction() {
        return this.transaction;
    }

    public boolean isVersion8Processor() {
        return this.isVersion8Processor;
    }

    public ProcessorDescriptor getProcessorDescriptor() {
        return this.processorDescriptor;
    }

    public PropertyXpathDescriptor getPropertyXpathDescriptor() {
        return this.propertyXpathDescriptor;
    }

    public static class MigratorConfigurationBuilder {
        private String kafkaBrokers;
        private boolean transaction;
        private boolean isVersion8Processor;
        private ProcessorDescriptor processorDescriptor;
        private PropertyXpathDescriptor propertyXpathDescriptor;

        public MigratorConfigurationBuilder setKafkaBrokers(String kafkaBrokers) {
            this.kafkaBrokers = kafkaBrokers;
            return this;
        }

        public MigratorConfigurationBuilder setTransaction(boolean transaction) {
            this.transaction = transaction;
            return this;
        }

        public MigratorConfigurationBuilder setIsVersion8Processor(boolean isVersion8Processor) {
            this.isVersion8Processor = isVersion8Processor;
            return this;
        }

        public MigratorConfigurationBuilder setProcessorDescriptor(ProcessorDescriptor processorDescriptor) {
            this.processorDescriptor = processorDescriptor;
            return this;
        }

        public MigratorConfigurationBuilder setPropertyXpathDescriptor(PropertyXpathDescriptor propertyXpathDescriptor) {
            this.propertyXpathDescriptor = propertyXpathDescriptor;
            return this;
        }

        public MigratorConfiguration build() {
            return new MigratorConfiguration(this.kafkaBrokers, this.transaction, this.isVersion8Processor, this.processorDescriptor, this.propertyXpathDescriptor);
        }
    }
}

