/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordMetadata;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.vm.api.MemoryMW;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.griffin.AnyRecordMetadata;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MPSequence;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.tasks.O3PartitionPurgeTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TableUtils {
    public static final int ANY_TABLE_ID = -1;
    public static final int ANY_TABLE_VERSION = -1;
    public static final String ATTACHABLE_DIR_MARKER = ".attachable";
    public static final long COLUMN_NAME_TXN_NONE = -1L;
    public static final String COLUMN_VERSION_FILE_NAME = "_cv";
    public static final String DEFAULT_PARTITION_NAME = "default";
    public static final String DETACHED_DIR_MARKER = ".detached";
    public static final String FILE_SUFFIX_D = ".d";
    public static final String FILE_SUFFIX_I = ".i";
    public static final int INITIAL_TXN = 0;
    public static final int LONGS_PER_TX_ATTACHED_PARTITION = 4;
    public static final int LONGS_PER_TX_ATTACHED_PARTITION_MSB = Numbers.msb(4);
    public static final long META_COLUMN_DATA_SIZE = 32L;
    public static final String META_FILE_NAME = "_meta";
    public static final long META_OFFSET_COLUMN_TYPES = 128L;
    public static final long META_OFFSET_COUNT = 0L;
    public static final long META_OFFSET_MAX_UNCOMMITTED_ROWS = 20L;
    public static final long META_OFFSET_O3_MAX_LAG = 24L;
    public static final long META_OFFSET_STRUCTURE_VERSION = 32L;
    public static final long META_OFFSET_TABLE_ID = 16L;
    public static final long META_OFFSET_TIMESTAMP_INDEX = 8L;
    public static final long META_OFFSET_VERSION = 12L;
    public static final long META_OFFSET_WAL_ENABLED = 40L;
    public static final int NULL_LEN = -1;
    public static final String SNAPSHOT_META_FILE_NAME = "_snapshot";
    public static final String SYMBOL_KEY_REMAP_FILE_SUFFIX = ".r";
    public static final char SYSTEM_TABLE_NAME_SUFFIX = '~';
    public static final int TABLE_DOES_NOT_EXIST = 1;
    public static final int TABLE_EXISTS = 0;
    public static final String TABLE_NAME_FILE = "_name";
    public static final int TABLE_RESERVED = 2;
    public static final String TAB_INDEX_FILE_NAME = "_tab_index.d";
    public static final String TXN_FILE_NAME = "_txn";
    public static final String TXN_SCOREBOARD_FILE_NAME = "_txn_scoreboard";
    public static final int TX_BASE_HEADER_SECTION_PADDING = 12;
    public static final long TX_BASE_OFFSET_VERSION_64 = 0L;
    public static final long TX_BASE_OFFSET_A_32 = 8L;
    public static final long TX_BASE_OFFSET_SYMBOLS_SIZE_A_32 = 12L;
    public static final long TX_BASE_OFFSET_PARTITIONS_SIZE_A_32 = 16L;
    public static final long TX_BASE_OFFSET_B_32 = 32L;
    public static final long TX_BASE_OFFSET_SYMBOLS_SIZE_B_32 = 36L;
    public static final long TX_BASE_OFFSET_PARTITIONS_SIZE_B_32 = 40L;
    public static final int TX_BASE_HEADER_SIZE = (int)Math.max(56L, 64L);
    public static final long TX_OFFSET_MAP_WRITER_COUNT_32 = 128L;
    public static final long TX_OFFSET_TXN_64 = 0L;
    public static final long TX_OFFSET_TRANSIENT_ROW_COUNT_64 = 8L;
    public static final long TX_OFFSET_FIXED_ROW_COUNT_64 = 16L;
    public static final long TX_OFFSET_MIN_TIMESTAMP_64 = 24L;
    public static final long TX_OFFSET_MAX_TIMESTAMP_64 = 32L;
    public static final long TX_OFFSET_STRUCT_VERSION_64 = 40L;
    public static final long TX_OFFSET_DATA_VERSION_64 = 48L;
    public static final long TX_OFFSET_PARTITION_TABLE_VERSION_64 = 56L;
    public static final long TX_OFFSET_COLUMN_VERSION_64 = 64L;
    public static final long TX_OFFSET_TRUNCATE_VERSION_64 = 72L;
    public static final long TX_OFFSET_SEQ_TXN_64 = 80L;
    public static final int TX_RECORD_HEADER_SIZE = 132;
    public static final String UPGRADE_FILE_NAME = "_upgrade.d";
    static final int COLUMN_VERSION_FILE_HEADER_SIZE = 40;
    static final int META_FLAG_BIT_INDEXED = 1;
    static final int META_FLAG_BIT_NOT_INDEXED = 0;
    static final int META_FLAG_BIT_SEQUENTIAL = 2;
    static final long META_OFFSET_PARTITION_BY = 4L;
    static final String META_PREV_FILE_NAME = "_meta.prev";
    static final String META_SWAP_FILE_NAME = "_meta.swp";
    static final int MIN_INDEX_VALUE_BLOCK_SIZE = Numbers.ceilPow2(4);
    static final String TODO_FILE_NAME = "_todo_";
    static final byte TODO_RESTORE_META = 2;
    static final byte TODO_TRUNCATE = 1;
    private static final Log LOG = LogFactory.getLog(TableUtils.class);
    private static final int MAX_INDEX_VALUE_BLOCK_SIZE = Numbers.ceilPow2(0x800000);
    private static final int MAX_SYMBOL_CAPACITY = Numbers.ceilPow2(Integer.MAX_VALUE);
    private static final int MAX_SYMBOL_CAPACITY_CACHED = Numbers.ceilPow2(30000000);
    private static final int MIN_SYMBOL_CAPACITY = 2;

    private TableUtils() {
    }

    public static void allocateDiskSpace(FilesFacade ff, int fd, long size) {
        if (ff.length(fd) < size && !ff.allocate(fd, size)) {
            throw CairoException.critical(ff.errno()).put("No space left [size=").put(size).put(", fd=").put(fd).put(']');
        }
    }

    public static int calculateTxRecordSize(int bytesSymbols, int bytesPartitions) {
        return 136 + bytesSymbols + 4 + bytesPartitions;
    }

    public static Path charFileName(Path path, CharSequence columnName, long columnNameTxn) {
        path.concat(columnName).put(".c");
        if (columnNameTxn > -1L) {
            path.put('.').put(columnNameTxn);
        }
        return path.$();
    }

    public static long checkMemSize(MemoryMR metaMem, long minSize) {
        long memSize = metaMem.size();
        if (memSize < minSize) {
            throw CairoException.critical(0).put("File is too small, size=").put(memSize).put(", required=").put(minSize);
        }
        return memSize;
    }

    public static int compressColumnCount(RecordMetadata metadata) {
        int count = 0;
        int n = metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (metadata.getColumnType(i) <= 0) continue;
            ++count;
        }
        return count;
    }

    public static void createColumnVersionFile(MemoryMARW mem) {
        mem.extend(40L);
        mem.jumpTo(40L);
        mem.zero();
    }

    @NotNull
    public static Function createCursorFunction(FunctionParser functionParser, @NotNull QueryModel model, @NotNull SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode tableNameExpr = model.getTableNameExpr();
        Function function = functionParser.parseFunction(tableNameExpr, AnyRecordMetadata.INSTANCE, executionContext);
        if (!ColumnType.isCursor(function.getType())) {
            throw SqlException.$(tableNameExpr.position, "function must return CURSOR");
        }
        return function;
    }

    public static void createTable(CairoConfiguration configuration, MemoryMARW memory, Path path, TableStructure structure, int tableId, CharSequence dirName) {
        TableUtils.createTable(configuration, memory, path, structure, 426, tableId, dirName);
    }

    public static void createTable(CairoConfiguration configuration, MemoryMARW memory, Path path, TableStructure structure, int tableVersion, int tableId, CharSequence dirName) {
        FilesFacade ff = configuration.getFilesFacade();
        CharSequence root = configuration.getRoot();
        int mkDirMode = configuration.getMkDirMode();
        TableUtils.createTable(ff, root, mkDirMode, memory, path, structure, tableVersion, tableId, dirName);
    }

    public static void createTable(FilesFacade ff, CharSequence root, int mkDirMode, MemoryMARW memory, Path path, TableStructure structure, int tableVersion, int tableId, CharSequence dirName) {
        TableUtils.createTable(ff, root, mkDirMode, memory, path, dirName, structure, tableVersion, tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable(FilesFacade ff, CharSequence root, int mkDirMode, MemoryMARW memory, Path path, CharSequence tableDir, TableStructure structure, int tableVersion, int tableId) {
        LOG.debug().$("create table [name=").$(tableDir).$(']').$();
        path.of(root).concat(tableDir);
        if (ff.mkdirs(path.slash$(), mkDirMode) != 0) {
            throw CairoException.critical(ff.errno()).put("could not create [dir=").put(path).put(']');
        }
        int rootLen = path.length();
        int dirFd = !ff.isRestrictedFileSystem() ? TableUtils.openRO(ff, path.$(), LOG) : 0;
        try (MemoryMARW mem = memory;){
            int i;
            mem.smallFile(ff, path.trimTo(rootLen).concat(META_FILE_NAME).$(), 0);
            mem.jumpTo(0L);
            int count = structure.getColumnCount();
            path.trimTo(rootLen);
            mem.putInt(count);
            mem.putInt(structure.getPartitionBy());
            int timestampIndex = structure.getTimestampIndex();
            assert (timestampIndex == -1 || timestampIndex >= 0 && timestampIndex < count && structure.getColumnType(timestampIndex) == 8);
            mem.putInt(timestampIndex);
            mem.putInt(tableVersion);
            mem.putInt(tableId);
            mem.putInt(structure.getMaxUncommittedRows());
            mem.putLong(structure.getO3MaxLag());
            mem.putLong(0L);
            mem.putInt(structure.isWalEnabled() ? 1 : 0);
            mem.jumpTo(128L);
            assert (count > 0);
            for (i = 0; i < count; ++i) {
                mem.putInt(structure.getColumnType(i));
                long flags = 0L;
                if (structure.isIndexed(i)) {
                    flags |= 1L;
                }
                if (structure.isSequential(i)) {
                    flags |= 2L;
                }
                mem.putLong(flags);
                mem.putInt(structure.getIndexBlockCapacity(i));
                mem.skip(16L);
            }
            for (i = 0; i < count; ++i) {
                mem.putStr(structure.getColumnName(i));
            }
            int symbolMapCount = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                if (!ColumnType.isSymbol(structure.getColumnType(i2))) continue;
                MapWriter.createSymbolMapFiles(ff, mem, path.trimTo(rootLen), structure.getColumnName(i2), -1L, structure.getSymbolCapacity(i2), structure.getSymbolCacheFlag(i2));
                ++symbolMapCount;
            }
            mem.smallFile(ff, path.trimTo(rootLen).concat(TXN_FILE_NAME).$(), 0);
            TableUtils.createTxn(mem, symbolMapCount, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
            mem.smallFile(ff, path.trimTo(rootLen).concat(COLUMN_VERSION_FILE_NAME).$(), 0);
            TableUtils.createColumnVersionFile(mem);
            mem.close();
            TableUtils.resetTodoLog(ff, path, rootLen, mem);
            path.trimTo(rootLen).concat(TXN_SCOREBOARD_FILE_NAME).$();
            mem.smallFile(ff, path.trimTo(rootLen).concat(TABLE_NAME_FILE).$(), 0);
            TableUtils.createTableNameFile(mem, TableUtils.getTableNameFromDirName(tableDir));
        }
        finally {
            if (dirFd > 0) {
                if (ff.fsync(dirFd) != 0) {
                    LOG.error().$("could not fsync [fd=").$(dirFd).$(", errno=").$(ff.errno()).I$();
                }
                ff.close(dirFd);
            }
        }
    }

    public static long createTransitionIndex(MemoryR masterMeta, AbstractRecordMetadata slaveMeta) {
        long pTransitionIndex;
        int slaveColumnCount = slaveMeta.columnCount;
        int masterColumnCount = masterMeta.getInt(0L);
        int size = 8 + masterColumnCount * 8;
        long index = pTransitionIndex = Unsafe.calloc(size, 25);
        Unsafe.getUnsafe().putInt(index, size);
        index += 8L;
        long offset = TableUtils.getColumnNameOffset(masterColumnCount);
        int slaveIndex = 0;
        int shiftLeft = 0;
        for (int masterIndex = 0; masterIndex < masterColumnCount; ++masterIndex) {
            CharSequence name = masterMeta.getStr(offset);
            offset += (long)Vm.getStorageLength(name);
            int masterColumnType = TableUtils.getColumnType(masterMeta, masterIndex);
            if (slaveIndex < slaveColumnCount) {
                int existingWriterIndex = slaveMeta.getWriterIndex(slaveIndex);
                if (existingWriterIndex > masterIndex) {
                    assert (masterColumnType < 0);
                    continue;
                }
                assert (existingWriterIndex == masterIndex);
            }
            int outIndex = slaveIndex - shiftLeft;
            if (masterColumnType < 0) {
                ++shiftLeft;
                if (slaveIndex < slaveColumnCount) {
                    Unsafe.getUnsafe().putInt(index + (long)slaveIndex * 8L, -1);
                    Unsafe.getUnsafe().putInt(index + (long)slaveIndex * 8L + 4L, Integer.MIN_VALUE);
                }
            } else if (slaveIndex < slaveColumnCount && TableUtils.isColumnIndexed(masterMeta, masterIndex) == slaveMeta.isColumnIndexed(slaveIndex) && Chars.equals(name, (CharSequence)slaveMeta.getColumnName(slaveIndex))) {
                Unsafe.getUnsafe().putInt(index + (long)outIndex * 8L + 4L, slaveIndex);
                if (slaveIndex > outIndex) {
                    Unsafe.getUnsafe().putInt(index + (long)slaveIndex * 8L + 4L, Integer.MIN_VALUE);
                }
            } else {
                if (slaveIndex < slaveColumnCount) {
                    Unsafe.getUnsafe().putInt(index + (long)slaveIndex * 8L, -1);
                }
                Unsafe.getUnsafe().putInt(index + (long)outIndex * 8L + 4L, -masterIndex - 1);
            }
            ++slaveIndex;
        }
        Unsafe.getUnsafe().putInt(pTransitionIndex + 4L, slaveIndex - shiftLeft);
        return pTransitionIndex;
    }

    public static void createTxn(MemoryMW txMem, int symbolMapCount, long txn, long seqTxn, long dataVersion, long partitionTableVersion, long structureVersion, long columnVersion, long truncateVersion) {
        txMem.putInt(8L, TX_BASE_HEADER_SIZE);
        txMem.putInt(12L, symbolMapCount * 8);
        txMem.putInt(16L, 0);
        TableUtils.resetTxn(txMem, TX_BASE_HEADER_SIZE, symbolMapCount, txn, seqTxn, dataVersion, partitionTableVersion, structureVersion, columnVersion, truncateVersion);
        txMem.setTruncateSize(TX_BASE_HEADER_SIZE + 132);
    }

    public static LPSZ dFile(Path path, CharSequence columnName, long columnTxn) {
        path.concat(columnName).put(FILE_SUFFIX_D);
        if (columnTxn > -1L) {
            path.put('.').put(columnTxn);
        }
        return path.$();
    }

    public static LPSZ dFile(Path path, CharSequence columnName) {
        return TableUtils.dFile(path, columnName, -1L);
    }

    public static int exists(FilesFacade ff, Path path, CharSequence root, CharSequence name) {
        return TableUtils.exists(ff, path, root, name, 0, name.length());
    }

    public static int exists(FilesFacade ff, Path path, CharSequence root, CharSequence name, int lo, int hi) {
        path.of(root).concat(name, lo, hi).$();
        if (ff.exists(path)) {
            if (ff.exists(path.concat(TXN_FILE_NAME).$())) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public static void freeTransitionIndex(long address) {
        if (address == 0L) {
            return;
        }
        Unsafe.free(address, Unsafe.getUnsafe().getInt(address), 25);
    }

    public static int getColumnCount(MemoryMR metaMem, long offset) {
        int columnCount = metaMem.getInt(offset);
        if (columnCount < 0) {
            throw TableUtils.validationException(metaMem).put("Incorrect columnCount: ").put(columnCount);
        }
        return columnCount;
    }

    public static CharSequence getColumnName(MemoryMR metaMem, long memSize, long offset, int columnIndex) {
        int strLength = TableUtils.getInt(metaMem, memSize, offset);
        if (strLength == -1) {
            throw TableUtils.validationException(metaMem).put("NULL column name at [").put(columnIndex).put(']');
        }
        return TableUtils.getCharSequence(metaMem, memSize, offset, strLength);
    }

    public static long getColumnNameOffset(int columnCount) {
        return 128L + (long)columnCount * 32L;
    }

    public static int getColumnType(MemoryR metaMem, int columnIndex) {
        return metaMem.getInt(128L + (long)columnIndex * 32L);
    }

    public static int getColumnType(MemoryMR metaMem, long memSize, long offset, int columnIndex) {
        int type = TableUtils.getInt(metaMem, memSize, offset);
        if (type >= 0 && ColumnType.sizeOf(type) == -1) {
            throw TableUtils.validationException(metaMem).put("Invalid column type ").put(type).put(" at [").put(columnIndex).put(']');
        }
        return type;
    }

    public static long getPartitionTableIndexOffset(int symbolWriterCount, int index) {
        return TableUtils.getPartitionTableIndexOffset(TableUtils.getPartitionTableSizeOffset(symbolWriterCount), index);
    }

    public static long getPartitionTableIndexOffset(long partitionTableOffset, int index) {
        return partitionTableOffset + 4L + (long)index * 8L;
    }

    public static long getPartitionTableSizeOffset(int symbolWriterCount) {
        return TableUtils.getSymbolWriterIndexOffset(symbolWriterCount);
    }

    public static long getSymbolWriterIndexOffset(int index) {
        return 132L + (long)index * 8L;
    }

    public static long getSymbolWriterTransientIndexOffset(int index) {
        return TableUtils.getSymbolWriterIndexOffset(index) + 4L;
    }

    @NotNull
    public static String getTableDir(boolean mangleDirNames, @NotNull String tableName, int tableId, boolean isWal) {
        String dirName = tableName;
        if (isWal) {
            dirName = dirName + '~';
            dirName = dirName + tableId;
        } else if (mangleDirNames) {
            dirName = dirName + '~';
        }
        return dirName;
    }

    public static CharSequence getTableNameFromDirName(CharSequence privateName) {
        int suffixIndex = Chars.indexOf(privateName, '~');
        if (suffixIndex == -1) {
            return privateName;
        }
        return Chars.toString(privateName).substring(0, suffixIndex);
    }

    public static int getTimestampIndex(MemoryMR metaMem, long offset, int columnCount) {
        int timestampIndex = metaMem.getInt(offset);
        if (timestampIndex < -1 || timestampIndex >= columnCount) {
            throw TableUtils.validationException(metaMem).put("Timestamp index is outside of range, timestampIndex=").put(timestampIndex);
        }
        return timestampIndex;
    }

    public static void handleMetadataLoadException(CharSequence tableName, long deadline, CairoException ex, MillisecondClock millisecondClock, long spinLockTimeout) {
        if (ex.errnoReadPathDoesNotExist()) {
            if (millisecondClock.getTicks() >= deadline) {
                LOG.error().$("metadata read timeout [timeout=").$(spinLockTimeout).utf8("\u03bcs]").$();
                throw CairoException.critical(ex.getErrno()).put("Metadata read timeout. Last error: ").put(ex.getFlyweightMessage());
            }
        } else {
            throw ex;
        }
        LOG.info().$("error reloading metadata [table=").utf8(tableName).$(", errno=").$(ex.getErrno()).$(", error=").utf8(ex.getFlyweightMessage()).I$();
        Os.pause();
    }

    public static LPSZ iFile(Path path, CharSequence columnName, long columnTxn) {
        path.concat(columnName).put(FILE_SUFFIX_I);
        if (columnTxn > -1L) {
            path.put('.').put(columnTxn);
        }
        return path.$();
    }

    public static LPSZ iFile(Path path, CharSequence columnName) {
        return TableUtils.iFile(path, columnName, -1L);
    }

    public static boolean isValidColumnName(CharSequence seq, int fsFileNameLimit) {
        int l = seq.length();
        if (l > fsFileNameLimit) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            char c = seq.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\"': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '?': 
                case '\\': 
                case '~': 
                case '\u007f': 
                case '\ufeff': {
                    return false;
                }
            }
        }
        return l > 0;
    }

    public static boolean isValidTableName(CharSequence tableName, int fsFileNameLimit) {
        int l = tableName.length();
        if (l > fsFileNameLimit) {
            return false;
        }
        block4: for (int i = 0; i < l; ++i) {
            char c = tableName.charAt(i);
            switch (c) {
                case '.': {
                    if (i != 0 && i != l - 1 && tableName.charAt(i - 1) != '.') continue block4;
                    return false;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\"': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ':': 
                case '?': 
                case '\\': 
                case '~': 
                case '\u007f': 
                case '\ufeff': {
                    return false;
                }
            }
        }
        return tableName.length() > 0 && tableName.charAt(0) != ' ' && tableName.charAt(l - 1) != ' ';
    }

    public static int lock(FilesFacade ff, Path path, boolean logOnError) {
        int fd = ff.openRW(path, 0L);
        if (fd == -1) {
            if (logOnError) {
                LOG.error().$("cannot open '").utf8(path).$("' to lock [errno=").$(ff.errno()).$(']').$();
            }
            return -1;
        }
        if (ff.lock(fd) != 0) {
            if (logOnError) {
                LOG.error().$("cannot lock '").utf8(path).$("' [errno=").$(ff.errno()).$(", fd=").$(fd).$(']').$();
            }
            ff.close(fd);
            return -1;
        }
        LOG.info().$("locked '").utf8(path).$("' [fd=").$(fd).I$();
        return fd;
    }

    public static int lock(FilesFacade ff, Path path) {
        return TableUtils.lock(ff, path, true);
    }

    public static void lockName(Path path) {
        path.put(".lock").$();
    }

    public static long mapRO(FilesFacade ff, int fd, long size, int memoryTag) {
        return TableUtils.mapRO(ff, fd, size, 0L, memoryTag);
    }

    public static long mapRO(FilesFacade ff, int fd, long size, long offset, int memoryTag) {
        assert (fd != -1);
        assert (offset % ff.getPageSize() == 0L);
        long address = ff.mmap(fd, size, offset, 1, memoryTag);
        if (address == -1L) {
            throw CairoException.critical(ff.errno()).put("could not mmap ").put(" [size=").put(size).put(", offset=").put(offset).put(", fd=").put(fd).put(", memUsed=").put(Unsafe.getMemUsed()).put(", fileLen=").put(ff.length(fd)).put(']');
        }
        return address;
    }

    public static long mapRW(FilesFacade ff, int fd, long size, int memoryTag) {
        return TableUtils.mapRW(ff, fd, size, 0L, memoryTag);
    }

    public static long mapRW(FilesFacade ff, int fd, long size, long offset, int memoryTag) {
        assert (fd != -1);
        assert (offset % ff.getPageSize() == 0L);
        TableUtils.allocateDiskSpace(ff, fd, size + offset);
        long addr = ff.mmap(fd, size, offset, 2, memoryTag);
        if (addr > -1L) {
            return addr;
        }
        int errno = ff.errno();
        if (Os.type != 3 || errno != 112) {
            throw CairoException.critical(ff.errno()).put("could not mmap column [fd=").put(fd).put(", size=").put(size).put(']');
        }
        throw CairoException.critical(ff.errno()).put("No space left [size=").put(size).put(", fd=").put(fd).put(']');
    }

    public static long mapRWOrClose(FilesFacade ff, int fd, long size, int memoryTag) {
        try {
            return TableUtils.mapRW(ff, fd, size, memoryTag);
        }
        catch (CairoException e) {
            ff.close(fd);
            throw e;
        }
    }

    public static long mremap(FilesFacade ff, int fd, long prevAddress, long prevSize, long newSize, int mapMode, int memoryTag) {
        return TableUtils.mremap(ff, fd, prevAddress, prevSize, newSize, 0L, mapMode, memoryTag);
    }

    public static long mremap(FilesFacade ff, int fd, long prevAddress, long prevSize, long newSize, long offset, int mapMode, int memoryTag) {
        long page = ff.mremap(fd, prevAddress, prevSize, newSize, offset, mapMode, memoryTag);
        if (page == -1L) {
            int errno = ff.errno();
            throw CairoException.critical(errno).put("could not remap file [previousSize=").put(prevSize).put(", newSize=").put(newSize).put(", offset=").put(offset).put(", fd=").put(fd).put(']');
        }
        return page;
    }

    public static Path offsetFileName(Path path, CharSequence columnName, long columnNameTxn) {
        path.concat(columnName).put(".o");
        if (columnNameTxn > -1L) {
            path.put('.').put(columnNameTxn);
        }
        return path.$();
    }

    public static void oldPartitionName(Path path, long txn) {
        path.put("-x-").put(txn);
    }

    public static int openFileRWOrFail(FilesFacade ff, LPSZ path, long opts) {
        return TableUtils.openRW(ff, path, LOG, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int openRO(FilesFacade ff, Path path, CharSequence fileName, Log log) {
        int rootLen = path.length();
        path.concat(fileName).$();
        try {
            int n = TableUtils.openRO(ff, path, log);
            return n;
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    public static int openRO(FilesFacade ff, LPSZ path, Log log) {
        int fd = ff.openRO(path);
        if (fd > -1) {
            log.debug().$("open [file=").$(path).$(", fd=").$(fd).$(']').$();
            return fd;
        }
        throw CairoException.critical(ff.errno()).put("could not open read-only [file=").put(path).put(']');
    }

    public static int openRW(FilesFacade ff, LPSZ path, Log log, long opts) {
        int fd = ff.openRW(path, opts);
        if (fd > -1) {
            log.debug().$("open [file=").$(path).$(", fd=").$(fd).$(']').$();
            return fd;
        }
        throw CairoException.critical(ff.errno()).put("could not open read-write [file=").put(path).put(']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openSmallFile(FilesFacade ff, Path path, int rootLen, MemoryMR metaMem, CharSequence fileName, int memoryTag) {
        path.concat(fileName).$();
        try {
            metaMem.smallFile(ff, path, memoryTag);
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    public static void overwriteTableNameFile(Path tablePath, MemoryMARW memory, FilesFacade ff, TableToken newTableToken) {
        Path nameFilePath = tablePath.concat(TABLE_NAME_FILE).$();
        memory.smallFile(ff, nameFilePath, 5);
        memory.jumpTo(0L);
        TableUtils.createTableNameFile(memory, newTableToken.getTableName());
        memory.close(true, (byte)1);
    }

    public static int readIntOrFail(FilesFacade ff, int fd, long offset, long tempMem8b, Path path) {
        if (ff.read(fd, tempMem8b, 4L, offset) != 4L) {
            throw CairoException.critical(ff.errno()).put("Cannot read: ").put(path);
        }
        return Unsafe.getUnsafe().getInt(tempMem8b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readLongAtOffset(FilesFacade ff, Path path, long tempMem8b, long offset) {
        int fd = TableUtils.openRO(ff, path, LOG);
        try {
            long l = TableUtils.readLongOrFail(ff, fd, offset, tempMem8b, path);
            return l;
        }
        finally {
            ff.close(fd);
        }
    }

    public static long readLongOrFail(FilesFacade ff, int fd, long offset, long tempMem8b, @Nullable Path path) {
        if (ff.read(fd, tempMem8b, 8L, offset) != 8L) {
            if (path != null) {
                throw CairoException.critical(ff.errno()).put("could not read long [path=").put(path).put(", fd=").put(fd).put(", offset=").put(offset);
            }
            throw CairoException.critical(ff.errno()).put("could not read long [fd=").put(fd).put(", offset=").put(offset);
        }
        return Unsafe.getUnsafe().getLong(tempMem8b);
    }

    public static void removeOrException(FilesFacade ff, int fd, LPSZ path) {
        if (ff.exists(path) && !ff.closeRemove(fd, path)) {
            throw CairoException.critical(ff.errno()).put("Cannot remove ").put(path);
        }
    }

    public static void renameOrFail(FilesFacade ff, Path src, Path dst) {
        if (ff.rename(src, dst) != 0) {
            throw CairoException.critical(ff.errno()).put("could not rename ").put(src).put(" -> ").put(dst);
        }
    }

    public static void resetTodoLog(FilesFacade ff, Path path, int rootLen, MemoryMARW mem) {
        mem.smallFile(ff, path.trimTo(rootLen).concat(TODO_FILE_NAME).$(), 0);
        mem.jumpTo(0L);
        mem.putLong(24L, 0L);
        Unsafe.getUnsafe().storeFence();
        mem.putLong(8L, 0L);
        mem.putLong(16L, 0L);
        Unsafe.getUnsafe().storeFence();
        mem.putLong(0L, 0L);
        mem.putLong(32L, 0L);
        mem.jumpTo(40L);
    }

    public static void resetTxn(MemoryMW txMem, long baseOffset, int symbolMapCount, long txn, long seqTxn, long dataVersion, long partitionTableVersion, long structureVersion, long columnVersion, long truncateVersion) {
        txMem.putLong(baseOffset + 0L, txn);
        txMem.putLong(baseOffset + 8L, 0L);
        txMem.putLong(baseOffset + 16L, 0L);
        txMem.putLong(baseOffset + 24L, Long.MAX_VALUE);
        txMem.putLong(baseOffset + 32L, Long.MIN_VALUE);
        txMem.putLong(baseOffset + 40L, structureVersion);
        txMem.putLong(baseOffset + 48L, dataVersion);
        txMem.putLong(baseOffset + 56L, partitionTableVersion);
        txMem.putLong(baseOffset + 64L, columnVersion);
        txMem.putLong(baseOffset + 72L, truncateVersion);
        txMem.putLong(baseOffset + 80L, seqTxn);
        txMem.putInt(baseOffset + 128L, symbolMapCount);
        for (int i = 0; i < symbolMapCount; ++i) {
            long offset = TableUtils.getSymbolWriterIndexOffset(i);
            txMem.putInt(baseOffset + offset, 0);
            txMem.putInt(baseOffset + (offset += 4L), 0);
        }
        txMem.putInt(baseOffset + TableUtils.getPartitionTableSizeOffset(symbolMapCount), 0);
    }

    public static void safeReadTxn(TxReader txReader, MillisecondClock clock, long spinLockTimeout) {
        long deadline = clock.getTicks() + spinLockTimeout;
        if (txReader.unsafeReadVersion() == txReader.getVersion()) {
            LOG.debug().$("checked clean txn, version ").$(txReader.getVersion()).$(", txn=").$(txReader.getTxn()).$();
            return;
        }
        while (true) {
            if (txReader.unsafeLoadAll()) {
                LOG.debug().$("loaded clean txn, version ").$(txReader.getVersion()).$(", offset=").$(txReader.getBaseOffset()).$(", size=").$(txReader.getRecordSize()).$(", txn=").$(txReader.getTxn()).$();
                return;
            }
            if (clock.getTicks() > deadline) {
                LOG.error().$("tx read timeout [timeout=").$(spinLockTimeout).utf8("ms]").$();
                throw CairoException.critical(0).put("Transaction read timeout");
            }
            LOG.debug().$("loaded __dirty__ txn, version ").$(txReader.getVersion()).$();
            Os.pause();
        }
    }

    public static boolean schedulePurgeO3Partitions(MessageBus messageBus, TableToken tableName, int partitionBy) {
        MPSequence seq = messageBus.getO3PurgeDiscoveryPubSeq();
        while (true) {
            long cursor;
            if ((cursor = seq.next()) > -1L) {
                O3PartitionPurgeTask task = messageBus.getO3PurgeDiscoveryQueue().get(cursor);
                task.of(tableName, partitionBy);
                seq.done(cursor);
                return true;
            }
            if (cursor == -1L) {
                return false;
            }
            Os.pause();
        }
    }

    public static void setNull(int columnType, long addr, long count) {
        switch (ColumnType.tagOf(columnType)) {
            case 1: 
            case 2: {
                Vect.memset(addr, count, 0);
                break;
            }
            case 14: {
                Vect.memset(addr, count, -1);
                break;
            }
            case 3: 
            case 4: {
                Vect.setMemoryShort(addr, (short)0, count);
                break;
            }
            case 15: {
                Vect.setMemoryShort(addr, (short)-1, count);
                break;
            }
            case 5: {
                Vect.setMemoryInt(addr, Integer.MIN_VALUE, count);
                break;
            }
            case 16: {
                Vect.setMemoryInt(addr, -1, count);
                break;
            }
            case 9: {
                Vect.setMemoryFloat(addr, Float.NaN, count);
                break;
            }
            case 12: {
                Vect.setMemoryInt(addr, Integer.MIN_VALUE, count);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                Vect.setMemoryLong(addr, Long.MIN_VALUE, count);
                break;
            }
            case 17: {
                Vect.setMemoryLong(addr, -1L, count);
                break;
            }
            case 10: {
                Vect.setMemoryDouble(addr, Double.NaN, count);
                break;
            }
            case 13: {
                Vect.setMemoryLong(addr, Long.MIN_VALUE, count * 4L);
                break;
            }
            case 19: 
            case 24: {
                Vect.setMemoryLong(addr, Long.MIN_VALUE, count * 2L);
                break;
            }
        }
    }

    public static void setPathForPartition(Path tablePath, int tableRootLen, int partitionBy, long timestamp, long partitionNameTxn) {
        tablePath.trimTo(tableRootLen);
        TableUtils.setPathForPartition(tablePath, partitionBy, timestamp, false);
        TableUtils.txnPartitionConditionally(tablePath, partitionNameTxn);
    }

    public static long setPathForPartition(Path path, int partitionBy, long timestamp, boolean calculatePartitionMax) {
        return PartitionBy.setSinkForPartition(path.slash(), partitionBy, timestamp, calculatePartitionMax);
    }

    public static int toIndexKey(int symbolKey) {
        return symbolKey == Integer.MIN_VALUE ? 0 : symbolKey + 1;
    }

    public static void txnPartition(CharSink path, long txn) {
        path.put('.').put(txn);
    }

    public static void txnPartitionConditionally(CharSink path, long txn) {
        if (txn > -1L) {
            TableUtils.txnPartition(path, txn);
        }
    }

    public static void validateIndexValueBlockSize(int position, int indexValueBlockSize) throws SqlException {
        if (indexValueBlockSize < MIN_INDEX_VALUE_BLOCK_SIZE) {
            throw SqlException.$(position, "min index block capacity is ").put(MIN_INDEX_VALUE_BLOCK_SIZE);
        }
        if (indexValueBlockSize > MAX_INDEX_VALUE_BLOCK_SIZE) {
            throw SqlException.$(position, "max index block capacity is ").put(MAX_INDEX_VALUE_BLOCK_SIZE);
        }
    }

    public static void validateMeta(MemoryMR metaMem, LowerCaseCharSequenceIntHashMap nameIndex, int expectedVersion) {
        try {
            int timestampType;
            long memSize = TableUtils.checkMemSize(metaMem, 128L);
            TableUtils.validateMetaVersion(metaMem, 12L, expectedVersion);
            int columnCount = TableUtils.getColumnCount(metaMem, 0L);
            long offset = TableUtils.getColumnNameOffset(columnCount);
            if (memSize < offset) {
                throw TableUtils.validationException(metaMem).put("File is too small, column types are missing ").put(memSize);
            }
            int timestampIndex = TableUtils.getTimestampIndex(metaMem, 8L, columnCount);
            if (timestampIndex != -1 && !ColumnType.isTimestamp(timestampType = TableUtils.getColumnType(metaMem, timestampIndex))) {
                throw TableUtils.validationException(metaMem).put("Timestamp column must be TIMESTAMP, but found ").put(ColumnType.nameOf(timestampType));
            }
            for (int i = 0; i < columnCount; ++i) {
                int type = Math.abs(TableUtils.getColumnType(metaMem, i));
                if (ColumnType.sizeOf(type) == -1) {
                    throw TableUtils.validationException(metaMem).put("Invalid column type ").put(type).put(" at [").put(i).put(']');
                }
                if (!TableUtils.isColumnIndexed(metaMem, i)) continue;
                if (!ColumnType.isSymbol(type)) {
                    throw TableUtils.validationException(metaMem).put("Index flag is only supported for SYMBOL").put(" at [").put(i).put(']');
                }
                if (TableUtils.getIndexBlockCapacity(metaMem, i) >= 2) continue;
                throw TableUtils.validationException(metaMem).put("Invalid index value block capacity ").put(TableUtils.getIndexBlockCapacity(metaMem, i)).put(" at [").put(i).put(']');
            }
            int denseCount = 0;
            for (int i = 0; i < columnCount; ++i) {
                CharSequence name = TableUtils.getColumnName(metaMem, memSize, offset, i);
                if (TableUtils.getColumnType(metaMem, i) < 0 || nameIndex.put(name, denseCount++)) {
                    offset += (long)Vm.getStorageLength(name);
                    continue;
                }
                throw TableUtils.validationException(metaMem).put("Duplicate column [name=").put(name).put("] at ").put(i);
            }
        }
        catch (Throwable e) {
            nameIndex.clear();
            throw e;
        }
    }

    public static void validateMetaVersion(MemoryMR metaMem, long metaVersionOffset, int expectedVersion) {
        int metaVersion = metaMem.getInt(metaVersionOffset);
        if (expectedVersion != metaVersion) {
            throw TableUtils.validationException(metaMem).put("Metadata version does not match runtime version [expected=").put(expectedVersion).put(", actual=").put(metaVersion).put(']');
        }
    }

    public static void validateSymbolCapacity(int position, int symbolCapacity) throws SqlException {
        if (symbolCapacity < 2) {
            throw SqlException.$(position, "min symbol capacity is ").put(2);
        }
        if (symbolCapacity > MAX_SYMBOL_CAPACITY) {
            throw SqlException.$(position, "max symbol capacity is ").put(MAX_SYMBOL_CAPACITY);
        }
    }

    public static void validateSymbolCapacityCached(boolean cache, int symbolCapacity, int cacheKeywordPosition) throws SqlException {
        if (cache && symbolCapacity > MAX_SYMBOL_CAPACITY_CACHED) {
            throw SqlException.$(cacheKeywordPosition, "max cached symbol capacity is ").put(MAX_SYMBOL_CAPACITY_CACHED);
        }
    }

    public static CairoException validationException(MemoryMR mem) {
        return CairoException.critical(-100).put("Invalid metadata at fd=").put(mem.getFd()).put(". ");
    }

    public static void writeIntOrFail(FilesFacade ff, int fd, long offset, int value, long tempMem8b, Path path) {
        Unsafe.getUnsafe().putInt(tempMem8b, value);
        if (ff.write(fd, tempMem8b, 4L, offset) != 4L) {
            throw CairoException.critical(ff.errno()).put("could not write 8 bytes [path=").put(path).put(", fd=").put(fd).put(", offset=").put(offset).put(", value=").put(value).put(']');
        }
    }

    public static void writeLongOrFail(FilesFacade ff, int fd, long offset, long value, long tempMem8b, Path path) {
        Unsafe.getUnsafe().putLong(tempMem8b, value);
        if (ff.write(fd, tempMem8b, 8L, offset) != 8L) {
            throw CairoException.critical(ff.errno()).put("could not write 8 bytes [path=").put(path).put(", fd=").put(fd).put(", offset=").put(offset).put(", value=").put(value).put(']');
        }
    }

    private static void createTableNameFile(MemoryMARW mem, CharSequence charSequence) {
        mem.putStr(charSequence);
        mem.putByte((byte)0);
        mem.close(true, (byte)1);
    }

    private static CharSequence getCharSequence(MemoryMR metaMem, long memSize, long offset, int strLength) {
        if (strLength < 1 || strLength > 255) {
            throw TableUtils.validationException(metaMem).put("String length of ").put(strLength).put(" is invalid at offset ").put(offset);
        }
        long storageLength = Vm.getStorageLength(strLength);
        if (offset + storageLength > memSize) {
            throw CairoException.critical(0).put("File is too small, size=").put(memSize).put(", required=").put(offset + storageLength);
        }
        return metaMem.getStr(offset);
    }

    private static int getInt(MemoryMR metaMem, long memSize, long offset) {
        if (memSize < offset + 4L) {
            throw CairoException.critical(0).put("File is too small, size=").put(memSize).put(", required=").put(offset + 4L);
        }
        return metaMem.getInt(offset);
    }

    static void createDirsOrFail(FilesFacade ff, Path path, int mkDirMode) {
        if (ff.mkdirs(path, mkDirMode) != 0) {
            throw CairoException.critical(ff.errno()).put("could not create directories [file=").put(path).put(']');
        }
    }

    static long getColumnFlags(MemoryR metaMem, int columnIndex) {
        return metaMem.getLong(128L + (long)columnIndex * 32L + 4L);
    }

    static int getIndexBlockCapacity(MemoryR metaMem, int columnIndex) {
        return metaMem.getInt(128L + (long)columnIndex * 32L + 4L + 8L);
    }

    static boolean isColumnIndexed(MemoryR metaMem, int columnIndex) {
        return (TableUtils.getColumnFlags(metaMem, columnIndex) & 1L) != 0L;
    }

    static boolean isSequential(MemoryR metaMem, int columnIndex) {
        return (TableUtils.getColumnFlags(metaMem, columnIndex) & 2L) != 0L;
    }

    static int openMetaSwapFile(FilesFacade ff, MemoryMA mem, Path path, int rootLen, int retryCount) {
        try {
            path.concat(META_SWAP_FILE_NAME).$();
            int l = path.length();
            int index = 0;
            while (true) {
                if (index > 0) {
                    path.trimTo(l).put('.').put(index);
                    path.$();
                }
                if (!ff.exists(path) || ff.remove(path)) {
                    try {
                        mem.smallFile(ff, path, 0);
                        mem.jumpTo(0L);
                        int n = index;
                        return n;
                    }
                    catch (CairoException e) {
                        LOG.error().$("could not open swap [file=").$(path).$(", errno=").$(e.getErrno()).$(']').$();
                        continue;
                    }
                }
                LOG.error().$("could not remove swap [file=").$(path).$(", errno=").$(ff.errno()).$(']').$();
                {
                    if (++index < retryCount) continue;
                    throw CairoException.critical(0).put("Cannot open indexed file. Max number of attempts reached [").put(index).put("]. Last file tried: ").put(path);
                }
                break;
            }
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void openMetaSwapFileByIndex(FilesFacade ff, MemoryMA mem, Path path, int rootLen, int swapIndex) {
        try {
            path.concat(META_SWAP_FILE_NAME);
            if (swapIndex > 0) {
                path.put('.').put(swapIndex);
            }
            path.$();
            mem.smallFile(ff, path, 0);
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    public static interface FailureCloseable {
        public void close(long var1);
    }
}

