/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.pool.ex.PoolClosedException;
import io.questdb.cairo.wal.seq.TableMetadataChangeLog;
import io.questdb.cairo.wal.seq.TableRecordMetadataSink;
import io.questdb.cairo.wal.seq.TableSequencerImpl;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjList;
import io.questdb.std.QuietCloseable;
import io.questdb.std.str.Path;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class TableSequencerAPI
implements QuietCloseable {
    private static final Log LOG = LogFactory.getLog(TableSequencerAPI.class);
    private final CairoConfiguration configuration;
    private final CairoEngine engine;
    private final long inactiveTtlUs;
    private final BiFunction<CharSequence, Object, TableSequencerEntry> openSequencerInstanceLambda;
    private final int recreateDistressedSequencerAttempts;
    private final ConcurrentHashMap<TableSequencerEntry> seqRegistry = new ConcurrentHashMap(false);
    private volatile boolean closed;

    public TableSequencerAPI(CairoEngine engine, CairoConfiguration configuration) {
        this.configuration = configuration;
        this.engine = engine;
        this.openSequencerInstanceLambda = this::openSequencerInstance;
        this.inactiveTtlUs = configuration.getInactiveWalWriterTTL() * 1000L;
        this.recreateDistressedSequencerAttempts = configuration.getWalRecreateDistressedSequencerAttempts();
    }

    @Override
    public void close() {
        this.closed = true;
        this.releaseAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSequencer(TableToken tableToken) {
        try (TableSequencerEntry sequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            try {
                ((TableSequencerImpl)sequencer).close();
            }
            finally {
                sequencer.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(TableToken tableToken, boolean failedCreate) {
        block17: {
            LOG.info().$("dropping wal table [name=").$(tableToken).$(", dirName=").utf8(tableToken.getDirName()).I$();
            try (TableSequencerEntry seq = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
                try {
                    seq.dropTable();
                }
                finally {
                    seq.unlockWrite();
                }
            }
            catch (CairoException e) {
                LOG.info().$("failed to drop wal table [name=").$(tableToken).$(", dirName=").utf8(tableToken.getDirName()).I$();
                if (failedCreate) break block17;
                throw e;
            }
        }
    }

    public void forAllWalTables(ObjList<TableToken> tableTokenBucket, boolean includeDropped, RegisteredTable callback) {
        CharSequence root = this.configuration.getRoot();
        FilesFacade ff = this.configuration.getFilesFacade();
        Path path = Path.PATH.get();
        this.engine.getTableTokens(tableTokenBucket, includeDropped);
        int n = tableTokenBucket.size();
        for (int i = 0; i < n; ++i) {
            boolean isDropped;
            TableToken tableToken = tableTokenBucket.getQuick(i);
            String publicTableName = tableToken.getTableName();
            boolean bl = isDropped = includeDropped && this.engine.isTableDropped(tableToken);
            if (this.engine.isWalTable(tableToken) && !isDropped) {
                long lastTxn;
                int tableId;
                block22: {
                    try {
                        if (!this.seqRegistry.containsKey(tableToken.getDirName())) {
                            path.of(root).concat(tableToken.getDirName()).concat("txn_seq");
                            tableId = tableToken.getTableId();
                            int fdTxn = TableUtils.openRO(ff, path, "_txnlog", LOG);
                            lastTxn = ff.readNonNegativeLong(fdTxn, 4L);
                            ff.close(fdTxn);
                            break block22;
                        }
                        try (TableSequencerEntry tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.NONE);){
                            lastTxn = tableSequencer.lastTxn();
                            tableId = tableSequencer.getTableId();
                        }
                    }
                    catch (CairoException ex) {
                        LOG.critical().$("could not read WAL table transaction file [table=").utf8(publicTableName).$(", errno=").$(ex.getErrno()).$(", error=").$(ex).I$();
                        continue;
                    }
                }
                if (tableId < 0 || lastTxn < 0L) {
                    LOG.critical().$("could not read WAL table metadata [table=").utf8(publicTableName).$(", tableId=").$(tableId).$(", lastTxn=").$(lastTxn).I$();
                    continue;
                }
                try {
                    callback.onTable(tableId, tableToken, lastTxn);
                }
                catch (CairoException ex) {
                    LOG.critical().$("could not process table sequencer [table=").utf8(publicTableName).$(", errno=").$(ex.getErrno()).$(", error=").$(ex).I$();
                }
                continue;
            }
            if (!isDropped) continue;
            try {
                callback.onTable(tableToken.getTableId(), tableToken, -1L);
                continue;
            }
            catch (CairoException ex) {
                LOG.critical().$("could not process table sequencer [table=").utf8(publicTableName).$(", errno=").$(ex.getErrno()).$(", error=").$(ex).I$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TransactionLogCursor getCursor(TableToken tableToken, long seqTxn) {
        try (TableSequencerEntry tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            TransactionLogCursor cursor;
            try {
                cursor = tableSequencer.getTransactionLogCursor(seqTxn);
            }
            finally {
                tableSequencer.unlockRead();
            }
            TransactionLogCursor transactionLogCursor = cursor;
            return transactionLogCursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TableMetadataChangeLog getMetadataChangeLog(TableToken tableToken, long structureVersionLo) {
        try (TableSequencerEntry tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            TableMetadataChangeLog metadataChangeLog;
            try {
                metadataChangeLog = tableSequencer.getMetadataChangeLog(structureVersionLo);
            }
            finally {
                tableSequencer.unlockRead();
            }
            TableMetadataChangeLog tableMetadataChangeLog = metadataChangeLog;
            return tableMetadataChangeLog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextWalId(TableToken tableToken) {
        try (TableSequencerEntry tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            int walId;
            try {
                walId = tableSequencer.getNextWalId();
            }
            finally {
                tableSequencer.unlockRead();
            }
            int n = walId;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTableMetadata(TableToken tableToken, TableRecordMetadataSink sink) {
        Throwable throwable = null;
        try (TableSequencerEntry tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            try {
                long l = tableSequencer.getTableMetadata(sink);
                tableSequencer.unlockRead();
                return l;
            }
            catch (Throwable throwable2) {
                try {
                    tableSequencer.unlockRead();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended(TableToken tableToken) {
        try (TableSequencerEntry sequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            boolean isSuspended;
            try {
                isSuspended = sequencer.isSuspended();
            }
            finally {
                sequencer.unlockRead();
            }
            boolean bl = isSuspended;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastTxn(TableToken tableName) {
        try (TableSequencerEntry sequencer = this.openSequencerLocked(tableName, SequencerLockType.READ);){
            long lastTxn;
            try {
                lastTxn = sequencer.lastTxn();
            }
            finally {
                sequencer.unlockRead();
            }
            long l = lastTxn;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextStructureTxn(TableToken tableToken, long structureVersion, AlterOperation alterOp) {
        try (TableSequencerEntry tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            long txn;
            try {
                txn = tableSequencer.nextStructureTxn(structureVersion, alterOp);
            }
            finally {
                tableSequencer.unlockWrite();
            }
            long l = txn;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextTxn(TableToken tableToken, int walId, long expectedSchemaVersion, int segmentId, int segmentTxn) {
        try (TableSequencerEntry tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            long txn;
            try {
                txn = tableSequencer.nextTxn(expectedSchemaVersion, walId, segmentId, segmentTxn);
            }
            finally {
                tableSequencer.unlockWrite();
            }
            long l = txn;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSequencer(TableToken tableToken) {
        try (TableSequencerEntry sequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            try {
                sequencer.open();
            }
            finally {
                sequencer.unlockWrite();
            }
        }
    }

    public void registerTable(int tableId, TableStructure tableStructure, TableToken tableToken) {
        try (TableSequencerEntry tableSequencer = this.getTableSequencerEntry(tableToken, SequencerLockType.WRITE, (key, tt1) -> {
            TableSequencerEntry sequencer = new TableSequencerEntry(this, this.engine, (TableToken)tt1);
            sequencer.create(tableId, tableStructure);
            sequencer.open();
            return sequencer;
        });){
            tableSequencer.unlockWrite();
        }
    }

    public boolean releaseAll() {
        return this.releaseAll(Long.MAX_VALUE);
    }

    public boolean releaseInactive() {
        return this.releaseAll(this.configuration.getMicrosecondClock().getTicks() - this.inactiveTtlUs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadMetadataConditionally(TableToken tableToken, long expectedStructureVersion, TableRecordMetadataSink sink) {
        try (TableSequencerEntry tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            try {
                if (tableSequencer.getStructureVersion() != expectedStructureVersion) {
                    tableSequencer.getTableMetadata(sink);
                }
            }
            finally {
                tableSequencer.unlockRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameWalTable(TableToken tableToken, TableToken newTableToken) {
        assert (tableToken.getDirName().equals(newTableToken.getDirName()));
        try (TableSequencerEntry sequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            try {
                sequencer.rename(newTableToken);
            }
            finally {
                sequencer.unlockWrite();
            }
        }
        LOG.advisory().$("renamed wal table [table=").utf8(tableToken.getTableName()).$(", newName=").utf8(newTableToken.getTableName()).$(", dirName=").utf8(newTableToken.getDirName()).I$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTable(TableToken tableToken, long resumeFromTxn, CairoSecurityContext cairoSecurityContext) {
        try (TableSequencerEntry sequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            try {
                if (!sequencer.isSuspended()) {
                    return;
                }
                long nextTxn = sequencer.lastTxn() + 1L;
                if (resumeFromTxn > nextTxn) {
                    throw CairoException.nonCritical().put("resume txn is higher than next available transaction [resumeFromTxn=").put(resumeFromTxn).put(", nextTxn=").put(nextTxn).put(']');
                }
                if (resumeFromTxn > 0L) {
                    try (TableWriter tableWriter = this.engine.getWriter(cairoSecurityContext, tableToken, "Resume WAL Data Application");){
                        long seqTxn = tableWriter.getSeqTxn();
                        if (resumeFromTxn - 1L > seqTxn) {
                            tableWriter.commitSeqTxn(resumeFromTxn - 1L);
                        }
                    }
                }
                sequencer.resumeTable();
            }
            finally {
                sequencer.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDistressed(TableToken tableToken) {
        try (TableSequencerEntry sequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            try {
                sequencer.setDistressed();
            }
            finally {
                sequencer.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTable(TableToken tableToken) {
        try (TableSequencerEntry sequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            try {
                sequencer.suspendTable();
            }
            finally {
                sequencer.unlockWrite();
            }
        }
    }

    @NotNull
    private TableSequencerEntry getTableSequencerEntry(TableToken tableToken, SequencerLockType lock, BiFunction<CharSequence, Object, TableSequencerEntry> getSequencerLambda) {
        int attempt = 0;
        while (attempt < this.recreateDistressedSequencerAttempts) {
            this.throwIfClosed();
            TableSequencerEntry entry = this.seqRegistry.computeIfAbsent(tableToken.getDirName(), tableToken, getSequencerLambda);
            if (lock == SequencerLockType.READ) {
                entry.readLock();
            } else if (lock == SequencerLockType.WRITE) {
                entry.writeLock();
            }
            boolean isDistressed = entry.isDistressed();
            if (!isDistressed && !entry.isClosed()) {
                return entry;
            }
            if (lock == SequencerLockType.READ) {
                entry.unlockRead();
            } else if (lock == SequencerLockType.WRITE) {
                entry.unlockWrite();
            }
            if (!isDistressed) continue;
            ++attempt;
        }
        throw CairoException.critical(0).put("sequencer is distressed [table=").put(tableToken.getDirName()).put(']');
    }

    private TableSequencerEntry openSequencerInstance(CharSequence tableDir, Object tableToken) {
        TableSequencerEntry sequencer = new TableSequencerEntry(this, this.engine, (TableToken)tableToken);
        sequencer.open();
        return sequencer;
    }

    @NotNull
    private TableSequencerEntry openSequencerLocked(TableToken tableToken, SequencerLockType lock) {
        return this.getTableSequencerEntry(tableToken, lock, this.openSequencerInstanceLambda);
    }

    private boolean releaseEntries(long deadline) {
        if (this.seqRegistry.size() == 0) {
            return true;
        }
        boolean removed = false;
        for (CharSequence tableDir : this.seqRegistry.keySet()) {
            TableSequencerEntry sequencer = this.seqRegistry.get(tableDir);
            if (sequencer == null || deadline < sequencer.releaseTime || sequencer.isClosed() || !sequencer.checkClose()) continue;
            LOG.info().$("releasing idle table sequencer [tableDir=").utf8(tableDir).I$();
            this.seqRegistry.remove(tableDir, sequencer);
            removed = true;
        }
        return removed;
    }

    private void throwIfClosed() {
        if (this.closed) {
            LOG.info().$("is closed").$();
            throw PoolClosedException.INSTANCE;
        }
    }

    protected boolean releaseAll(long deadline) {
        return this.releaseEntries(deadline);
    }

    private static class TableSequencerEntry
    extends TableSequencerImpl {
        private final TableSequencerAPI pool;
        private volatile long releaseTime = Long.MAX_VALUE;

        TableSequencerEntry(TableSequencerAPI pool, CairoEngine engine, TableToken tableToken) {
            super(engine, tableToken);
            this.pool = pool;
        }

        @Override
        public void close() {
            if (!this.pool.closed) {
                if (!this.isDistressed() && !this.isDropped()) {
                    this.releaseTime = this.pool.configuration.getMicrosecondClock().getTicks();
                } else if (this.checkClose()) {
                    LOG.info().$("closed distressed table sequencer [table=").$(this.getTableToken()).I$();
                    this.pool.seqRegistry.remove(this.getTableToken().getDirName(), this);
                }
            } else {
                super.close();
            }
        }
    }

    @FunctionalInterface
    public static interface RegisteredTable {
        public void onTable(int var1, TableToken var2, long var3);
    }

    static enum SequencerLockType {
        WRITE,
        READ,
        NONE;

    }
}

