/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Os;

public class FlushQueryCacheFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog("flush-query-cache");
    private static final String SIGNATURE = "flush_query_cache()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new FlushQueryCacheFunction(sqlExecutionContext.getMessageBus());
    }

    private static class FlushQueryCacheFunction
    extends BooleanFunction {
        private final MessageBus messageBus;

        public FlushQueryCacheFunction(MessageBus messageBus) {
            this.messageBus = messageBus;
        }

        @Override
        public boolean getBool(Record rec) {
            LOG.info().$("flushing query caches").$();
            while (true) {
                long pubCursor;
                if ((pubCursor = this.messageBus.getQueryCacheEventPubSeq().next()) > -1L) {
                    this.messageBus.getQueryCacheEventPubSeq().done(pubCursor);
                    return true;
                }
                if (pubCursor == -1L) {
                    LOG.error().$("cannot publish flush query cache event to a full queue").$();
                    return false;
                }
                Os.pause();
            }
        }

        @Override
        public boolean isReadThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(FlushQueryCacheFunctionFactory.SIGNATURE);
        }
    }
}

