/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.BinFunction;
import io.questdb.std.BinarySequence;
import io.questdb.std.ObjList;

public class BinColumn
extends BinFunction
implements ScalarFunction {
    private static final ObjList<BinColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    public BinColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static BinColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new BinColumn(columnIndex);
    }

    @Override
    public BinarySequence getBin(Record rec) {
        return rec.getBin(this.columnIndex);
    }

    @Override
    public long getBinLen(Record rec) {
        return rec.getBinLen(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.putColumnName(this.columnIndex);
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new BinColumn(i));
        }
    }
}

