/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cutlass.text.AtomicBooleanCircuitBreaker;
import io.questdb.cutlass.text.TextImportExecutionContext;
import io.questdb.cutlass.text.TextImportRequestTask;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.SingleValueRecordCursor;
import io.questdb.griffin.model.CopyModel;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.str.StringSink;

public class CopyFactory
extends AbstractRecordCursorFactory {
    private static final GenericRecordMetadata METADATA = new GenericRecordMetadata();
    private final int atomicity;
    private final byte delimiter;
    private final String fileName;
    private final boolean headerFlag;
    private final StringSink importIdSink = new StringSink();
    private final MessageBus messageBus;
    private final int partitionBy;
    private final ImportIdRecord record = new ImportIdRecord();
    private final SingleValueRecordCursor cursor = new SingleValueRecordCursor(this.record);
    private final String tableName;
    private final TextImportExecutionContext textImportExecutionContext;
    private final String timestampColumn;
    private final String timestampFormat;

    public CopyFactory(MessageBus messageBus, TextImportExecutionContext textImportExecutionContext, String tableName, String fileName, CopyModel model) {
        super(METADATA);
        this.messageBus = messageBus;
        this.textImportExecutionContext = textImportExecutionContext;
        this.tableName = tableName;
        this.fileName = fileName;
        this.headerFlag = model.isHeader();
        this.timestampColumn = Chars.toString(model.getTimestampColumnName());
        this.timestampFormat = Chars.toString(model.getTimestampFormat());
        this.delimiter = model.getDelimiter();
        this.partitionBy = model.getPartitionBy();
        this.atomicity = model.getAtomicity();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RingQueue<TextImportRequestTask> textImportRequestQueue = this.messageBus.getTextImportRequestQueue();
        MPSequence textImportRequestPubSeq = this.messageBus.getTextImportRequestPubSeq();
        AtomicBooleanCircuitBreaker circuitBreaker = this.textImportExecutionContext.getCircuitBreaker();
        long inProgressImportId = this.textImportExecutionContext.getActiveImportId();
        if (inProgressImportId == -1L) {
            long processingCursor = textImportRequestPubSeq.next();
            if (processingCursor > -1L) {
                TextImportRequestTask task = textImportRequestQueue.get(processingCursor);
                long importId = this.textImportExecutionContext.assignActiveImportId();
                task.of(importId, this.tableName, this.fileName, this.headerFlag, this.timestampColumn, this.delimiter, this.timestampFormat, this.partitionBy, this.atomicity);
                circuitBreaker.reset();
                textImportRequestPubSeq.done(processingCursor);
                this.importIdSink.clear();
                Numbers.appendHex(this.importIdSink, importId, true);
                this.record.setValue(this.importIdSink);
                this.cursor.toTop();
                return this.cursor;
            }
            throw SqlException.$(0, "Unable to process the import request. Another import request may be in progress.");
        }
        this.importIdSink.clear();
        Numbers.appendHex(this.importIdSink, inProgressImportId, true);
        throw SqlException.$(0, "Another import request is in progress. ").put("[activeImportId=").put(this.importIdSink).put(']');
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Copy");
    }

    static {
        METADATA.add(new TableColumnMetadata("id", 11));
    }

    private static class ImportIdRecord
    implements Record {
        private CharSequence value;

        private ImportIdRecord() {
        }

        @Override
        public CharSequence getStr(int col) {
            return this.value;
        }

        @Override
        public CharSequence getStrB(int col) {
            return this.getStr(col);
        }

        @Override
        public int getStrLen(int col) {
            return this.value.length();
        }

        public void setValue(CharSequence value) {
            this.value = value;
        }
    }
}

