/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.log.LogError;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecordSink;
import io.questdb.log.LogWriter;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class LogFileWriter
extends SynchronizedJob
implements Closeable,
LogWriter {
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private final int level;
    private final RingQueue<LogRecordSink> ring;
    private final SCSequence subSeq;
    private long _wptr;
    private long buf;
    private int bufSize;
    private String bufferSize;
    private int fd = -1;
    private long lim;
    private String location;
    private QueueConsumer<LogRecordSink> myConsumer = this::copyToBuffer;
    private String truncate;

    public LogFileWriter(RingQueue<LogRecordSink> ring, SCSequence subSeq, int level) {
        this.ring = ring;
        this.subSeq = subSeq;
        this.level = level;
    }

    @Override
    public void bindProperties(LogFactory factory) {
        if (this.bufferSize != null) {
            try {
                this.bufSize = Numbers.parseIntSize(this.bufferSize);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for bufferSize");
            }
        } else {
            this.bufSize = 0x100000;
        }
        this.buf = this._wptr = Unsafe.malloc(this.bufSize, 43);
        this.lim = this.buf + (long)this.bufSize;
        try (Path path = new Path().of(this.location).$();){
            if (this.truncate != null && Chars.equalsLowerCaseAscii(this.truncate, "true")) {
                this.fd = Files.openRW(path);
                Files.truncate(this.fd, 0L);
            } else {
                this.fd = Files.openAppend(path);
            }
        }
        if (this.fd == -1) {
            throw new LogError("Cannot open file for append: " + this.location + " [errno=" + Os.errno() + ']');
        }
    }

    @Override
    public void close() {
        if (this.buf != 0L) {
            if (this._wptr > this.buf) {
                this.flush();
            }
            Unsafe.free(this.buf, this.bufSize, 43);
            this.buf = 0L;
        }
        if (this.fd != -1) {
            Files.close(this.fd);
            this.fd = -1;
        }
    }

    public int getBufSize() {
        return this.bufSize;
    }

    @Override
    public boolean runSerially() {
        if (this.subSeq.consumeAll(this.ring, this.myConsumer)) {
            return true;
        }
        if (this._wptr > this.buf) {
            this.flush();
            return true;
        }
        return false;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    private void copyToBuffer(LogRecordSink sink) {
        int l = sink.length();
        if ((sink.getLevel() & this.level) != 0 && l > 0) {
            if (this._wptr + (long)l >= this.lim) {
                this.flush();
            }
            Vect.memcpy(this._wptr, sink.getAddress(), l);
            this._wptr += (long)l;
        }
    }

    private void flush() {
        Files.append(this.fd, this.buf, (int)(this._wptr - this.buf));
        this._wptr = this.buf;
    }

    QueueConsumer<LogRecordSink> getMyConsumer() {
        return this.myConsumer;
    }

    void setMyConsumer(QueueConsumer<LogRecordSink> myConsumer) {
        this.myConsumer = myConsumer;
    }
}

