/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.sql;

import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.flywaydb.core.api.executor.Context;
import org.flywaydb.core.api.executor.MigrationExecutor;
import org.flywaydb.core.internal.database.DatabaseExecutionStrategy;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;

public class SqlMigrationExecutor
implements MigrationExecutor {
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
    private final SqlScript sqlScript;
    private final boolean undo;
    private final boolean batch;

    @Override
    public List<Results> execute(Context context) throws SQLException {
        DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForConnection(context.getConnection(), context.getConfiguration());
        DatabaseExecutionStrategy strategy = databaseType.createExecutionStrategy(context.getConnection());
        return strategy.execute(() -> this.executeOnce(context));
    }

    private List<Results> executeOnce(Context context) {
        boolean outputQueryResults = context.getConfiguration().isOutputQueryResults();
        SqlScriptExecutor executorFactory = this.sqlScriptExecutorFactory.createSqlScriptExecutor(context.getConnection(), this.undo, this.batch, outputQueryResults);
        return executorFactory.execute(this.sqlScript, context.getConfiguration());
    }

    @Override
    public boolean canExecuteInTransaction() {
        return this.sqlScript.executeInTransaction();
    }

    @Override
    public boolean shouldExecute() {
        return this.sqlScript.shouldExecute();
    }

    @Override
    public String shouldExecuteExpression() {
        return this.sqlScript.shouldExecuteExpression();
    }

    @Generated
    public SqlMigrationExecutor(SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScript sqlScript, boolean undo, boolean batch) {
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
        this.sqlScript = sqlScript;
        this.undo = undo;
        this.batch = batch;
    }
}

