/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.filter;

import org.springframework.ldap.filter.AbstractFilter;
import org.springframework.ldap.support.LdapEncoder;
import org.springframework.util.Assert;

public abstract class CompareFilter
extends AbstractFilter {
    private final String attribute;
    private final String value;
    private final String encodedValue;
    private String operator;

    @Deprecated(since="3.3")
    public CompareFilter(String attribute, String value) {
        this.attribute = attribute;
        this.value = value;
        this.encodedValue = this.encodeValue(value);
    }

    String getEncodedValue() {
        return this.encodedValue;
    }

    @Deprecated(forRemoval=true, since="3.3")
    protected String encodeValue(String value) {
        return LdapEncoder.filterEncode(value);
    }

    @Deprecated(since="3.3")
    public CompareFilter(String attribute, int value) {
        this.attribute = attribute;
        this.value = String.valueOf(value);
        this.encodedValue = LdapEncoder.filterEncode(this.value);
    }

    protected CompareFilter(String attribute, String operator, String value, String encodedValue) {
        this.attribute = attribute;
        this.value = value;
        this.encodedValue = encodedValue;
        this.operator = operator;
    }

    @Override
    public StringBuffer encode(StringBuffer buff) {
        buff.append('(');
        buff.append(this.attribute).append(this.getCompareString()).append(this.encodedValue);
        buff.append(')');
        return buff;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompareFilter that = (CompareFilter)o;
        if (this.attribute != null ? !this.attribute.equals(that.attribute) : that.attribute != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result = this.attribute != null ? this.attribute.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Deprecated(forRemoval=true, since="3.3")
    protected String getCompareString() {
        Assert.notNull((Object)this.operator, (String)"Please supply the operator in the constructor. If needed, override getCompareString instead.");
        return this.operator;
    }
}

