/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.protocol.Protocol;
import org.apache.nutch.protocol.ProtocolNotFound;
import org.apache.nutch.util.ObjectCache;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ExtensionPoint extensionPoint;
    private Configuration conf;
    protected Map<String, String> defaultProtocolImplMapping = new HashMap<String, String>();
    protected Map<String, String> hostProtocolMapping = new HashMap<String, String>();

    public ProtocolFactory(Configuration conf) {
        this.conf = conf;
        this.extensionPoint = PluginRepository.get(conf).getExtensionPoint(Protocol.X_POINT_ID);
        if (this.extensionPoint == null) {
            throw new RuntimeException("x-point " + Protocol.X_POINT_ID + " not found.");
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(conf.getConfResourceAsReader("host-protocol-mapping.txt"));
            while ((line = reader.readLine()) != null) {
                if (!StringUtils.isNotBlank((CharSequence)line) || line.startsWith("#")) continue;
                String[] parts = (line = line.trim()).split("\t");
                if (parts.length == 2) {
                    if (parts[0].indexOf(":") == -1) {
                        this.hostProtocolMapping.put(parts[0].trim(), parts[1].trim());
                        continue;
                    }
                    String[] moreParts = parts[0].split(":");
                    this.defaultProtocolImplMapping.put(moreParts[1].trim(), parts[1].trim());
                    continue;
                }
                LOG.warn("Wrong format of line: {}", (Object)line);
                LOG.warn("Expected format: <hostname> <tab> <plugin_id> or protocol:<protocol> <tab> <plugin_id>");
            }
        }
        catch (IOException e) {
            LOG.error("Unable to read host-protocol-mapping.txt", (Throwable)e);
        }
    }

    public Protocol getProtocol(String urlString) throws ProtocolNotFound {
        try {
            URL url = new URL(urlString);
            return this.getProtocol(url);
        }
        catch (MalformedURLException e) {
            throw new ProtocolNotFound(urlString, e.toString());
        }
    }

    public Protocol getProtocol(URL url) throws ProtocolNotFound {
        try {
            Protocol protocol = null;
            String host = url.getHost();
            String domain = URLUtil.getDomainName(url).toLowerCase().trim();
            String hostOrDomain = null;
            Extension extension = null;
            if (this.hostProtocolMapping.containsKey(host)) {
                hostOrDomain = host;
            } else if (this.hostProtocolMapping.containsKey(domain)) {
                hostOrDomain = domain;
            }
            if (hostOrDomain != null && (extension = this.getExtensionById(this.hostProtocolMapping.get(hostOrDomain))) != null) {
                protocol = this.getProtocolInstanceByExtension(extension);
            }
            if (protocol == null && this.defaultProtocolImplMapping.containsKey(url.getProtocol()) && (extension = this.getExtensionById(this.defaultProtocolImplMapping.get(url.getProtocol()))) != null) {
                protocol = this.getProtocolInstanceByExtension(extension);
            }
            if (protocol == null && (extension = this.findExtension(url.getProtocol(), "protocolName")) != null) {
                protocol = this.getProtocolInstanceByExtension(extension);
            }
            if (protocol != null) {
                return protocol;
            }
            throw new ProtocolNotFound(url.toString());
        }
        catch (PluginRuntimeException e) {
            throw new ProtocolNotFound(url.toString(), e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Protocol getProtocolInstanceByExtension(Extension extension) throws PluginRuntimeException {
        ObjectCache objectCache;
        Protocol protocol = null;
        String cacheId = extension.getId();
        ObjectCache objectCache2 = objectCache = ObjectCache.get(this.conf);
        synchronized (objectCache2) {
            if (!objectCache.hasObject(cacheId)) {
                protocol = (Protocol)extension.getExtensionInstance();
                objectCache.setObject(cacheId, protocol);
            }
            protocol = (Protocol)objectCache.getObject(cacheId);
        }
        return protocol;
    }

    private Extension getExtensionById(String id) {
        Extension[] extensions = this.extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            if (!id.equals(extensions[i].getId())) continue;
            return extensions[i];
        }
        return null;
    }

    private Extension findExtension(String name, String attribute) throws PluginRuntimeException {
        for (int i = 0; i < this.extensionPoint.getExtensions().length; ++i) {
            Extension extension = this.extensionPoint.getExtensions()[i];
            if (!this.contains(name, extension.getAttribute(attribute))) continue;
            return extension;
        }
        return null;
    }

    boolean contains(String what, String where) {
        if (where != null) {
            String[] parts = where.split("[, ]");
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].equals(what)) continue;
                return true;
            }
        }
        return false;
    }

    public Protocol getProtocolById(String id) throws PluginRuntimeException {
        Extension ext = this.getExtensionById(id);
        if (ext == null) {
            throw new PluginRuntimeException("ID " + id + " not found");
        }
        return this.getProtocolInstanceByExtension(ext);
    }
}

