/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.util.ObjectCache;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;
import org.apache.tika.mime.MimeTypesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeUtil {
    private static final String SEPARATOR = ";";
    private MimeTypes mimeTypes;
    private Tika tika;
    private boolean mimeMagic;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void setPoolSize(int poolSize) {
        try {
            MimeTypesReader.setPoolSize((int)poolSize);
        }
        catch (TikaException e) {
            LOG.error("Failed to set pool size", (Throwable)e);
        }
    }

    public MimeUtil(Configuration conf) {
        MimeTypes mimeTypez;
        ObjectCache objectCache = ObjectCache.get(conf);
        this.tika = (Tika)objectCache.getObject(Tika.class.getName());
        if (this.tika == null) {
            this.tika = new Tika();
            objectCache.setObject(Tika.class.getName(), this.tika);
        }
        if ((mimeTypez = (MimeTypes)objectCache.getObject(MimeTypes.class.getName())) == null) {
            try {
                String customMimeTypeFile = conf.get("mime.types.file");
                if (customMimeTypeFile != null && !customMimeTypeFile.equals("")) {
                    try {
                        LOG.info("Using custom mime.types.file: {}", (Object)customMimeTypeFile);
                        mimeTypez = MimeTypesFactory.create((InputStream)conf.getConfResourceAsInputStream(customMimeTypeFile));
                    }
                    catch (Exception e) {
                        LOG.error("Can't load mime.types.file : {} using Tika's default", (Object)customMimeTypeFile);
                    }
                }
                if (mimeTypez == null) {
                    mimeTypez = MimeTypes.getDefaultMimeTypes();
                }
            }
            catch (Exception e) {
                LOG.error("Exception in MimeUtil {}", (Object)e.getMessage());
                throw new RuntimeException(e);
            }
            objectCache.setObject(MimeTypes.class.getName(), mimeTypez);
        }
        this.mimeTypes = mimeTypez;
        this.mimeMagic = conf.getBoolean("mime.type.magic", true);
    }

    public static String cleanMimeType(String origType) {
        if (origType == null) {
            return null;
        }
        String[] tokenizedMimeType = origType.split(SEPARATOR);
        if (tokenizedMimeType.length > 1) {
            return tokenizedMimeType[0];
        }
        return origType;
    }

    public String autoResolveContentType(String typeName, String url, byte[] data) {
        String retType = null;
        MimeType type = null;
        String cleanedMimeType = null;
        cleanedMimeType = MimeUtil.cleanMimeType(typeName);
        if (cleanedMimeType != null) {
            try {
                type = this.mimeTypes.forName(cleanedMimeType);
                cleanedMimeType = type.getName();
            }
            catch (MimeTypeException mte) {
                cleanedMimeType = null;
            }
        }
        if (type == null || type.getName().equals("application/octet-stream")) {
            try {
                retType = this.tika.detect(url) != null ? this.tika.detect(url) : null;
            }
            catch (Exception e) {
                String message = "Problem loading default Tika configuration";
                LOG.error(message, (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            retType = type.getName();
        }
        if (this.mimeMagic) {
            String magicType = null;
            Metadata tikaMeta = new Metadata();
            tikaMeta.add("resourceName", url);
            tikaMeta.add("Content-Type", cleanedMimeType != null ? cleanedMimeType : typeName);
            try (TikaInputStream stream = TikaInputStream.get((byte[])data);){
                magicType = this.mimeTypes.detect((InputStream)stream, tikaMeta).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (magicType != null && !magicType.equals("application/octet-stream") && retType != null && !retType.equals(magicType)) {
                retType = magicType;
            }
            if (retType == null) {
                try {
                    retType = "application/octet-stream";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return retType;
    }

    public String getMimeType(String url) {
        return this.tika.detect(url);
    }

    public String forName(String name) {
        try {
            return this.mimeTypes.forName(name).toString();
        }
        catch (MimeTypeException e) {
            LOG.error("Exception getting mime type by name: [{}]: Message: {}", (Object)name, (Object)e.getMessage());
            return null;
        }
    }

    public String getMimeType(File f) {
        try {
            return this.tika.detect(f);
        }
        catch (Exception e) {
            LOG.error("Exception getting mime type for file: [{}]: Message: {}", (Object)f.getPath(), (Object)e.getMessage());
            return null;
        }
    }
}

