/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.extension;

import crawlercommons.sitemaps.extension.ExtensionMetadata;
import java.io.Serializable;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class VideoAttributes
extends ExtensionMetadata {
    public static final String THUMBNAIL_LOC = "thumbnail_loc";
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String CONTENT_LOC = "content_loc";
    public static final String PLAYER_LOC = "player_loc";
    public static final String EXPIRATION_DATE = "expiration_date";
    public static final String RATING = "rating";
    public static final String VIEW_COUNT = "view_count";
    public static final String PUBLICATION_DATE = "publication_date";
    public static final String FAMILY_FRIENDLY = "family_friendly";
    public static final String TAGS = "tags";
    public static final String CATEGORY = "category";
    public static final String RESTRICTED_COUNTRIES = "restricted_countries";
    public static final String ALLOWED_COUNTRIES = "allowed_countries";
    public static final String GALLERY_LOC = "gallery_loc";
    public static final String GALLERY_TITLE = "gallery_title";
    public static final String PRICES = "prices";
    public static final String REQUIRES_SUBSCRIPTION = "requires_subscription";
    public static final String UPLOADER = "uploader";
    public static final String UPLOADER_INFO = "uploader_info";
    public static final String ALLOWED_PLATFORMS = "allowed_platforms";
    public static final String RESTRICTED_PLATFORMS = "restricted_platforms";
    public static final String IS_LIVE = "is_live";
    public static final String DURATION = "duration";
    private URL thumbnailLoc;
    private String title;
    private String description;
    private URL contentLoc;
    private URL playerLoc;
    private Integer duration;
    private ZonedDateTime expirationDate;
    private Float rating;
    private Integer viewCount;
    private ZonedDateTime publicationDate;
    private Boolean familyFriendly;
    private String[] tags;
    private String category;
    private String[] restrictedCountries;
    private String[] allowedCountries;
    private URL galleryLoc;
    private String galleryTitle;
    private VideoPrice[] prices;
    private Boolean requiresSubscription;
    private String uploader;
    private URL uploaderInfo;
    private String[] restrictedPlatforms;
    private String[] allowedPlatforms;
    private Boolean isLive;

    public URL getThumbnailLoc() {
        return this.thumbnailLoc;
    }

    public void setThumbnailLoc(URL thumbnailLoc) {
        this.thumbnailLoc = thumbnailLoc;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public URL getContentLoc() {
        return this.contentLoc;
    }

    public void setContentLoc(URL contentLoc) {
        this.contentLoc = contentLoc;
    }

    public URL getPlayerLoc() {
        return this.playerLoc;
    }

    public void setPlayerLoc(URL playerLoc) {
        this.playerLoc = playerLoc;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Date getExpirationDate() {
        if (this.expirationDate != null) {
            return Date.from(this.expirationDate.toInstant());
        }
        return null;
    }

    public ZonedDateTime getExpirationDateTime() {
        return this.expirationDate;
    }

    public void setExpirationDate(ZonedDateTime expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Float getRating() {
        return this.rating;
    }

    public void setRating(Float rating) {
        this.rating = rating;
    }

    public Integer getViewCount() {
        return this.viewCount;
    }

    public void setViewCount(Integer viewCount) {
        this.viewCount = viewCount;
    }

    public Date getPublicationDate() {
        if (this.publicationDate != null) {
            return Date.from(this.publicationDate.toInstant());
        }
        return null;
    }

    public ZonedDateTime getPublicationDateTime() {
        return this.publicationDate;
    }

    public void setPublicationDate(ZonedDateTime publicationDate) {
        this.publicationDate = publicationDate;
    }

    public Boolean getFamilyFriendly() {
        return this.familyFriendly;
    }

    public void setFamilyFriendly(Boolean familyFriendly) {
        this.familyFriendly = familyFriendly;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public void addTag(String tag) {
        String[] arr;
        if (tag == null) {
            return;
        }
        if (this.tags == null) {
            arr = new String[]{tag};
        } else {
            arr = Arrays.copyOf(this.tags, this.tags.length + 1);
            arr[this.tags.length] = tag;
        }
        this.tags = arr;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String[] getRestrictedCountries() {
        return this.restrictedCountries;
    }

    public void setRestrictedCountries(String[] restrictedCountries) {
        this.restrictedCountries = restrictedCountries;
    }

    public String[] getAllowedCountries() {
        return this.allowedCountries;
    }

    public void setAllowedCountries(String[] allowedCountries) {
        this.allowedCountries = allowedCountries;
    }

    public URL getGalleryLoc() {
        return this.galleryLoc;
    }

    public void setGalleryLoc(URL galleryLoc) {
        this.galleryLoc = galleryLoc;
    }

    public String getGalleryTitle() {
        return this.galleryTitle;
    }

    public void setGalleryTitle(String galleryTitle) {
        this.galleryTitle = galleryTitle;
    }

    public VideoPrice[] getPrices() {
        return this.prices;
    }

    public void setPrices(VideoPrice[] prices) {
        this.prices = prices;
    }

    public void addPrice(VideoPrice price) {
        VideoPrice[] arr;
        if (price == null) {
            return;
        }
        if (this.prices == null) {
            arr = new VideoPrice[]{price};
        } else {
            arr = Arrays.copyOf(this.prices, this.prices.length + 1);
            arr[this.prices.length] = price;
        }
        this.prices = arr;
    }

    public Boolean getRequiresSubscription() {
        return this.requiresSubscription;
    }

    public void setRequiresSubscription(Boolean requiresSubscription) {
        this.requiresSubscription = requiresSubscription;
    }

    public String getUploader() {
        return this.uploader;
    }

    public void setUploader(String uploader) {
        this.uploader = uploader;
    }

    public URL getUploaderInfo() {
        return this.uploaderInfo;
    }

    public void setUploaderInfo(URL uploaderInfo) {
        this.uploaderInfo = uploaderInfo;
    }

    public String[] getRestrictedPlatforms() {
        return this.restrictedPlatforms;
    }

    public void setRestrictedPlatforms(String[] restrictedPlatforms) {
        this.restrictedPlatforms = restrictedPlatforms;
    }

    public String[] getAllowedPlatforms() {
        return this.allowedPlatforms;
    }

    public void setAllowedPlatforms(String[] allowedPlatforms) {
        this.allowedPlatforms = allowedPlatforms;
    }

    public Boolean getLive() {
        return this.isLive;
    }

    public void setLive(Boolean live) {
        this.isLive = live;
    }

    public VideoAttributes() {
    }

    public VideoAttributes(URL thumbnailLoc, String title, String description, URL contentLoc, URL playerLoc) {
        this.thumbnailLoc = thumbnailLoc;
        this.title = title;
        this.description = description;
        this.contentLoc = contentLoc;
        this.playerLoc = playerLoc;
    }

    public String toString() {
        return "Video title: " + this.title + ", description: " + this.description + ", thumbnail: " + this.thumbnailLoc + ", contentLoc: " + this.contentLoc + ", playerLoc: " + this.playerLoc + ", prices: " + Arrays.toString(this.prices);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof VideoAttributes)) {
            return false;
        }
        VideoAttributes that = (VideoAttributes)other;
        return VideoAttributes.urlEquals(this.thumbnailLoc, that.thumbnailLoc) && Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description) && VideoAttributes.urlEquals(this.contentLoc, that.contentLoc) && VideoAttributes.urlEquals(this.playerLoc, that.playerLoc) && Objects.equals(this.duration, that.duration) && Objects.equals(this.expirationDate, that.expirationDate) && Objects.equals(this.rating, that.rating) && Objects.equals(this.viewCount, that.viewCount) && Objects.equals(this.publicationDate, that.publicationDate) && Objects.equals(this.familyFriendly, that.familyFriendly) && Objects.deepEquals(this.tags, that.tags) && Objects.equals(this.category, that.category) && Objects.deepEquals(this.restrictedCountries, that.restrictedCountries) && Objects.deepEquals(this.allowedCountries, that.allowedCountries) && VideoAttributes.urlEquals(this.galleryLoc, that.galleryLoc) && Objects.equals(this.galleryTitle, that.galleryTitle) && Objects.deepEquals(this.prices, that.prices) && Objects.equals(this.requiresSubscription, that.requiresSubscription) && Objects.equals(this.uploader, that.uploader) && Objects.equals(this.uploaderInfo, that.uploaderInfo) && Objects.deepEquals(this.allowedPlatforms, that.allowedPlatforms) && Objects.deepEquals(this.restrictedPlatforms, that.restrictedPlatforms) && Objects.equals(this.isLive, that.isLive);
    }

    @Override
    public boolean isValid() {
        return this.thumbnailLoc != null && this.title != null && this.title.length() <= 100 && this.description != null && this.description.length() <= 2048 && (this.contentLoc != null || this.playerLoc != null);
    }

    @Override
    public Map<String, String[]> asMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (this.thumbnailLoc != null) {
            map.put(THUMBNAIL_LOC, new String[]{this.thumbnailLoc.toString()});
        }
        if (this.title != null) {
            map.put(TITLE, new String[]{this.title});
        }
        if (this.description != null) {
            map.put(DESCRIPTION, new String[]{this.description});
        }
        if (this.contentLoc != null) {
            map.put(CONTENT_LOC, new String[]{this.contentLoc.toString()});
        }
        if (this.playerLoc != null) {
            map.put(PLAYER_LOC, new String[]{this.playerLoc.toString()});
        }
        if (this.expirationDate != null) {
            map.put(EXPIRATION_DATE, new String[]{this.expirationDate.toString()});
        }
        if (this.rating != null) {
            map.put(RATING, new String[]{this.rating.toString()});
        }
        if (this.viewCount != null) {
            map.put(VIEW_COUNT, new String[]{this.viewCount.toString()});
        }
        if (this.publicationDate != null) {
            map.put(PUBLICATION_DATE, new String[]{this.publicationDate.toString()});
        }
        if (this.familyFriendly != null) {
            map.put(FAMILY_FRIENDLY, new String[]{this.familyFriendly.toString()});
        }
        if (this.tags != null) {
            map.put(TAGS, this.tags);
        }
        if (this.category != null) {
            map.put(CATEGORY, new String[]{this.category});
        }
        if (this.restrictedCountries != null) {
            map.put(RESTRICTED_COUNTRIES, this.restrictedCountries);
        }
        if (this.allowedCountries != null) {
            map.put(ALLOWED_COUNTRIES, this.allowedCountries);
        }
        if (this.galleryLoc != null) {
            map.put(GALLERY_LOC, new String[]{this.galleryLoc.toString()});
        }
        if (this.galleryTitle != null) {
            map.put(GALLERY_TITLE, new String[]{this.galleryTitle});
        }
        if (this.prices != null) {
            String[] videoPricesArr = (String[])Arrays.stream(this.prices).map(VideoPrice::toString).toArray(String[]::new);
            map.put(PRICES, videoPricesArr);
        }
        if (this.requiresSubscription != null) {
            map.put(REQUIRES_SUBSCRIPTION, new String[]{this.requiresSubscription.toString()});
        }
        if (this.uploader != null) {
            map.put(UPLOADER, new String[]{this.uploader});
        }
        if (this.uploaderInfo != null) {
            map.put(UPLOADER_INFO, new String[]{this.uploaderInfo.toString()});
        }
        if (this.allowedPlatforms != null) {
            map.put(ALLOWED_PLATFORMS, this.allowedPlatforms);
        }
        if (this.restrictedPlatforms != null) {
            map.put(RESTRICTED_PLATFORMS, this.restrictedPlatforms);
        }
        if (this.isLive != null) {
            map.put(IS_LIVE, new String[]{this.isLive.toString()});
        }
        if (this.duration != null) {
            map.put(DURATION, new String[]{this.duration.toString()});
        }
        return Collections.unmodifiableMap(map);
    }

    public static final class VideoPrice
    implements Serializable {
        private final String currency;
        private final VideoPriceType type;
        private final VideoPriceResolution resolution;
        private Float price;

        public VideoPrice(String currency, Float price) {
            this(currency, price, VideoPriceType.own);
        }

        public VideoPrice(String currency, Float price, VideoPriceType type) {
            this(currency, price, type, null);
        }

        public VideoPrice(String currency, Float price, VideoPriceType type, VideoPriceResolution resolution) {
            this.currency = currency;
            this.price = price;
            this.type = type;
            this.resolution = resolution;
        }

        public String toString() {
            return String.format(Locale.ENGLISH, "value: %.2f, currency: %s, type: %s, resolution: %s", new Object[]{this.price, this.currency, this.type, this.resolution});
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof VideoPrice)) {
                return false;
            }
            VideoPrice that = (VideoPrice)other;
            return Objects.equals(this.currency, that.currency) && Objects.equals(this.price, that.price) && this.type == that.type && Objects.equals((Object)this.resolution, (Object)that.resolution);
        }

        public String getCurrency() {
            return this.currency;
        }

        public VideoPriceType getType() {
            return this.type;
        }

        public VideoPriceResolution getResolution() {
            return this.resolution;
        }

        public Float getPrice() {
            return this.price;
        }

        public void setPrice(Float price) {
            this.price = price;
        }
    }

    public static enum VideoPriceResolution {
        SD,
        HD;

    }

    public static enum VideoPriceType {
        own,
        rent;

    }
}

