/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.warc.record;

import java.util.logging.Logger;
import org.archive.format.dns.DNSRecord;
import org.archive.format.dns.DNSResponse;
import org.archive.resource.AbstractEmptyResource;
import org.archive.resource.MetaData;
import org.archive.resource.ResourceConstants;
import org.archive.resource.ResourceContainer;
import org.json.JSONException;
import org.json.JSONObject;

public class DNSResource
extends AbstractEmptyResource
implements ResourceConstants {
    private static final Logger LOG = Logger.getLogger(DNSResource.class.getName());

    public DNSResource(MetaData metaData, ResourceContainer container, DNSResponse response) {
        super(metaData, container);
        metaData.putString("Date", response.getDate());
        try {
            for (DNSRecord rec : response) {
                JSONObject rjo = new JSONObject();
                rjo.put("Name", (Object)rec.getName());
                rjo.put("TTL", rec.getTtl());
                rjo.put("Net-Class", (Object)rec.getNetClass());
                rjo.put("Type", (Object)rec.getType());
                rjo.put("Value", (Object)rec.getValue());
                metaData.appendChild("Entries", rjo);
            }
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
        }
    }
}

