/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.nio.ByteBuffer;
import java.util.Objects;

public class VersionedMetadata {
    public static final VersionedMetadata EMPTY = new VersionedMetadata(0, ByteBuffer.allocate(0));
    private final short version;
    private final ByteBuffer metadata;

    public VersionedMetadata(short version, ByteBuffer metadata) {
        this.version = version;
        this.metadata = Objects.requireNonNull(metadata);
    }

    public short version() {
        return this.version;
    }

    public ByteBuffer metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedMetadata that = (VersionedMetadata)o;
        if (this.version != that.version) {
            return false;
        }
        return this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        int result = this.version;
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public String toString() {
        return "VersionedMetadata(version=" + this.version + ", metadata=" + this.metadata + ')';
    }
}

