/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Logging;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.TraversableLikeExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.generic.IsTraversableLike$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CoreUtils$ {
    public static CoreUtils$ MODULE$;
    private final Logger logger;
    private final InetAddressValidator inetAddressValidator;

    static {
        new CoreUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    private InetAddressValidator inetAddressValidator() {
        return this.inetAddressValidator;
    }

    public void swallow(Function0<BoxedUnit> action, Logging logging, Level logLevel) {
        try {
            action.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if (Level.ERROR.equals(logLevel)) {
                logging.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
            if (Level.WARN.equals(logLevel)) {
                logging.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
            if (Level.INFO.equals(logLevel)) {
                logging.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
            if (Level.DEBUG.equals(logLevel)) {
                logging.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
            if (Level.TRACE.equals(logLevel)) {
                logging.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
            throw new MatchError((Object)logLevel);
        }
    }

    public Level swallow$default$3() {
        return Level.WARN;
    }

    public void delete(Seq<String> files) {
        files.foreach((Function1 & Serializable & scala.Serializable)f -> {
            CoreUtils$.$anonfun$delete$1(f);
            return BoxedUnit.UNIT;
        });
    }

    public boolean registerMBean(Object mbean, String name) {
        boolean bl;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mbs) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : mbs
                bl = bl2;
            }
        }
        catch (Exception e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(25).append("Failed to register Mbean ").append(name).toString(), (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }

    public Map<String, String> parseCsvMap(String str) {
        HashMap map = new HashMap();
        if ("".equals(str)) {
            return map;
        }
        Tuple2[] keyVals = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])str.split("\\s*,\\s*"))).map((Function1 & Serializable & scala.Serializable)s -> {
            int lio = s.lastIndexOf(":");
            return new Tuple2((Object)s.substring(0, lio).trim(), (Object)s.substring(lio + 1).trim());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyVals)).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<String> parseCsvList(String csvList) {
        if (csvList == null || csvList.isEmpty()) {
            return Nil$.MODULE$;
        }
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])csvList.split("\\s*,\\s*"))).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$parseCsvList$1(v))));
    }

    public <T> T createObject(String className, Seq<Object> args) {
        return (T)Class.forName(className, true, Utils.getContextOrKafkaClassLoader()).getConstructor((Class[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getClass(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class))).newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public <T> T inLock(Lock lock, Function0<T> fun) {
        Object object;
        lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public <T> T inReadLock(ReadWriteLock lock, Function0<T> fun) {
        Object object;
        Lock inLock_lock = lock.readLock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public <T> T inWriteLock(ReadWriteLock lock, Function0<T> fun) {
        Object object;
        Lock inLock_lock = lock.writeLock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public <T> Iterable<T> duplicates(Iterable<T> s) {
        return ((MapLike)((TraversableLike)s.groupBy((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                Object k = x0$1._1();
                Iterable l = (Iterable)x0$1._2();
                return new Tuple2(k, (Object)BoxesRunTime.boxToInteger((int)l.size()));
            }
            throw new MatchError(null);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$duplicates$3(x0$2)))).keys();
    }

    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        return this.listenerListToEndPoints(listeners, securityProtocolMap, true);
    }

    public void checkDuplicateListenerPorts(Seq<EndPoint> endpoints, String listeners) {
        Seq distinctPorts = (Seq)((SeqLike)endpoints.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.port()), Seq$.MODULE$.canBuildFrom())).distinct();
        Predef$.MODULE$.require(distinctPorts.size() == ((SeqLike)endpoints.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.port()), Seq$.MODULE$.canBuildFrom())).size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Each listener must have a different port, listeners: ").append(listeners).toString());
    }

    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap, boolean requireDistinctPorts) {
        Seq seq;
        try {
            seq = (Seq)this.parseCsvList(listeners).map((Function1 & Serializable & scala.Serializable)x$6 -> EndPoint$.MODULE$.createEndPoint((String)x$6, (Option<Map<ListenerName, SecurityProtocol>>)new Some((Object)securityProtocolMap)), Seq$.MODULE$.canBuildFrom());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Error creating broker listeners from '").append(listeners).append("': ").append(e.getMessage()).toString(), e);
        }
        Seq endPoints = seq;
        this.validate$1(endPoints, listeners, requireDistinctPorts);
        return endPoints;
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.getBytesFromUuid(uuid));
    }

    public byte[] getBytesFromUuid(UUID uuid) {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    public Properties propsWith(String key, String value) {
        return this.propsWith((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)value)}));
    }

    public Properties propsWith(Seq<Tuple2<String, String>> props) {
        Properties properties = new Properties();
        props.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return properties.put(k, v);
            }
            throw new MatchError(null);
        });
        return properties;
    }

    public <K, V> V atomicGetOrUpdate(scala.collection.concurrent.Map<K, V> map, K key, Function0<V> createValue) {
        Option option = map.get(key);
        if (option instanceof Some) {
            return (V)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            Object value = createValue.apply();
            return (V)map.putIfAbsent(key, value).getOrElse((Function0 & Serializable & scala.Serializable)() -> value);
        }
        throw new MatchError((Object)option);
    }

    public <T, K, B> Map<K, B> groupMapReduce(Iterable<T> elements, Function1<T, K> key, Function1<T, B> f, Function2<B, B, B> reduce) {
        return TraversableLikeExtensionMethods$.MODULE$.groupMapReduce$extension(package$.MODULE$.toTraversableLikeExtensionMethods(elements, IsTraversableLike$.MODULE$.genTraversableLikeRepr((Function1)Predef$.MODULE$.$conforms())), key, f, reduce);
    }

    public Map<Object, Seq<Object>> replicaToBrokerAssignmentAsScala(java.util.Map<Integer, List<Integer>> map) {
        return (Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1 & Serializable & scala.Serializable)e -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)e._1())), ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((List)e._2()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)CoreUtils$.$anonfun$replicaToBrokerAssignmentAsScala$2(x$7)), Buffer$.MODULE$.canBuildFrom())), Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$delete$1(String f) {
        Utils.delete((File)new File(f));
    }

    public static final /* synthetic */ boolean $anonfun$parseCsvList$1(String v) {
        return !v.equals("");
    }

    public static final /* synthetic */ boolean $anonfun$duplicates$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._2$mcI$sp() > 1;
        }
        throw new MatchError(null);
    }

    private final boolean validateOneIsIpv4AndOtherIpv6$1(String first, String second) {
        return this.inetAddressValidator().isValidInet4Address(first) && this.inetAddressValidator().isValidInet6Address(second) || this.inetAddressValidator().isValidInet6Address(first) && this.inetAddressValidator().isValidInet4Address(second);
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$3(EndPoint ep) {
        return ep.port() != 0;
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$5(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Seq)x0$1._2()).size() > 1;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$7(EndPoint ep) {
        return ep.host() != null && MODULE$.inetAddressValidator().isValid(ep.host());
    }

    public static final /* synthetic */ void $anonfun$listenerListToEndPoints$8(CoreUtils$ $this, boolean requireDistinctPorts$1, String listeners$2, Tuple2 x0$3) {
        if (x0$3 != null) {
            int port = x0$3._1$mcI$sp();
            Tuple2 tuple2 = (Tuple2)x0$3._2();
            if (tuple2 != null) {
                Seq duplicatesWithIpHosts = (Seq)tuple2._1();
                Seq duplicatesWithoutIpHosts = (Seq)tuple2._2();
                if (requireDistinctPorts$1) {
                    MODULE$.checkDuplicateListenerPorts((Seq<EndPoint>)duplicatesWithoutIpHosts, listeners$2);
                }
                if (duplicatesWithIpHosts.isEmpty()) {
                    return;
                }
                Some some = Seq$.MODULE$.unapplySeq(duplicatesWithIpHosts);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    EndPoint ep1 = (EndPoint)((SeqLike)some.get()).apply(0);
                    EndPoint ep2 = (EndPoint)((SeqLike)some.get()).apply(1);
                    if (requireDistinctPorts$1) {
                        String errorMessage = new StringBuilder(108).append("If you have two listeners on ").append("the same port then one needs to be IPv4 and the other IPv6, listeners: ").append(listeners$2).append(", port: ").append(port).toString();
                        Predef$.MODULE$.require($this.validateOneIsIpv4AndOtherIpv6$1(ep1.host(), ep2.host()), (Function0 & Serializable & scala.Serializable)() -> errorMessage);
                        if (duplicatesWithoutIpHosts.nonEmpty()) {
                            throw new IllegalArgumentException(errorMessage);
                        }
                    }
                } else if (requireDistinctPorts$1) {
                    throw new IllegalArgumentException(new StringBuilder(136).append("Each listener must have a different port unless exactly one listener has ").append("an IPv4 address and the other IPv6 address, listeners: ").append(listeners$2).append(", port: ").append(port).toString());
                }
                return;
            }
        }
        throw new MatchError((Object)x0$3);
    }

    /*
     * WARNING - void declaration
     */
    private final void validate$1(Seq endPoints, String listeners$2, boolean requireDistinctPorts$1) {
        void var6_6;
        Seq distinctListenerNames = (Seq)((SeqLike)endPoints.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.listenerName(), Seq$.MODULE$.canBuildFrom())).distinct();
        Predef$.MODULE$.require(distinctListenerNames.size() == endPoints.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Each listener must have a different name, listeners: ").append(listeners$2).toString());
        Tuple2 tuple2 = ((TraversableLike)endPoints.filter((Function1 & Serializable & scala.Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$listenerListToEndPoints$3(ep)))).groupBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.port())).partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$listenerListToEndPoints$5(x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Map duplicatePorts = (scala.collection.immutable.Map)tuple2._1();
        ((scala.collection.immutable.Map)var6_6.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                int port = x0$2._1$mcI$sp();
                Seq eps = (Seq)x0$2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)port), (Object)eps.partition((Function1 & Serializable & scala.Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$listenerListToEndPoints$7(ep))));
            }
            throw new MatchError(null);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            CoreUtils$.$anonfun$listenerListToEndPoints$8(this, requireDistinctPorts$1, listeners$2, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$replicaToBrokerAssignmentAsScala$2(Integer x$7) {
        return BoxesRunTime.unboxToInt((Object)x$7);
    }

    private CoreUtils$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.inetAddressValidator = InetAddressValidator.getInstance();
    }
}

