/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.opensearch.cluster.metadata.DataStream;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.MetadataFieldMapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.lookup.SearchLookup;

public class DataStreamFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_data_stream_timestamp";
    public static final String CONTENT_TYPE = "_data_stream_timestamp";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(context -> new DataStreamFieldMapper(false, Defaults.TIMESTAMP_FIELD), context -> new Builder());
    private final boolean enabled;
    private final DataStream.TimestampField timestampField;

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    private static DataStreamFieldMapper toType(FieldMapper in) {
        return (DataStreamFieldMapper)in;
    }

    protected DataStreamFieldMapper(boolean enabled, DataStream.TimestampField timestampField) {
        super(DataStreamFieldType.INSTANCE);
        this.enabled = enabled;
        this.timestampField = timestampField;
    }

    @Override
    protected String contentType() {
        return "_data_stream_timestamp";
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        if (!this.enabled) {
            return;
        }
        ParseContext.Document document = context.doc();
        IndexableField[] fields = document.getFields(this.timestampField.getName());
        long numTimestampValues = Arrays.stream(fields).filter(field -> field.fieldType().docValuesType() == DocValuesType.SORTED_NUMERIC).count();
        if (numTimestampValues != 1L) {
            throw new IllegalArgumentException("documents must contain a single-valued timestamp field '" + this.timestampField.getName() + "' of date type");
        }
    }

    public static final class DataStreamFieldType
    extends MappedFieldType {
        public static final DataStreamFieldType INSTANCE = new DataStreamFieldType();

        private DataStreamFieldType() {
            super("_data_stream_timestamp", false, false, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.typeName() + "]");
        }

        @Override
        public String typeName() {
            return "_data_stream_timestamp";
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("Cannot run term query on internal field [" + this.typeName() + "]");
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Cannot run exists query on internal field [" + this.typeName() + "]");
        }
    }

    public static final class Builder
    extends MetadataFieldMapper.Builder {
        final ParametrizedFieldMapper.Parameter<Boolean> enabledParam = ParametrizedFieldMapper.Parameter.boolParam("enabled", false, mapper -> DataStreamFieldMapper.access$200(DataStreamFieldMapper.toType(mapper)), false);
        final ParametrizedFieldMapper.Parameter<DataStream.TimestampField> timestampFieldParam = new ParametrizedFieldMapper.Parameter<DataStream.TimestampField>("timestamp_field", false, () -> Defaults.TIMESTAMP_FIELD, (n, c, o) -> new DataStream.TimestampField((String)((Map)o).get("name")), mapper -> DataStreamFieldMapper.access$100(DataStreamFieldMapper.toType(mapper)));

        protected Builder() {
            super("_data_stream_timestamp");
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Collections.unmodifiableList(Arrays.asList(this.enabledParam, this.timestampFieldParam));
        }

        @Override
        public MetadataFieldMapper build(Mapper.BuilderContext context) {
            return new DataStreamFieldMapper(this.enabledParam.getValue(), this.timestampFieldParam.getValue());
        }
    }

    public static final class Defaults {
        public static final boolean ENABLED = false;
        public static final DataStream.TimestampField TIMESTAMP_FIELD = new DataStream.TimestampField("@timestamp");
    }
}

