/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.pcollections.AbstractUnmodifiableSet;
import org.pcollections.KVTree;
import org.pcollections.PSortedSet;

public final class TreePSet<E>
extends AbstractUnmodifiableSet<E>
implements PSortedSet<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final KVTree<E, ?> tree;
    private final Comparator<? super E> ltrComparator;
    private final boolean isLeftToRight;

    TreePSet(KVTree<E, ?> tree, Comparator<? super E> ltrComparator, boolean isLeftToRight) {
        this.tree = Objects.requireNonNull(tree, "tree is null");
        this.ltrComparator = Objects.requireNonNull(ltrComparator, "comparator is null");
        this.isLeftToRight = isLeftToRight;
    }

    public static <E extends Comparable<? super E>> TreePSet<E> empty() {
        return TreePSet.empty(Comparator.naturalOrder());
    }

    public static <E> TreePSet<E> empty(Comparator<? super E> comparator) {
        return new TreePSet<E>(KVTree.empty(), comparator, true);
    }

    public static <E extends Comparable<? super E>> TreePSet<E> from(Collection<? extends E> list) {
        return TreePSet.from(Comparator.naturalOrder(), list);
    }

    public static <E> TreePSet<E> from(Comparator<? super E> comparator, Collection<? extends E> list) {
        return TreePSet.empty(comparator).plusAll((Collection)list);
    }

    public static <E> TreePSet<E> fromSortedSet(SortedSet<E> set) {
        if (Objects.requireNonNull(set, "set is null") instanceof TreePSet) {
            return (TreePSet)set;
        }
        KVTree tree = KVTree.fromKeyIterator(set.iterator());
        Iterator treeIterator = tree.entryIterator(true);
        while (treeIterator.hasNext()) {
            Objects.requireNonNull(treeIterator.next().getKey(), "set contains null element");
        }
        Comparator thatComparator = set.comparator();
        Comparator comparator = thatComparator == null ? (Comparator)TreePSet.sneakilyDowncast(Comparator.naturalOrder()) : thatComparator;
        return new TreePSet(tree, comparator, true);
    }

    @SafeVarargs
    public static <E extends Comparable<? super E>> TreePSet<E> of(E ... elements) {
        return TreePSet.of(Comparator.naturalOrder(), elements);
    }

    @SafeVarargs
    public static <E> TreePSet<E> of(Comparator<? super E> comparator, E ... elements) {
        return TreePSet.empty(comparator).plusAll((Collection)Arrays.asList(elements));
    }

    public static <E extends Comparable<? super E>> TreePSet<E> singleton(E e) {
        return TreePSet.singleton(Comparator.naturalOrder(), e);
    }

    public static <E> TreePSet<E> singleton(Comparator<? super E> comparator, E e) {
        return TreePSet.empty(comparator).plus((Object)e);
    }

    public static <E extends Comparable<? super E>> Collector<E, ?, TreePSet<E>> toTreePSet() {
        return TreePSet.toTreePSet(Comparator.naturalOrder());
    }

    public static <E> Collector<E, ?, TreePSet<E>> toTreePSet(Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(comparator)), set -> TreePSet.fromSortedSet(set));
    }

    @Override
    public E ceiling(E e) {
        return this.search(e, KVTree.SearchType.GE, KVTree.SearchType.LE);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.isLeftToRight ? this.ltrComparator : this.ltrComparator.reversed();
    }

    @Override
    public boolean contains(Object e) {
        return this.search(TreePSet.sneakilyDowncast(e), KVTree.SearchType.EQ, KVTree.SearchType.EQ) != null;
    }

    @Override
    public Iterator<E> descendingIterator() {
        return ((TreePSet)this.descendingSet()).iterator();
    }

    @Override
    public TreePSet<E> descendingSet() {
        return new TreePSet<E>(this.tree, this.ltrComparator, !this.isLeftToRight);
    }

    @Override
    public E first() {
        return (this.isLeftToRight ? this.tree.getLeftmost() : this.tree.getRightmost()).getKey();
    }

    @Override
    public E floor(E e) {
        return this.search(e, KVTree.SearchType.LE, KVTree.SearchType.GE);
    }

    @Override
    public TreePSet<E> headSet(E toElement) {
        return this.headSet((Object)toElement, false);
    }

    @Override
    public TreePSet<E> headSet(E toElement, boolean inclusive) {
        Objects.requireNonNull(toElement, "toElement is null");
        return this.withTree(this.isLeftToRight ? this.tree.rangeToLeft(toElement, inclusive, this.ltrComparator) : this.tree.rangeToRight(toElement, inclusive, this.ltrComparator));
    }

    @Override
    public E higher(E e) {
        return this.search(e, KVTree.SearchType.GT, KVTree.SearchType.LT);
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<Map.Entry<E, ?>> entryIterator = this.tree.entryIterator(this.isLeftToRight);
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return entryIterator.hasNext();
            }

            @Override
            public E next() {
                return ((Map.Entry)entryIterator.next()).getKey();
            }
        };
    }

    @Override
    public E last() {
        return (this.isLeftToRight ? this.tree.getRightmost() : this.tree.getLeftmost()).getKey();
    }

    @Override
    public E lower(E e) {
        return this.search(e, KVTree.SearchType.LT, KVTree.SearchType.GT);
    }

    @Override
    public TreePSet<E> minus(Object e) {
        return this.withTree(this.tree.minus(TreePSet.sneakilyDowncast(Objects.requireNonNull(e, "element is null")), this.ltrComparator));
    }

    @Override
    public TreePSet<E> minusAll(Collection<?> list) {
        KVTree<Object, ?> tree = this.tree;
        for (Object e : Objects.requireNonNull(list, "list is null")) {
            Objects.requireNonNull(e, "list contains null element");
            tree = tree.minus(TreePSet.sneakilyDowncast(e), this.ltrComparator);
        }
        return this.withTree(tree);
    }

    @Override
    public TreePSet<E> intersect(Collection<? extends E> list) {
        return this.minusAll((Collection)this.minusAll((Collection)list));
    }

    @Override
    public TreePSet<E> minusFirst() {
        return this.withTree(this.isLeftToRight ? this.tree.minusLeftmost() : this.tree.minusRightmost());
    }

    @Override
    public TreePSet<E> minusLast() {
        return this.withTree(this.isLeftToRight ? this.tree.minusRightmost() : this.tree.minusLeftmost());
    }

    @Override
    public TreePSet<E> plus(E e) {
        return this.withTree(this.tree.plus(Objects.requireNonNull(e, "element is null"), null, this.ltrComparator));
    }

    @Override
    public TreePSet<E> plusAll(Collection<? extends E> list) {
        KVTree<Object, Object> tree = this.tree;
        for (E e : Objects.requireNonNull(list, "list is null")) {
            tree = tree.plus(Objects.requireNonNull(e, "list contains null element"), null, this.ltrComparator);
        }
        return this.withTree(tree);
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public TreePSet<E> subSet(E fromElement, E toElement) {
        return this.subSet((Object)fromElement, true, (Object)toElement, false);
    }

    @Override
    public TreePSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        Objects.requireNonNull(fromElement, "fromElement is null");
        Objects.requireNonNull(fromElement, "toElement is null");
        if (this.comparator().compare(fromElement, toElement) > 0) {
            throw new IllegalArgumentException("fromElement > toElement");
        }
        return this.withTree(this.isLeftToRight ? this.tree.range(fromElement, fromInclusive, toElement, toInclusive, this.ltrComparator) : this.tree.range(toElement, toInclusive, fromElement, fromInclusive, this.ltrComparator));
    }

    @Override
    public TreePSet<E> tailSet(E fromElement) {
        return this.tailSet((Object)fromElement, true);
    }

    private E search(E e, KVTree.SearchType searchTypeIfLeftToRight, KVTree.SearchType searchTypeIfRightToLeft) {
        return this.tree.search(Objects.requireNonNull(e, "e is null"), this.ltrComparator, this.isLeftToRight ? searchTypeIfLeftToRight : searchTypeIfRightToLeft).getKey();
    }

    @Override
    public TreePSet<E> tailSet(E fromElement, boolean inclusive) {
        Objects.requireNonNull(fromElement, "fromElement is null");
        return this.withTree(this.isLeftToRight ? this.tree.rangeToRight(fromElement, inclusive, this.ltrComparator) : this.tree.rangeToLeft(fromElement, inclusive, this.ltrComparator));
    }

    private TreePSet<E> withTree(KVTree<E, ?> tree) {
        return tree == this.tree ? this : new TreePSet<E>(tree, this.ltrComparator, this.isLeftToRight);
    }

    private static <T> T sneakilyDowncast(Object o) {
        return (T)o;
    }
}

