/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.ftp;

import crawlercommons.robots.BaseRobotRules;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Nutch;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.Protocol;
import org.apache.nutch.protocol.ProtocolOutput;
import org.apache.nutch.protocol.ProtocolStatus;
import org.apache.nutch.protocol.ftp.Client;
import org.apache.nutch.protocol.ftp.FtpError;
import org.apache.nutch.protocol.ftp.FtpException;
import org.apache.nutch.protocol.ftp.FtpResponse;
import org.apache.nutch.protocol.ftp.FtpRobotRulesParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ftp
implements Protocol {
    protected static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int BUFFER_SIZE = 16384;
    static final int MAX_REDIRECTS = 5;
    int timeout;
    int maxContentLength;
    String userName;
    String passWord;
    int serverTimeout;
    long renewalTime = -1L;
    boolean keepConnection;
    boolean followTalk;
    Client client = null;
    FTPFileEntryParser parser = null;
    private Configuration conf;
    private FtpRobotRulesParser robots = new FtpRobotRulesParser();

    public void setTimeout(int to) {
        this.timeout = to;
    }

    public void setMaxContentLength(int length) {
        this.maxContentLength = length;
    }

    public void setFollowTalk(boolean followTalk) {
        this.followTalk = followTalk;
    }

    public void setKeepConnection(boolean keepConnection) {
        this.keepConnection = keepConnection;
    }

    public ProtocolOutput getProtocolOutput(Text url, CrawlDatum datum) {
        String urlString = url.toString();
        try {
            int code;
            URL u = new URL(urlString);
            int redirects = 0;
            while (true) {
                FtpResponse response = new FtpResponse(u, datum, this, this.getConf());
                code = response.getCode();
                datum.getMetaData().put((Writable)Nutch.PROTOCOL_STATUS_CODE_KEY, (Writable)new Text(Integer.toString(code)));
                if (code == 200) {
                    return new ProtocolOutput(response.toContent());
                }
                if (code < 300 || code >= 400) break;
                if (redirects == 5) {
                    throw new FtpException("Too many redirects: " + String.valueOf(url));
                }
                String loc = response.getHeader("Location");
                try {
                    u = new URL(u, loc);
                }
                catch (MalformedURLException mue) {
                    LOG.error("Could not create redirectURL for {} with {}", (Object)url, (Object)loc);
                    return new ProtocolOutput(null, new ProtocolStatus((Throwable)mue));
                }
                ++redirects;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("redirect to " + String.valueOf(u));
            }
            throw new FtpError(code);
        }
        catch (Exception e) {
            LOG.error("Could not get protocol output for {}: {}", (Object)url, (Object)e.getMessage());
            return new ProtocolOutput(null, new ProtocolStatus((Throwable)e));
        }
    }

    protected void finalize() {
        try {
            if (this.client != null && this.client.isConnected()) {
                this.client.logout();
                this.client.disconnect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        int timeout = Integer.MIN_VALUE;
        int maxContentLength = Integer.MIN_VALUE;
        String logLevel = "info";
        boolean followTalk = false;
        boolean keepConnection = false;
        boolean dumpContent = false;
        String urlString = null;
        String usage = "Usage: Ftp [-logLevel level] [-followTalk] [-keepConnection] [-timeout N] [-maxContentLength L] [-dumpContent] url";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-logLevel")) {
                logLevel = args[++i];
                continue;
            }
            if (args[i].equals("-followTalk")) {
                followTalk = true;
                continue;
            }
            if (args[i].equals("-keepConnection")) {
                keepConnection = true;
                continue;
            }
            if (args[i].equals("-timeout")) {
                timeout = Integer.parseInt(args[++i]) * 1000;
                continue;
            }
            if (args[i].equals("-maxContentLength")) {
                maxContentLength = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-dumpContent")) {
                dumpContent = true;
                continue;
            }
            if (i != args.length - 1) {
                System.err.println(usage);
                System.exit(-1);
                continue;
            }
            urlString = args[i];
        }
        Ftp ftp = new Ftp();
        ftp.setFollowTalk(followTalk);
        ftp.setKeepConnection(keepConnection);
        if (timeout != Integer.MIN_VALUE) {
            ftp.setTimeout(timeout);
        }
        if (maxContentLength != Integer.MIN_VALUE) {
            ftp.setMaxContentLength(maxContentLength);
        }
        Content content = ftp.getProtocolOutput(new Text(urlString), new CrawlDatum()).getContent();
        System.err.println("Content-Type: " + content.getContentType());
        System.err.println("Content-Length: " + content.getMetadata().get("Content-Length"));
        System.err.println("Last-Modified: " + content.getMetadata().get("Last-Modified"));
        if (dumpContent) {
            System.out.print(new String(content.getContent()));
        }
        ftp = null;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.maxContentLength = conf.getInt("ftp.content.limit", 0x100000);
        this.timeout = conf.getInt("ftp.timeout", 10000);
        this.userName = conf.get("ftp.username", "anonymous");
        this.passWord = conf.get("ftp.password", "anonymous@example.com");
        this.serverTimeout = conf.getInt("ftp.server.timeout", 60000);
        this.keepConnection = conf.getBoolean("ftp.keep.connection", false);
        this.followTalk = conf.getBoolean("ftp.follow.talk", false);
        this.robots.setConf(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public BaseRobotRules getRobotRules(Text url, CrawlDatum datum, List<Content> robotsTxtContent) {
        return this.robots.getRobotRulesSet(this, url, robotsTxtContent);
    }

    public int getBufferSize() {
        return 16384;
    }
}

