/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.lib;

import com.barchart.udt.lib.LibraryLoader;
import com.barchart.udt.lib.PluginPropsUDT;
import com.barchart.udt.lib.ResourceManagerUDT;
import com.barchart.udt.lib.VersionUDT;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryLoaderUDT
implements LibraryLoader {
    private static final Logger log = LoggerFactory.getLogger(LibraryLoaderUDT.class);

    @Override
    public void load(String targetFolder) throws Exception {
        if (!PluginPropsUDT.isSupportedPlatform()) {
            throw new IllegalStateException("Unsupported platform.");
        }
        log.info("Platform supported.");
        if (targetFolder == null || targetFolder.length() == 0) {
            throw new IllegalStateException("Invalid extract location.");
        }
        try {
            log.info("Loading release libraries.");
            this.loadRelease(targetFolder);
            log.info("Release libraries loaded.");
            return;
        }
        catch (Throwable e) {
            log.warn("Release libraries missing: {}", (Object)e.getMessage());
            try {
                log.info("Loading staging libraries.");
                this.loadStaging(targetFolder);
                log.info("Staging libraries loaded.");
                return;
            }
            catch (Throwable e2) {
                log.warn("Staging libraries missing: {}", (Object)e2.getMessage());
                try {
                    log.info("Loading testing libraries.");
                    this.loadTesting(targetFolder);
                    log.info("Testing libraries loaded.");
                    return;
                }
                catch (Throwable e3) {
                    log.warn("Testing libraries missing: {}", (Object)e3.getMessage());
                    throw new IllegalStateException("Fatal: library load failed.");
                }
            }
        }
    }

    protected void loadAll(List<String> sourceList, String targetFolder) throws Exception {
        String targetPath;
        for (String sourcePath : sourceList) {
            targetPath = targetFolder + sourcePath;
            ResourceManagerUDT.extractResource(sourcePath, targetPath);
        }
        for (String sourcePath : sourceList) {
            targetPath = targetFolder + sourcePath;
            ResourceManagerUDT.systemLoad(targetPath);
        }
    }

    protected void loadRelease(String targetFolder) throws Exception {
        String coreName = VersionUDT.BARCHART_NAME;
        List<String> sourceList = PluginPropsUDT.currentReleaseLibraries(coreName);
        this.loadAll(sourceList, targetFolder);
    }

    protected void loadStaging(String targetFolder) throws Exception {
        String coreName = VersionUDT.BARCHART_NAME;
        List<String> sourceList = PluginPropsUDT.currentStagingLibraries(coreName);
        this.loadAll(sourceList, targetFolder);
    }

    protected void loadTesting(String targetFolder) throws Exception {
        String coreName = VersionUDT.BARCHART_ARTIFACT + "-" + PluginPropsUDT.currentNarPath();
        List<String> sourceList = PluginPropsUDT.currentTestingLibraries(coreName);
        this.loadAll(sourceList, targetFolder);
    }
}

