/****************************************************************************
 * arch/risc-v/src/hpm6000/hardware/hpm6300/hpm6300_sysctl.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_SYSCTL_H
#define __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_SYSCTL_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include "hpm6300_memorymap.h"

#define HPM_SYSCTL_RESOURCE_CPU0                    (HPM_SYSCTL_BASE + 0x0000)
#define HPM_SYSCTL_RESOURCE_CPX0                    (HPM_SYSCTL_BASE + 0x0004)
#define HPM_SYSCTL_RESOURCE_POW_CPU0                (HPM_SYSCTL_BASE + 0x0054)
#define HPM_SYSCTL_RESOURCE_RST_SOC                 (HPM_SYSCTL_BASE + 0x0058)
#define HPM_SYSCTL_RESOURCE_RST_CPU0                (HPM_SYSCTL_BASE + 0x005c)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_XTAL            (HPM_SYSCTL_BASE + 0x0080)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_PLL0            (HPM_SYSCTL_BASE + 0x0084)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_CLK0_PLL0       (HPM_SYSCTL_BASE + 0x0088)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_CLK1_PLL0       (HPM_SYSCTL_BASE + 0x008c)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_CLK2_PLL0       (HPM_SYSCTL_BASE + 0x0090)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_PLL1            (HPM_SYSCTL_BASE + 0x0094)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_CLK0_PLL1       (HPM_SYSCTL_BASE + 0x0098)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_CLK1_PLL1       (HPM_SYSCTL_BASE + 0x009c)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_PLL2            (HPM_SYSCTL_BASE + 0x00a0)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_CLK0_PLL2       (HPM_SYSCTL_BASE + 0x00a4)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_CLK1_PLL2       (HPM_SYSCTL_BASE + 0x00a8)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_PLL0_REF        (HPM_SYSCTL_BASE + 0x00ac)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_PLL1_REF        (HPM_SYSCTL_BASE + 0x00b0)
#define HPM_SYSCTL_RESOURCE_CLK_SRC_PLL2_REF        (HPM_SYSCTL_BASE + 0x00b4)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_CPU0            (HPM_SYSCTL_BASE + 0x0100)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_MCT0            (HPM_SYSCTL_BASE + 0x0104)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_FEMC            (HPM_SYSCTL_BASE + 0x0108)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_XPI0            (HPM_SYSCTL_BASE + 0x010c)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_XPI1            (HPM_SYSCTL_BASE + 0x0110)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_TMR0            (HPM_SYSCTL_BASE + 0x0114)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_TMR1            (HPM_SYSCTL_BASE + 0x0118)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_TMR2            (HPM_SYSCTL_BASE + 0x011c)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_TMR3            (HPM_SYSCTL_BASE + 0x0120)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_UART0           (HPM_SYSCTL_BASE + 0x0124)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_UART1           (HPM_SYSCTL_BASE + 0x0128)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_UART2           (HPM_SYSCTL_BASE + 0x012c)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_UART3           (HPM_SYSCTL_BASE + 0x0130)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_UART4           (HPM_SYSCTL_BASE + 0x0134)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_UART5           (HPM_SYSCTL_BASE + 0x0138)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_UART6           (HPM_SYSCTL_BASE + 0x013c)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_UART7           (HPM_SYSCTL_BASE + 0x0140)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_I2C0            (HPM_SYSCTL_BASE + 0x0144)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_IC21            (HPM_SYSCTL_BASE + 0x0148)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_IC22            (HPM_SYSCTL_BASE + 0x014c)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_IC23            (HPM_SYSCTL_BASE + 0x0150)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_SPI0            (HPM_SYSCTL_BASE + 0x0154)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_SPI1            (HPM_SYSCTL_BASE + 0x0158)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_SPI2            (HPM_SYSCTL_BASE + 0x015c)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_SPI3            (HPM_SYSCTL_BASE + 0x0160)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_CAN0            (HPM_SYSCTL_BASE + 0x0164)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_CAN1            (HPM_SYSCTL_BASE + 0x0168)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_PTPC            (HPM_SYSCTL_BASE + 0x016c)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_ANA0            (HPM_SYSCTL_BASE + 0x0170)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_ANA1            (HPM_SYSCTL_BASE + 0x0174)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_ANA2            (HPM_SYSCTL_BASE + 0x0178)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_ANA3            (HPM_SYSCTL_BASE + 0x017c)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_AUD0            (HPM_SYSCTL_BASE + 0x0180)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_AUD1            (HPM_SYSCTL_BASE + 0x0184)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_ETH0            (HPM_SYSCTL_BASE + 0x0188)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_PTP0            (HPM_SYSCTL_BASE + 0x018c)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_REF0            (HPM_SYSCTL_BASE + 0x0190)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_REF1            (HPM_SYSCTL_BASE + 0x0194)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_NTM0            (HPM_SYSCTL_BASE + 0x0198)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_SDC0            (HPM_SYSCTL_BASE + 0x019c)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_ADC0            (HPM_SYSCTL_BASE + 0x0200)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_ADC1            (HPM_SYSCTL_BASE + 0x0204)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_ADC2            (HPM_SYSCTL_BASE + 0x0208)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_DAC0            (HPM_SYSCTL_BASE + 0x020c)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_I2S0            (HPM_SYSCTL_BASE + 0x0210)
#define HPM_SYSCTL_RESOURCE_CLK_TOP_I2S1            (HPM_SYSCTL_BASE + 0x0214)
#define HPM_SYSCTL_RESOURCE_AHBP                    (HPM_SYSCTL_BASE + 0x0400)
#define HPM_SYSCTL_RESOURCE_AXIS                    (HPM_SYSCTL_BASE + 0x0404)
#define HPM_SYSCTL_RESOURCE_AXIC                    (HPM_SYSCTL_BASE + 0x0408)
#define HPM_SYSCTL_RESOURCE_FEMC                    (HPM_SYSCTL_BASE + 0x040c)
#define HPM_SYSCTL_RESOURCE_ROM0                    (HPM_SYSCTL_BASE + 0x0410)
#define HPM_SYSCTL_RESOURCE_LMM0                    (HPM_SYSCTL_BASE + 0x0414)
#define HPM_SYSCTL_RESOURCE_RAM0                    (HPM_SYSCTL_BASE + 0x0418)
#define HPM_SYSCTL_RESOURCE_MCT0                    (HPM_SYSCTL_BASE + 0x041c)
#define HPM_SYSCTL_RESOURCE_XPI0                    (HPM_SYSCTL_BASE + 0x0420)
#define HPM_SYSCTL_RESOURCE_XPI1                    (HPM_SYSCTL_BASE + 0x0424)
#define HPM_SYSCTL_RESOURCE_SDP0                    (HPM_SYSCTL_BASE + 0x0428)
#define HPM_SYSCTL_RESOURCE_RNG0                    (HPM_SYSCTL_BASE + 0x042c)
#define HPM_SYSCTL_RESOURCE_KMAN                    (HPM_SYSCTL_BASE + 0x0430)
#define HPM_SYSCTL_RESOURCE_DMA0                    (HPM_SYSCTL_BASE + 0x0434)
#define HPM_SYSCTL_RESOURCE_DMA1                    (HPM_SYSCTL_BASE + 0x0438)
#define HPM_SYSCTL_RESOURCE_FFA0                    (HPM_SYSCTL_BASE + 0x043c)
#define HPM_SYSCTL_RESOURCE_GPIO                    (HPM_SYSCTL_BASE + 0x0440)
#define HPM_SYSCTL_RESOURCE_MBX0                    (HPM_SYSCTL_BASE + 0x0444)
#define HPM_SYSCTL_RESOURCE_WDG0                    (HPM_SYSCTL_BASE + 0x0448)
#define HPM_SYSCTL_RESOURCE_WDG1                    (HPM_SYSCTL_BASE + 0x044c)
#define HPM_SYSCTL_RESOURCE_TSNS                    (HPM_SYSCTL_BASE + 0x0450)
#define HPM_SYSCTL_RESOURCE_TMR0                    (HPM_SYSCTL_BASE + 0x0454)
#define HPM_SYSCTL_RESOURCE_TMR1                    (HPM_SYSCTL_BASE + 0x0458)
#define HPM_SYSCTL_RESOURCE_RMR2                    (HPM_SYSCTL_BASE + 0x045c)
#define HPM_SYSCTL_RESOURCE_TMR3                    (HPM_SYSCTL_BASE + 0x0460)
#define HPM_SYSCTL_RESOURCE_URT0                    (HPM_SYSCTL_BASE + 0x0464)
#define HPM_SYSCTL_RESOURCE_URT1                    (HPM_SYSCTL_BASE + 0x0468)
#define HPM_SYSCTL_RESOURCE_URT2                    (HPM_SYSCTL_BASE + 0x046c)
#define HPM_SYSCTL_RESOURCE_URT3                    (HPM_SYSCTL_BASE + 0x0470)
#define HPM_SYSCTL_RESOURCE_URT4                    (HPM_SYSCTL_BASE + 0x0474)
#define HPM_SYSCTL_RESOURCE_URT5                    (HPM_SYSCTL_BASE + 0x0478)
#define HPM_SYSCTL_RESOURCE_URT6                    (HPM_SYSCTL_BASE + 0x047c)
#define HPM_SYSCTL_RESOURCE_URT7                    (HPM_SYSCTL_BASE + 0x0480)
#define HPM_SYSCTL_RESOURCE_I2C0                    (HPM_SYSCTL_BASE + 0x0484)
#define HPM_SYSCTL_RESOURCE_I2C1                    (HPM_SYSCTL_BASE + 0x0488)
#define HPM_SYSCTL_RESOURCE_I2C2                    (HPM_SYSCTL_BASE + 0x048c)
#define HPM_SYSCTL_RESOURCE_I2C3                    (HPM_SYSCTL_BASE + 0x0490)
#define HPM_SYSCTL_RESOURCE_SPI0                    (HPM_SYSCTL_BASE + 0x0494)
#define HPM_SYSCTL_RESOURCE_SPI1                    (HPM_SYSCTL_BASE + 0x0498)
#define HPM_SYSCTL_RESOURCE_SPI2                    (HPM_SYSCTL_BASE + 0x049c)
#define HPM_SYSCTL_RESOURCE_SPI3                    (HPM_SYSCTL_BASE + 0x04a0)
#define HPM_SYSCTL_RESOURCE_CAN0                    (HPM_SYSCTL_BASE + 0x04a4)
#define HPM_SYSCTL_RESOURCE_CAN1                    (HPM_SYSCTL_BASE + 0x04a8)
#define HPM_SYSCTL_RESOURCE_PTPC                    (HPM_SYSCTL_BASE + 0x04ac)
#define HPM_SYSCTL_RESOURCE_ADC0                    (HPM_SYSCTL_BASE + 0x04b0)
#define HPM_SYSCTL_RESOURCE_ADC1                    (HPM_SYSCTL_BASE + 0x04b4)
#define HPM_SYSCTL_RESOURCE_ADC2                    (HPM_SYSCTL_BASE + 0x04b8)
#define HPM_SYSCTL_RESOURCE_DAC0                    (HPM_SYSCTL_BASE + 0x04bc)
#define HPM_SYSCTL_RESOURCE_ACMP                    (HPM_SYSCTL_BASE + 0x04c0)
#define HPM_SYSCTL_RESOURCE_I2S0                    (HPM_SYSCTL_BASE + 0x04c4)
#define HPM_SYSCTL_RESOURCE_I2S1                    (HPM_SYSCTL_BASE + 0x04c8)
#define HPM_SYSCTL_RESOURCE_PDM0                    (HPM_SYSCTL_BASE + 0x04cc)
#define HPM_SYSCTL_RESOURCE_DAO                     (HPM_SYSCTL_BASE + 0x04d0)
#define HPM_SYSCTL_RESOURCE_MSYN                    (HPM_SYSCTL_BASE + 0x04d4)
#define HPM_SYSCTL_RESOURCE_MOT0                    (HPM_SYSCTL_BASE + 0x04d8)
#define HPM_SYSCTL_RESOURCE_MOT1                    (HPM_SYSCTL_BASE + 0x04dc)
#define HPM_SYSCTL_RESOURCE_ETH0                    (HPM_SYSCTL_BASE + 0x04e0)
#define HPM_SYSCTL_RESOURCE_NTM0                    (HPM_SYSCTL_BASE + 0x04e4)
#define HPM_SYSCTL_RESOURCE_SDC0                    (HPM_SYSCTL_BASE + 0x04e8)
#define HPM_SYSCTL_RESOURCE_USB0                    (HPM_SYSCTL_BASE + 0x04ec)
#define HPM_SYSCTL_RESOURCE_REF0                    (HPM_SYSCTL_BASE + 0x04f0)
#define HPM_SYSCTL_RESOURCE_REF1                    (HPM_SYSCTL_BASE + 0x04f4)
#define HPM_SYSCTL_GROUP0_LINK0_VALUE               (HPM_SYSCTL_BASE + 0x0800)
#define HPM_SYSCTL_GROUP0_LINK0_SET                 (HPM_SYSCTL_BASE + 0x0804)
#define HPM_SYSCTL_GROUP0_LINK0_CLEAR               (HPM_SYSCTL_BASE + 0x0808)
#define HPM_SYSCTL_GROUP0_LINK0_TOGGLE              (HPM_SYSCTL_BASE + 0x080c)
#define HPM_SYSCTL_GROUP0_LINK1_VALUE               (HPM_SYSCTL_BASE + 0x0810)
#define HPM_SYSCTL_GROUP0_LINK1_SET                 (HPM_SYSCTL_BASE + 0x0814)
#define HPM_SYSCTL_GROUP0_LINK1_CLEAR               (HPM_SYSCTL_BASE + 0x0818)
#define HPM_SYSCTL_GROUP0_LINK1_TOGGLE              (HPM_SYSCTL_BASE + 0x081c)
#define HPM_SYSCTL_AFFILIATE_CPU0_VALUE             (HPM_SYSCTL_BASE + 0x0900)
#define HPM_SYSCTL_AFFILIATE_CPU0_SET               (HPM_SYSCTL_BASE + 0x0904)
#define HPM_SYSCTL_AFFILIATE_CPU0_CLEAR             (HPM_SYSCTL_BASE + 0x0908)
#define HPM_SYSCTL_AFFILIATE_CPU0_TOGGLE            (HPM_SYSCTL_BASE + 0x090c)
#define HPM_SYSCTL_RETENTION_CPU0_VALUE             (HPM_SYSCTL_BASE + 0x0920)
#define HPM_SYSCTL_RETENTION_CPU0_SET               (HPM_SYSCTL_BASE + 0x0924)
#define HPM_SYSCTL_RETENTION_CPU0_CLEAR             (HPM_SYSCTL_BASE + 0x0928)
#define HPM_SYSCTL_RETENTION_CPU0_TOGGLE            (HPM_SYSCTL_BASE + 0x092c)
#define HPM_SYSCTL_POWER_CPU0_STATUS                (HPM_SYSCTL_BASE + 0x1000)
#define HPM_SYSCTL_POWER_CPU0_LF_WAIT               (HPM_SYSCTL_BASE + 0x1004)
#define HPM_SYSCTL_POWER_CPU0_OFF_WAIT              (HPM_SYSCTL_BASE + 0x100c)
#define HPM_SYSCTL_RESET_SOC_CONTROL                (HPM_SYSCTL_BASE + 0x1400)   
#define HPM_SYSCTL_RESET_SOC_CONFIG                 (HPM_SYSCTL_BASE + 0x1404)
#define HPM_SYSCTL_RESET_SOC_COUNTER                (HPM_SYSCTL_BASE + 0x140c)
#define HPM_SYSCTL_RESET_CPU0_CONTROL               (HPM_SYSCTL_BASE + 0x1410)
#define HPM_SYSCTL_RESET_CPU0_CONFIG                (HPM_SYSCTL_BASE + 0x1414)
#define HPM_SYSCTL_RESET_CPU0_COUNTER               (HPM_SYSCTL_BASE + 0x141c)
#define HPM_SYSCTL_CLOCK_CPU_CLK_TOP_CPU0           (HPM_SYSCTL_BASE + 0x1800)
#define HPM_SYSCTL_CLOCK_CLK_TOP_MCT0               (HPM_SYSCTL_BASE + 0x1804)
#define HPM_SYSCTL_CLOCK_CLK_TOP_FEMC               (HPM_SYSCTL_BASE + 0x1808)
#define HPM_SYSCTL_CLOCK_CLK_TOP_XPI0               (HPM_SYSCTL_BASE + 0x180c)
#define HPM_SYSCTL_CLOCK_CLK_TOP_XPI1               (HPM_SYSCTL_BASE + 0x1810)
#define HPM_SYSCTL_CLOCK_CLK_TOP_TMR0               (HPM_SYSCTL_BASE + 0x1814)
#define HPM_SYSCTL_CLOCK_CLK_TOP_TMR1               (HPM_SYSCTL_BASE + 0x1818)
#define HPM_SYSCTL_CLOCK_CLK_TOP_TMR2               (HPM_SYSCTL_BASE + 0x181c)
#define HPM_SYSCTL_CLOCK_CLK_TOP_TMR3               (HPM_SYSCTL_BASE + 0x1820)
#define HPM_SYSCTL_CLOCK_CLK_TOP_UART0              (HPM_SYSCTL_BASE + 0x1824)
#define HPM_SYSCTL_CLOCK_CLK_TOP_UART1              (HPM_SYSCTL_BASE + 0x1828)
#define HPM_SYSCTL_CLOCK_CLK_TOP_UART2              (HPM_SYSCTL_BASE + 0x182c)
#define HPM_SYSCTL_CLOCK_CLK_TOP_UART3              (HPM_SYSCTL_BASE + 0x1830)
#define HPM_SYSCTL_CLOCK_CLK_TOP_UART4              (HPM_SYSCTL_BASE + 0x1834)
#define HPM_SYSCTL_CLOCK_CLK_TOP_UART5              (HPM_SYSCTL_BASE + 0x1838)
#define HPM_SYSCTL_CLOCK_CLK_TOP_UART6              (HPM_SYSCTL_BASE + 0x183c)
#define HPM_SYSCTL_CLOCK_CLK_TOP_UART7              (HPM_SYSCTL_BASE + 0x1840)
#define HPM_SYSCTL_CLOCK_CLK_TOP_I2C0               (HPM_SYSCTL_BASE + 0x1844)
#define HPM_SYSCTL_CLOCK_CLK_TOP_IC21               (HPM_SYSCTL_BASE + 0x1848)
#define HPM_SYSCTL_CLOCK_CLK_TOP_IC22               (HPM_SYSCTL_BASE + 0x184c)
#define HPM_SYSCTL_CLOCK_CLK_TOP_IC23               (HPM_SYSCTL_BASE + 0x1850)
#define HPM_SYSCTL_CLOCK_CLK_TOP_SPI0               (HPM_SYSCTL_BASE + 0x1854)
#define HPM_SYSCTL_CLOCK_CLK_TOP_SPI1               (HPM_SYSCTL_BASE + 0x1858)
#define HPM_SYSCTL_CLOCK_CLK_TOP_SPI2               (HPM_SYSCTL_BASE + 0x185c)
#define HPM_SYSCTL_CLOCK_CLK_TOP_SPI3               (HPM_SYSCTL_BASE + 0x1860)
#define HPM_SYSCTL_CLOCK_CLK_TOP_CAN0               (HPM_SYSCTL_BASE + 0x1864)
#define HPM_SYSCTL_CLOCK_CLK_TOP_CAN1               (HPM_SYSCTL_BASE + 0x1868)
#define HPM_SYSCTL_CLOCK_CLK_TOP_PTPC               (HPM_SYSCTL_BASE + 0x186c)
#define HPM_SYSCTL_CLOCK_CLK_TOP_ANA0               (HPM_SYSCTL_BASE + 0x1870)
#define HPM_SYSCTL_CLOCK_CLK_TOP_ANA1               (HPM_SYSCTL_BASE + 0x1874)
#define HPM_SYSCTL_CLOCK_CLK_TOP_ANA2               (HPM_SYSCTL_BASE + 0x1878)
#define HPM_SYSCTL_CLOCK_CLK_TOP_ANA3               (HPM_SYSCTL_BASE + 0x187c)
#define HPM_SYSCTL_CLOCK_CLK_TOP_AUD0               (HPM_SYSCTL_BASE + 0x1880)
#define HPM_SYSCTL_CLOCK_CLK_TOP_AUD1               (HPM_SYSCTL_BASE + 0x1884)
#define HPM_SYSCTL_CLOCK_CLK_TOP_ETH0               (HPM_SYSCTL_BASE + 0x1888)
#define HPM_SYSCTL_CLOCK_CLK_TOP_PTP0               (HPM_SYSCTL_BASE + 0x188c)
#define HPM_SYSCTL_CLOCK_CLK_TOP_REF0               (HPM_SYSCTL_BASE + 0x1890)
#define HPM_SYSCTL_CLOCK_CLK_TOP_REF1               (HPM_SYSCTL_BASE + 0x1894)
#define HPM_SYSCTL_CLOCK_CLK_TOP_NTM0               (HPM_SYSCTL_BASE + 0x1898)
#define HPM_SYSCTL_CLOCK_CLK_TOP_SDC0               (HPM_SYSCTL_BASE + 0x189c)
#define HPM_SYSCTL_ADCCLK_CLK_TOP_ADC0              (HPM_SYSCTL_BASE + 0x1c00)
#define HPM_SYSCTL_ADCCLK_CLK_TOP_ADC1              (HPM_SYSCTL_BASE + 0x1c04)
#define HPM_SYSCTL_ADCCLK_CLK_TOP_ADC2              (HPM_SYSCTL_BASE + 0x1c08)
#define HPM_SYSCTL_ADCCLK_CLK_TOP_DAC0              (HPM_SYSCTL_BASE + 0x1c0c)
#define HPM_SYSCTL_I2SCLK_CLK_TOP_I2S0              (HPM_SYSCTL_BASE + 0x1c10)
#define HPM_SYSCTL_I2SCLK_CLK_TOP_I2S1              (HPM_SYSCTL_BASE + 0x1c14)
#define HPM_SYSCTL_GLOBAL00                         (HPM_SYSCTL_BASE + 0x2000)
#define HPM_SYSCTL_MONITOR_SLICE0_CONTROL           (HPM_SYSCTL_BASE + 0x2400)
#define HPM_SYSCTL_MONITOR_SLICE0_CURRENT           (HPM_SYSCTL_BASE + 0x2404)
#define HPM_SYSCTL_MONITOR_SLICE0_LOW_LIMIT         (HPM_SYSCTL_BASE + 0x2408)
#define HPM_SYSCTL_MONITOR_SLICE0_HIGH_LIMIT        (HPM_SYSCTL_BASE + 0x240c)
#define HPM_SYSCTL_MONITOR_SLICE1_CONTROL           (HPM_SYSCTL_BASE + 0x2420)
#define HPM_SYSCTL_MONITOR_SLICE1_CURRENT           (HPM_SYSCTL_BASE + 0x2424)
#define HPM_SYSCTL_MONITOR_SLICE1_LOW_LIMIT         (HPM_SYSCTL_BASE + 0x2428)
#define HPM_SYSCTL_MONITOR_SLICE1_HIGH_LIMIT        (HPM_SYSCTL_BASE + 0x242c)
#define HPM_SYSCTL_MONITOR_SLICE2_CONTROL           (HPM_SYSCTL_BASE + 0x2440)
#define HPM_SYSCTL_MONITOR_SLICE2_CURRENT           (HPM_SYSCTL_BASE + 0x2444)
#define HPM_SYSCTL_MONITOR_SLICE2_LOW_LIMIT         (HPM_SYSCTL_BASE + 0x2448)
#define HPM_SYSCTL_MONITOR_SLICE2_HIGH_LIMIT        (HPM_SYSCTL_BASE + 0x244c)
#define HPM_SYSCTL_MONITOR_SLICE3_CONTROL           (HPM_SYSCTL_BASE + 0x2460)
#define HPM_SYSCTL_MONITOR_SLICE3_CURRENT           (HPM_SYSCTL_BASE + 0x2464)
#define HPM_SYSCTL_MONITOR_SLICE3_LOW_LIMIT         (HPM_SYSCTL_BASE + 0x2468)
#define HPM_SYSCTL_MONITOR_SLICE3_HIGH_LIMIT        (HPM_SYSCTL_BASE + 0x246c)
#define HPM_SYSCTL_CPU_CPU0_LP                      (HPM_SYSCTL_BASE + 0x2800)
#define HPM_SYSCTL_CPU_CPU0_LOCK                    (HPM_SYSCTL_BASE + 0x2804)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR0                (HPM_SYSCTL_BASE + 0x2808)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR1                (HPM_SYSCTL_BASE + 0x280c)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR2                (HPM_SYSCTL_BASE + 0x2810)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR3                (HPM_SYSCTL_BASE + 0x2814)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR4                (HPM_SYSCTL_BASE + 0x2818)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR5                (HPM_SYSCTL_BASE + 0x281c)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR6                (HPM_SYSCTL_BASE + 0x2820)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR7                (HPM_SYSCTL_BASE + 0x2824)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR8                (HPM_SYSCTL_BASE + 0x2828)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR9                (HPM_SYSCTL_BASE + 0x282c)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR10               (HPM_SYSCTL_BASE + 0x2830)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR11               (HPM_SYSCTL_BASE + 0x2834)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR12               (HPM_SYSCTL_BASE + 0x2838)
#define HPM_SYSCTL_CPU_CPU0_GPR_GPR13               (HPM_SYSCTL_BASE + 0x283c)
#define HPM_SYSCTL_CPU_CPU0_WAKEUP_STATUS_STATUS0   (HPM_SYSCTL_BASE + 0x2840)
#define HPM_SYSCTL_CPU_CPU0_WAKEUP_STATUS_STATUS1   (HPM_SYSCTL_BASE + 0x2844)
#define HPM_SYSCTL_CPU_CPU0_WAKEUP_STATUS_STATUS2   (HPM_SYSCTL_BASE + 0x2848)
#define HPM_SYSCTL_CPU_CPU0_WAKEUP_STATUS_STATUS3   (HPM_SYSCTL_BASE + 0x284c)
#define HPM_SYSCTL_CPU_CPU0_WAKEUP_ENABLE_ENABLE0   (HPM_SYSCTL_BASE + 0x2880)
#define HPM_SYSCTL_CPU_CPU0_WAKEUP_ENABLE_ENABLE1   (HPM_SYSCTL_BASE + 0x2884)
#define HPM_SYSCTL_CPU_CPU0_WAKEUP_ENABLE_ENABLE2   (HPM_SYSCTL_BASE + 0x2888)
#define HPM_SYSCTL_CPU_CPU0_WAKEUP_ENABLE_ENABLE3   (HPM_SYSCTL_BASE + 0x288c)

#define SYSCTL_RESOURCE_GLB_BUSY                  (1 << 31)
#define SYSCTL_RESOURCE_LOC_BUSY                  (1 << 30)
#define SYSCTL_RESOURCE_MODE_SHIFT                (0U)
#define SYSCTL_RESOURCE_MODE_MASK                 (0x3U << SYSCTL_RESOURCE_MODE_SHIFT)
#  define SYSCTL_RESOURCE_MODE_AUTO               (0 << SYSCTL_RESOURCE_MODE_SHIFT)
#  define SYSCTL_RESOURCE_MODE_ON                 (1 << SYSCTL_RESOURCE_MODE_SHIFT)
#  define SYSCTL_RESOURCE_MODE_OFF                (2 << SYSCTL_RESOURCE_MODE_SHIFT)
#  define SYSCTL_RESOURCE_MODE_RESV               (3 << SYSCTL_RESOURCE_MODE_SHIFT)

#define SYSCTL_GROUP0(n)                          (1U << (n))

#define SYSCTL_AFFILIATE(n)                       (1U << (n))

#define SYSCTL_RETENTION_LINK_SHIFT               (0)
#define SYSCTL_RETENTION_LINK_MASK                (0xffU << SYSCTL_RETENTION_LINK_SHIFT)
#  define SYSCTL_RETENTION_LINK_SOC_RAM           (0 << SYSCTL_RETENTION_LINK_SHIFT)
#  define SYSCTL_RETENTION_LINK_PERIPH_REG        (1 << SYSCTL_RETENTION_LINK_SHIFT)
#  define SYSCTL_RETENTION_LINK_CPU0_RAM          (2 << SYSCTL_RETENTION_LINK_SHIFT) 
#  define SYSCTL_RETENTION_LINK_CPU0_REG          (3 << SYSCTL_RETENTION_LINK_SHIFT)
#  define SYSCTL_RETENTION_LINK_XTAL              (4 << SYSCTL_RETENTION_LINK_SHIFT)
#  define SYSCTL_RETENTION_LINK_PLL0              (5 << SYSCTL_RETENTION_LINK_SHIFT)
#  define SYSCTL_RETENTION_LINK_PLL1              (6 << SYSCTL_RETENTION_LINK_SHIFT)
#  define SYSCTL_RETENTION_LINK_PLL2              (7 << SYSCTL_RETENTION_LINK_SHIFT)

#define SYSCTL_POWER_STATUS_FLAG                  (1 << 31)
#define SYSCTL_POWER_STATUS_FLAG_WAKE             (1 << 30)
#define SYSCTL_POWER_LF_DISABLE                   (1 << 12)
#define SYSCTL_POWER_LF_ACK                       (1 << 8)

#define SYSCTL_POWER_LF_WAIT_WAIT_SHIFT           (0)
#define SYSCTL_POWER_LF_WAIT_WAIT_MASK            (0xfffffU << SYSCTL_POWER_LF_WAIT_WAIT_SHIFT)
#define SYSCTL_POWER_LF_WAIT_WAIT(n)              ((n) << SYSCTL_POWER_LF_WAIT_WAIT_SHIFT)

#define SYSCTL_POWER_OFF_WAIT_WAIT_SHIFT          (0)
#define SYSCTL_POWER_OFF_WAIT_WAIT_MASK           (0xfffffU << SYSCTL_POWER_OFF_WAIT_WAIT_SHIFT)
#define SYSCTL_POWER_OFF_WAIT_WAIT(n)             ((n) << SYSCTL_POWER_OFF_WAIT_WAIT_SHIFT)

#define SYSCTL_RESET_CONTROL_FLAG                 (1 << 31)
#define SYSCTL_RESET_CONTROL_FLAG_WAKE            (1 << 30)
#define SYSCTL_RESET_CONTROL_HOLD                 (1 << 4)
#define SYSCTL_RESET_CONTROL_RESET                (1 << 0)

#define SYSCTL_RESET_CONFIG_PRE_WAIT_SHIFT        (16)
#define SYSCTL_RESET_CONFIG_PRE_WAIT_MASK         (0xffU << SYSCTL_RESET_CONFIG_PRE_WAIT_SHIFT)
#define SYSCTL_RESET_CONFIG_PRE_WAIT(n)           ((n) << SYSCTL_RESET_CONFIG_PRE_WAIT_SHIFT)
#define SYSCTL_RESET_CONFIG_RSTCLK_NUM_SHIFT      (8)
#define SYSCTL_RESET_CONFIG_RSTCLK_NUM_MASK       (0xffU << SYSCTL_RESET_CONFIG_RSTCLK_NUM_SHIFT)
#define SYSCTL_RESET_CONFIG_RSTCLK_NUM(n)         ((n) << SYSCTL_RESET_CONFIG_RSTCLK_NUM_SHIFT)
#define SYSCTL_RESET_CONFIG_POST_WAIT_SHIFT       (0)
#define SYSCTL_RESET_CONFIG_POST_WAIT_MASK        (0xffU << SYSCTL_RESET_CONFIG_POST_WAIT_SHIFT)
#define SYSCTL_RESET_CONFIG_POST_WAIT(n)          ((n) << SYSCTL_RESET_CONFIG_POST_WAIT_SHIFT)

#define SYSCTL_RESET_COUNTER_COUNTER_SHIFT        (0)
#define SYSCTL_RESET_COUNTER_COUNTER_MASK         (0xfffffU << SYSCTL_RESET_COUNTER_COUNTER_SHIFT)
#define SYSCTL_RESET_COUNTER_COUNTER(n)           ((n) << SYSCTL_RESET_COUNTER_COUNTER_SHIFT)

#define SYSCTL_CLOCK_CPU_GLB_BUSY                 (1 << 31)
#define SYSCTL_CLOCK_CPU_LOC_BUSY                 (1 << 30)
#define SYSCTL_CLOCK_CPU_PRESERVE                 (1 << 28)
#define SYSCTL_CLOCK_CPU_SUB1_DIV_SHIFT           (20)
#define SYSCTL_CLOCK_CPU_SUB1_DIV_MASK            (0xfU << SYSCTL_CLOCK_CPU_SUB1_DIV_SHIFT)
#define SYSCTL_CLOCK_CPU_SUB1_DIV(n)              ((n) << SYSCTL_CLOCK_CPU_SUB1_DIV_SHIFT)
#define SYSCTL_CLOCK_CPU_SUB0_DIV_SHIFT           (16)
#define SYSCTL_CLOCK_CPU_SUB0_DIV_MASK            (0xfU << SYSCTL_CLOCK_CPU_SUB0_DIV_SHIFT)
#define SYSCTL_CLOCK_CPU_SUB0_DIV(n)              ((n) << SYSCTL_CLOCK_CPU_SUB0_DIV_SHIFT)
#define SYSCTL_CLOCK_CPU_MUX_SHIFT                (8)
#define SYSCTL_CLOCK_CPU_MUX_MASK                 (0xfU << SYSCTL_CLOCK_CPU_MUX_SHIFT)
#  define SYSCTL_CLOCK_CPU_MUX_OSC0_CLK0          (0 << SYSCTL_CLOCK_CPU_MUX_SHIFT)
#  define SYSCTL_CLOCK_CPU_MUX_PLL0_CLK0          (1 << SYSCTL_CLOCK_CPU_MUX_SHIFT)
#  define SYSCTL_CLOCK_CPU_MUX_PLL0_CLK1          (2 << SYSCTL_CLOCK_CPU_MUX_SHIFT)
#  define SYSCTL_CLOCK_CPU_MUX_PLL0_CLK2          (3 << SYSCTL_CLOCK_CPU_MUX_SHIFT)
#  define SYSCTL_CLOCK_CPU_MUX_PLL1_CLK0          (4 << SYSCTL_CLOCK_CPU_MUX_SHIFT)
#  define SYSCTL_CLOCK_CPU_MUX_PLL1_CLK1          (5 << SYSCTL_CLOCK_CPU_MUX_SHIFT)
#  define SYSCTL_CLOCK_CPU_MUX_PLL2_CLK0          (6 << SYSCTL_CLOCK_CPU_MUX_SHIFT)
#  define SYSCTL_CLOCK_CPU_MUX_PLL2_CLK1          (7 << SYSCTL_CLOCK_CPU_MUX_SHIFT)
#define SYSCTL_CLOCK_CPU_DIV_SHIFT                (0)
#define SYSCTL_CLOCK_CPU_DIV_MASK                 (0xffU << SYSCTL_CLOCK_CPU_DIV_SHIFT)
#define SYSCTL_CLOCK_CPU_DIV(n)                   ((n) << SYSCTL_CLOCK_CPU_DIV_SHIFT)

#define SYSCTL_CLOCK_GLB_BUSY                     (1 << 31)
#define SYSCTL_CLOCK_LOC_BUSY                     (1 << 30)
#define SYSCTL_CLOCK_PRESERVE                     (1 << 28)
#define SYSCTL_CLOCK_SUB1_DIV_SHIFT               (20)
#define SYSCTL_CLOCK_SUB1_DIV_MASK                (0xfU << SYSCTL_CLOCK_SUB1_DIV_SHIFT)
#define SYSCTL_CLOCK_SUB1_DIV(n)                  ((n) << SYSCTL_CLOCK_SUB1_DIV_SHIFT)
#define SYSCTL_CLOCK_SUB0_DIV_SHIFT               (16)
#define SYSCTL_CLOCK_SUB0_DIV_MASK                (0xfU << SYSCTL_CLOCK_SUB0_DIV_SHIFT)
#define SYSCTL_CLOCK_SUB0_DIV(n)                  ((n) << SYSCTL_CLOCK_SUB0_DIV_SHIFT)
#define SYSCTL_CLOCK_MUX_SHIFT                    (8)
#define SYSCTL_CLOCK_MUX_MASK                     (0xfU << SYSCTL_CLOCK_MUX_SHIFT)
#  define SYSCTL_CLOCK_MUX_OSC0_CLK0              (0 << SYSCTL_CLOCK_MUX_SHIFT)
#  define SYSCTL_CLOCK_MUX_PLL0_CLK0              (1 << SYSCTL_CLOCK_MUX_SHIFT)
#  define SYSCTL_CLOCK_MUX_PLL0_CLK1              (2 << SYSCTL_CLOCK_MUX_SHIFT)
#  define SYSCTL_CLOCK_MUX_PLL0_CLK2              (3 << SYSCTL_CLOCK_MUX_SHIFT)
#  define SYSCTL_CLOCK_MUX_PLL1_CLK0              (4 << SYSCTL_CLOCK_MUX_SHIFT)
#  define SYSCTL_CLOCK_MUX_PLL1_CLK1              (5 << SYSCTL_CLOCK_MUX_SHIFT)
#  define SYSCTL_CLOCK_MUX_PLL2_CLK0              (6 << SYSCTL_CLOCK_MUX_SHIFT)
#  define SYSCTL_CLOCK_MUX_PLL2_CLK1              (7 << SYSCTL_CLOCK_MUX_SHIFT)
#define SYSCTL_CLOCK_DIV_SHIFT                    (0)
#define SYSCTL_CLOCK_DIV_MASK                     (0xffU << SYSCTL_CLOCK_DIV_SHIFT)
#define SYSCTL_CLOCK_DIV(n)                       ((n-1) << SYSCTL_CLOCK_DIV_SHIFT)

#define SYSCTL_ADCCLK_GLB_BUSY                    (1 << 31)
#define SYSCTL_ADCCLK_LOC_BUSY                    (1 << 30)
#define SYSCTL_ADCCLK_PRESERVE                    (1 << 28)
#define SYSCTL_ADCCLK_MUX_ANA_CLOCK               (0)
#define SYSCTL_ADCCLK_MUX_AHB_CLOCK               (1 << 8)

#define SYSCTL_DACCLK_GLB_BUSY                    (1 << 31)
#define SYSCTL_DACCLK_LOC_BUSY                    (1 << 30)
#define SYSCTL_DACCLK_PRESERVE                    (1 << 28)
#define SYSCTL_DACCLK_MUX_ANA_CLOCK               (0)
#define SYSCTL_DACCLK_MUX_AHB_CLOCK               (1 << 8)

#define SYSCTL_DACCLK_GLB_BUSY                    (1 << 31)
#define SYSCTL_DACCLK_LOC_BUSY                    (1 << 30)
#define SYSCTL_DACCLK_PRESERVE                    (1 << 28)
#define SYSCTL_DACCLK_MUX_AUD_CLOCK0              (0)
#define SYSCTL_DACCLK_MUX_AUD_CLOCK1              (1 << 8)

#define SYSCTL_GLOBAL00_MUX_SHIFT                 (0)
#define SYSCTL_GLOBAL00_MUX_MASK                  (3 << SYSCTL_GLOBAL00_MUX_SHIFT)
#define SYSCTL_GLOBAL00_MUX(n)                    ((n) << SYSCTL_GLOBAL00_MUX_SHIFT)
#define   SYSCTL_GLOBAL00_MUX_24M                 (0)
#define   SYSCTL_GLOBAL00_MUX_SUG                 (1 << 1)

#define SYSCTL_MONITOR_CONTROL_VALID              (1 << 31)
#define SYSCTL_MONITOR_CONTROL_DIV_BUSY           (1 << 27)
#define SYSCTL_MONITOR_CONTROL_OUTEN              (1 << 24)
#define SYSCTL_MONITOR_CONTROL_DIV_SHIFT          (16)
#define SYSCTL_MONITOR_CONTROL_DIV_MASK           (0xffU << SYSCTL_MONITOR_CONTROL_DIV_SHIFT)
#define SYSCTL_MONITOR_CONTROL_DIV(n)             ((n) << SYSCTL_MONITOR_CONTROL_DIV_SHIFT)
#define SYSCTL_MONITOR_CONTROL_HIGH               (1 << 15)
#define SYSCTL_MONITOR_CONTROL_LOW                (1 << 14)
#define SYSCTL_MONITOR_CONTROL_START              (1 << 12)
#define SYSCTL_MONITOR_CONTROL_MODE               (1 << 10)
#define SYSCTL_MONITOR_CONTROL_ACCURACY           (1 << 9)
#define SYSCTL_MONITOR_CONTROL_REFERENCE          (1 << 8)
#define SYSCTL_MONITOR_CONTROL_SELECTION_SHIFT    (0)
#define SYSCTL_MONITOR_CONTROL_SELECTION_MASK     (0xffU << SYSCTL_MONITOR_CONTROL_SELECTION_SHIFT)          
#define SYSCTL_MONITOR_CONTROL_SELECTION(n)       ((n) << SYSCTL_MONITOR_CONTROL_SELECTION_SHIFT)

#define SYSCTL_CPU_LP_WAKE_CNT_SHIFT              (24)
#define SYSCTL_CPU_LP_WAKE_CNT_MASK               (0xffU << SYSCTL_CPU_LP_WAKE_CNT_SHIFT)
#define SYSCTL_CPU_LP_WAKE_CNT_CLEAR              (0)
#define SYSCTL_CPU_LP_HALT                        (1 << 16)
#define SYSCTL_CPU_LP_WAKE                        (1 << 13)
#define SYSCTL_CPU_LP_EXEC                        (1 << 12)
#define SYSCTL_CPU_LP_WAKE_FLAG                   (1 << 10)
#define SYSCTL_CPU_LP_SLEEP_FLAG                  (1 << 9)
#define SYSCTL_CPU_LP_RESET_FLAG                  (1 << 8)
#define SYSCTL_CPU_LP_MODE_SHIFT                  (0)
#define SYSCTL_CPU_LP_MODE_MASK                   (0x3 << SYSCTL_CPU_LP_MODE_SHIFT)
#define SYSCTL_CPU_LP_MODE_WAIT                   (0 << SYSCTL_CPU_LP_MODE_SHIFT)
#define SYSCTL_CPU_LP_MODE_HALT                   (1 << SYSCTL_CPU_LP_MODE_SHIFT)
#define SYSCTL_CPU_LP_MODE_RUN                    (2 << SYSCTL_CPU_LP_MODE_SHIFT)

#define SYSCTL_CPU_LOCK_GPR_SHIFT                 (2)
#define SYSCTL_CPU_LOCK_GPR_MASK                  (0x3f << SYSCTL_CPU_LOCK_GPR_SHIFT)
#define SYSCTL_CPU_LOCK_LOCK                      (1 << 1)

#define SYSCTL_CPU_GPR_GPR_MASK                   (0xffff)

#define SYSCTL_CPU_WAKEUP_STATUS_MASK             (0xffff)

#define SYSCTL_CPU_WAKEUP_ENABLE_MASK             (0xffff)

#define SYSCTL_GROUP0_LINK0_AHBP                      (1 << 0)
#define SYSCTL_GROUP0_LINK0_AXIS                      (1 << 1)
#define SYSCTL_GROUP0_LINK0_AXIC                      (1 << 2)
#define SYSCTL_GROUP0_LINK0_FEMC                      (1 << 3)
#define SYSCTL_GROUP0_LINK0_ROM0                      (1 << 4)
#define SYSCTL_GROUP0_LINK0_LMM0                      (1 << 5)
#define SYSCTL_GROUP0_LINK0_RAM0                      (1 << 6)
#define SYSCTL_GROUP0_LINK0_MCHTMR0                   (1 << 7)
#define SYSCTL_GROUP0_LINK0_XPI0                      (1 << 8)
#define SYSCTL_GROUP0_LINK0_XPI1                      (1 << 9)
#define SYSCTL_GROUP0_LINK0_SDP0                      (1 << 10)
#define SYSCTL_GROUP0_LINK0_RNG0                      (1 << 11)
#define SYSCTL_GROUP0_LINK0_KMAN                      (1 << 12)
#define SYSCTL_GROUP0_LINK0_DMA0                      (1 << 13)
#define SYSCTL_GROUP0_LINK0_DMA1                      (1 << 14)
#define SYSCTL_GROUP0_LINK0_FFA0                      (1 << 15)
#define SYSCTL_GROUP0_LINK0_GPIO                      (1 << 16)
#define SYSCTL_GROUP0_LINK0_MBX0                      (1 << 17)
#define SYSCTL_GROUP0_LINK0_WDG0                      (1 << 18)
#define SYSCTL_GROUP0_LINK0_WDG1                      (1 << 19)
#define SYSCTL_GROUP0_LINK0_TSNS                      (1 << 20)
#define SYSCTL_GROUP0_LINK0_GPTMR0                    (1 << 21)
#define SYSCTL_GROUP0_LINK0_GPTMR1                    (1 << 22)
#define SYSCTL_GROUP0_LINK0_GPRMR2                    (1 << 23)
#define SYSCTL_GROUP0_LINK0_GPTMR3                    (1 << 24)
#define SYSCTL_GROUP0_LINK0_UART0                     (1 << 25)
#define SYSCTL_GROUP0_LINK0_UART1                     (1 << 26)
#define SYSCTL_GROUP0_LINK0_UART2                     (1 << 27)
#define SYSCTL_GROUP0_LINK0_UART3                     (1 << 28)
#define SYSCTL_GROUP0_LINK0_UART4                     (1 << 29)
#define SYSCTL_GROUP0_LINK0_UART5                     (1 << 30)
#define SYSCTL_GROUP0_LINK0_UART6                     (1 << 11)
#define SYSCTL_GROUP0_LINK1_UART7                     (1 << 0)
#define SYSCTL_GROUP0_LINK1_I2C0                      (1 << 1)
#define SYSCTL_GROUP0_LINK1_I2C1                      (1 << 2)
#define SYSCTL_GROUP0_LINK1_I2C2                      (1 << 3)
#define SYSCTL_GROUP0_LINK1_I2C3                      (1 << 4)
#define SYSCTL_GROUP0_LINK1_SPI0                      (1 << 5)
#define SYSCTL_GROUP0_LINK1_SPI1                      (1 << 6)
#define SYSCTL_GROUP0_LINK1_SPI2                      (1 << 7)
#define SYSCTL_GROUP0_LINK1_SPI3                      (1 << 8)
#define SYSCTL_GROUP0_LINK1_CAN0                      (1 << 9)
#define SYSCTL_GROUP0_LINK1_CAN1                      (1 << 10)
#define SYSCTL_GROUP0_LINK1_PTPC                      (1 << 11)
#define SYSCTL_GROUP0_LINK1_ADC0                      (1 << 12)
#define SYSCTL_GROUP0_LINK1_ADC1                      (1 << 13)
#define SYSCTL_GROUP0_LINK1_ADC2                      (1 << 14)
#define SYSCTL_GROUP0_LINK1_DAC0                      (1 << 15)
#define SYSCTL_GROUP0_LINK1_ACMP                      (1 << 16)
#define SYSCTL_GROUP0_LINK1_I2S0                      (1 << 17)
#define SYSCTL_GROUP0_LINK1_I2S1                      (1 << 18)
#define SYSCTL_GROUP0_LINK1_I2SPDM0                   (1 << 19)
#define SYSCTL_GROUP0_LINK1_I2SDAO                    (1 << 20)
#define SYSCTL_GROUP0_LINK1_MSYN                      (1 << 21)
#define SYSCTL_GROUP0_LINK1_MOT0                      (1 << 22)
#define SYSCTL_GROUP0_LINK1_MOT1                      (1 << 23)
#define SYSCTL_GROUP0_LINK1_ETH0                      (1 << 24)
#define SYSCTL_GROUP0_LINK1_NTMR0                     (1 << 25)
#define SYSCTL_GROUP0_LINK1_SDXC0                     (1 << 26)
#define SYSCTL_GROUP0_LINK1_USB0                      (1 << 27)
#define SYSCTL_GROUP0_LINK1_REF0                      (1 << 28)
#define SYSCTL_GROUP0_LINK1_REF1                      (1 << 29)

#define SYSCTL_RESOURCE_CPU0                      (0)
#define SYSCTL_RESOURCE_CPX1                      (1)
#define SYSCTL_RESOURCE_EXE0                      (2)
#define SYSCTL_RESOURCE_WAK0                      (3)
#define SYSCTL_RESOURCE_CPU0_PER                  (4)
#define SYSCTL_RESOURCE_LOGIC0                    (16)
#define SYSCTL_RESOURCE_LOGIC1                    (17)
#define SYSCTL_RESOURCE_LOGIC2                    (18)
#define SYSCTL_RESOURCE_LOGIC3                    (19)
#define SYSCTL_RESOURCE_PMIC                      (20)
#define SYSCTL_RESOURCE_POW_CPU0                  (21)
#define SYSCTL_RESOURCE_RST_SOC                   (22)
#define SYSCTL_RESOURCE_RST_CPU0                  (23)
#define SYSCTL_RESOURCE_XTAL                      (32)
#define SYSCTL_RESOURCE_PLL0                      (33)
#define SYSCTL_RESOURCE_CLK0_PLL0                 (34)
#define SYSCTL_RESOURCE_CLK1_PLL0                 (35)
#define SYSCTL_RESOURCE_CLK2_PLL0                 (36)
#define SYSCTL_RESOURCE_PLL1                      (37)
#define SYSCTL_RESOURCE_CLK0_PLL1                 (38)
#define SYSCTL_RESOURCE_CLK1_PLL1                 (39)
#define SYSCTL_RESOURCE_PLL2                      (40)
#define SYSCTL_RESOURCE_CLK0_PLL2                 (41)
#define SYSCTL_RESOURCE_CLK1_PLL2                 (42)
#define SYSCTL_RESOURCE_PLL0_REF                  (43)
#define SYSCTL_RESOURCE_PLL1_REF                  (44)
#define SYSCTL_RESOURCE_PLL2_REF                  (45)
#define SYSCTL_RESOURCE_MBIST_SOC                 (48)
#define SYSCTL_RESOURCE_MBIST_CPU                 (49)
#define SSYCTL_RESOURCE_MBIST_CON                 (50)
#define SYSCTL_RESOURCE_DFT_START_BUS             (51)
#define SYSCTL_RESOURCE_CLK_TOP_CPU0              (64)
#define SYSCTL_RESOURCE_CLK_TOP_MCHTMR0           (65)
#define SYSCTL_RESOURCE_CLK_TOP_FEMC              (66)
#define SYSCTL_RESOURCE_CLK_TOP_XPI0              (67)
#define SYSCTL_RESOURCE_CLK_TOP_XPI1              (68)
#define SYSCTL_RESOURCE_CLK_TOP_ANA1              (93)
#define SYSCTL_RESOURCE_CLK_TOP_ANA2              (94)
#define SYSCTL_RESOURCE_CLK_TOP_ANA3              (95)
#define SYSCTL_RESOURCE_CLK_TOP_AUD0              (96)
#define SYSCTL_RESOURCE_CLK_TOP_AUD1              (97)
#define SYSCTL_RESOURCE_CLK_TOP_ETH0              (98)
#define SYSCTL_RESOURCE_CLK_TOP_PTP0              (99)
#define SYSCTL_RESOURCE_CLK_TOP_REF0              (100)
#define SYSCTL_RESOURCE_CLK_TOP_REF1              (101)
#define SYSCTL_RESOURCE_CLK_TOP_NTMR0             (102)
#define SYSCTL_RESOURCE_CLK_TOP_SDXC0             (103)
#define SYSCTL_RESOURCE_CLK_TOP_ADC0              (128)
#define SYSCTL_RESOURCE_CLK_TOP_ADC1              (129)
#define SYSCTL_RESOURCE_CLK_TOP_ADC2              (130)
#define SYSCTL_RESOURCE_CLK_TOP_DAC0              (131)
#define SYSCTL_RESOURCE_CLK_TOP_I2S0              (132)
#define SYSCTL_RESOURCE_CLK_TOP_I2S1              (133)

#define SYSCTL_RESOURCE_ETH0_MEM                  (192)
#define SYSCTL_RESOURCE_SDXC0_MEM                 (193)
#define SYSCTL_RESOURCE_USB0_MEM                  (194)
#define SYSCTL_RESOURCE_RAM0_MEM                  (195)
#define SYSCTL_RESOURCE_AHBP_MEM                  (196)
#define SYSCTL_RESOURCE_FEMC_MEM                  (197)
#define SYSCTL_RESOURCE_ROM0_MEM                  (198)
#define SYSCTL_RESOURCE_XPI0_MEM                  (199)
#define SYSCTL_RESOURCE_XPI1_MEM                  (200)
#define SYSCTL_RESOURCE_CAN0_MEM                  (201)
#define SYSCTL_RESOURCE_CAN1_MEM                  (202)
#define SYSCTL_RESOURCE_I2S0_MEM                  (203)
#define SYSCTL_RESOURCE_I2S1_MEM                  (204)
#define SYSCTL_RESOURCE_PDM0_MEM                  (205)
#define SYSCTL_RESOURCE_SDP0_MEM                  (206)
#define SYSCTL_RESOURCE_FFA0_MEM                  (207)
#define SYSCTL_RESOURCE_CPX_MEM                   (208)
#define SYSCTL_RESOURCE_CORE_MEM                  (209)
#define SYSCTL_RESOURCE_LMM0_MEM                  (210)

#define SYSCTL_RESOURCE_LINKABLE_START            (256)
#define SYSCTL_RESOURCE_AHBP                      (256)
#define SYSCTL_RESOURCE_AXIS                      (257)
#define SYSCTL_RESOURCE_AXIC                      (258)
#define SYSCTL_RESOURCE_FEMC                      (259)
#define SYSCTL_RESOURCE_ROM0                      (260)
#define SYSCTL_RESOURCE_LMM0                      (261)
#define SYSCTL_RESOURCE_RAM0                      (262)
#define SYSCTL_RESOURCE_MCHTMR0                   (263)
#define SYSCTL_RESOURCE_XPI0                      (264)
#define SYSCTL_RESOURCE_XPI1                      (265)
#define SYSCTL_RESOURCE_SDP0                      (266)
#define SYSCTL_RESOURCE_RNG0                      (267)
#define SYSCTL_RESOURCE_KMAN                      (268)
#define SYSCTL_RESOURCE_DMA0                      (269)
#define SYSCTL_RESOURCE_DMA1                      (270)
#define SYSCTL_RESOURCE_FFA0                      (271)
#define SYSCTL_RESOURCE_GPIO                      (272)
#define SYSCTL_RESOURCE_MBX0                      (273)
#define SYSCTL_RESOURCE_WDG0                      (274)
#define SYSCTL_RESOURCE_WDG1                      (275)
#define SYSCTL_RESOURCE_TSNS                      (276)
#define SYSCTL_RESOURCE_GPTMR0                    (277)
#define SYSCTL_RESOURCE_GPTMR1                    (278)
#define SYSCTL_RESOURCE_GPRMR2                    (279)
#define SYSCTL_RESOURCE_GPTMR3                    (280)
#define SYSCTL_RESOURCE_UART0                     (281)
#define SYSCTL_RESOURCE_UART1                     (282)
#define SYSCTL_RESOURCE_UART2                     (283)
#define SYSCTL_RESOURCE_UART3                     (284)
#define SYSCTL_RESOURCE_UART4                     (285)
#define SYSCTL_RESOURCE_UART5                     (286)
#define SYSCTL_RESOURCE_UART6                     (287)
#define SYSCTL_RESOURCE_UART7                     (288)
#define SYSCTL_RESOURCE_I2C0                      (289)
#define SYSCTL_RESOURCE_I2C1                      (290)
#define SYSCTL_RESOURCE_I2C2                      (291)
#define SYSCTL_RESOURCE_I2C3                      (292)
#define SYSCTL_RESOURCE_SPI0                      (293)
#define SYSCTL_RESOURCE_SPI1                      (294)
#define SYSCTL_RESOURCE_SPI2                      (295)
#define SYSCTL_RESOURCE_SPI3                      (296)
#define SYSCTL_RESOURCE_CAN0                      (297)
#define SYSCTL_RESOURCE_CAN1                      (298)
#define SYSCTL_RESOURCE_PTPC                      (299)
#define SYSCTL_RESOURCE_ADC0                      (300)
#define SYSCTL_RESOURCE_ADC1                      (301)
#define SYSCTL_RESOURCE_ADC2                      (302)
#define SYSCTL_RESOURCE_DAC0                      (303)
#define SYSCTL_RESOURCE_ACMP                      (304)
#define SYSCTL_RESOURCE_I2S0                      (305)
#define SYSCTL_RESOURCE_I2S1                      (306)
#define SYSCTL_RESOURCE_I2SPDM0                   (307)
#define SYSCTL_RESOURCE_I2SDAO                    (308)
#define SYSCTL_RESOURCE_MSYN                      (309)
#define SYSCTL_RESOURCE_MOT0                      (310)
#define SYSCTL_RESOURCE_MOT1                      (311)
#define SYSCTL_RESOURCE_ETH0                      (312)
#define SYSCTL_RESOURCE_NTMR0                     (313)
#define SYSCTL_RESOURCE_SDXC0                     (314)
#define SYSCTL_RESOURCE_USB0                      (315)
#define SYSCTL_RESOURCE_REF0                      (316)
#define SYSCTL_RESOURCE_REF1                      (317)
#define SYSCTL_RESOURCE_LINKABLE_END              (317)

#define CLOCK_NODE_MCHTMR0                        (0)
#define CLOCK_NODE_FEMC                           (1)
#define CLOCK_NODE_XPI0                           (2)
#define CLOCK_NODE_XPI1                           (3)
#define CLOCK_NODE_GPTMR0                         (4)
#define CLOCK_NODE_GPTMR1                         (5)
#define CLOCK_NODE_GPTMR2                         (6)
#define CLOCK_NODE_GPTMR3                         (7)
#define CLOCK_NODE_UART0                          (8)
#define CLOCK_NODE_UART1                          (9)
#define CLOCK_NODE_UART2                          (10)
#define CLOCK_NODE_UART3                          (11)
#define CLOCK_NODE_UART4                          (12)
#define CLOCK_NODE_UART5                          (13)
#define CLOCK_NODE_UART6                          (14)
#define CLOCK_NODE_UART7                          (15)
#define CLOCK_NODE_I2C0                           (16)
#define CLOCK_NODE_I2C1                           (17)
#define CLOCK_NODE_I2C2                           (18)
#define CLOCK_NODE_I2C3                           (19)
#define CLOCK_NODE_SPI0                           (20)
#define CLOCK_NODE_SPI1                           (21)
#define CLOCK_NODE_SPI2                           (22)
#define CLOCK_NODE_SPI3                           (23)
#define CLOCK_NODE_CAN0                           (24)
#define CLOCK_NODE_CAN1                           (25)
#define CLOCK_NODE_PTPC                           (26)
#define CLOCK_NODE_ANA0                           (27)
#define CLOCK_NODE_ANA1                           (28)
#define CLOCK_NODE_ANA2                           (29)
#define CLOCK_NODE_ANA3                           (30)
#define CLOCK_NODE_AUD0                           (31)
#define CLOCK_NODE_AUD1                           (32)
#define CLOCK_NODE_ETH0                           (33)
#define CLOCK_NODE_PTP0                           (34)
#define CLOCK_NODE_REF0                           (35)
#define CLOCK_NODE_REF1                           (36)
#define CLOCK_NODE_NTMR0                          (37)
#define CLOCK_NODE_SDXC0                          (38)

#define CLOCK_NODE_ADC0                           (0)
#define CLOCK_NODE_ADC1                           (1)
#define CLOCK_NODE_ADC2                           (2)

#define CLOCK_NODE_DAC0                           (1)

#define CLOCK_NODE_I2S0                           (0)
#define CLOCK_NODE_I2S1                           (1)

#define CLOCK_NODE_CORE_START                     (252)
#define CLOCK_NODE_CPU0                           (252)
#define CLOCK_NODE_AXI                            (253)
#define CLOCK_NODE_AHB                            (254)

#endif /* __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_SYSCTL_H */
