/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.http;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.http.HttpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClientFactory
implements HttpClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHttpClientFactory.class);
    protected static final String USER_AGENT;

    static {
        StringBuilder userAgent = new StringBuilder("Apache-Olingo");
        InputStream input = AbstractHttpClientFactory.class.getResourceAsStream("/client.properties");
        try {
            Properties prop = new Properties();
            prop.load(input);
            userAgent.append('/').append(prop.getProperty("version"));
        }
        catch (Exception e) {
            LOG.warn("Could not get Apache Olingo version", e);
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        USER_AGENT = userAgent.toString();
    }
}

