/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.invoke;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.invoke.ClientNoContent;
import org.apache.olingo.client.api.communication.response.ODataInvokeResponse;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.api.domain.ClientInvokeResult;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.communication.request.invoke.AbstractODataInvokeRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ODataInvokeRequestImpl<T extends ClientInvokeResult>
extends AbstractODataInvokeRequest<T> {
    private ContentType contentType;

    public ODataInvokeRequestImpl(ODataClient odataClient, Class<T> reference, HttpMethod method, URI uri) {
        super(odataClient, reference, method, uri);
    }

    @Override
    public void setFormat(ContentType contentType) {
        super.setFormat(contentType);
        this.contentType = contentType;
    }

    @Override
    protected ContentType getPOSTParameterFormat() {
        return this.contentType == null ? this.getDefaultFormat() : this.contentType;
    }

    protected class ODataInvokeResponseImpl
    extends AbstractODataResponse
    implements ODataInvokeResponse<T> {
        private T invokeResult;

        private ODataInvokeResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.invokeResult = null;
        }

        public T getBody() {
            if (this.invokeResult == null) {
                try {
                    if (ClientNoContent.class.isAssignableFrom(ODataInvokeRequestImpl.this.reference)) {
                        this.invokeResult = (ClientInvokeResult)ODataInvokeRequestImpl.this.reference.cast(new ClientNoContent());
                    } else {
                        InputStream responseStream;
                        InputStream inputStream = responseStream = this.payload == null ? this.res.getEntity().getContent() : this.payload;
                        if (ClientEntitySet.class.isAssignableFrom(ODataInvokeRequestImpl.this.reference)) {
                            this.invokeResult = (ClientInvokeResult)ODataInvokeRequestImpl.this.reference.cast(this.odataClient.getReader().readEntitySet(responseStream, ContentType.parse((String)this.getContentType())));
                        } else if (ClientEntity.class.isAssignableFrom(ODataInvokeRequestImpl.this.reference)) {
                            this.invokeResult = (ClientInvokeResult)ODataInvokeRequestImpl.this.reference.cast(this.odataClient.getReader().readEntity(responseStream, ContentType.parse((String)this.getContentType())));
                        } else if (ClientProperty.class.isAssignableFrom(ODataInvokeRequestImpl.this.reference)) {
                            this.invokeResult = (ClientInvokeResult)ODataInvokeRequestImpl.this.reference.cast(this.odataClient.getReader().readProperty(responseStream, ContentType.parse((String)this.getContentType())));
                        }
                    }
                }
                catch (IOException e) {
                    throw new HttpClientException((Throwable)e);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.invokeResult;
        }
    }
}

