/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.requests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.RepresentationType;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoCrossjoin;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.core.ContentNegotiator;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.ReturnRepresentation;
import org.apache.olingo.server.core.ServiceHandler;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.responses.CountResponse;
import org.apache.olingo.server.core.responses.EntityResponse;
import org.apache.olingo.server.core.responses.EntitySetResponse;
import org.apache.olingo.server.core.responses.NoContentResponse;
import org.apache.olingo.server.core.responses.PrimitiveValueResponse;
import org.apache.olingo.server.core.responses.PropertyResponse;
import org.apache.olingo.server.core.responses.StreamResponse;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;

public class DataRequest
extends ServiceRequest {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected UriResourceEntitySet uriResourceEntitySet;
    private boolean countRequest;
    private UriResourceProperty uriResourceProperty;
    private boolean valueRequest;
    private final LinkedList<UriResourceNavigation> uriNavigations = new LinkedList();
    private boolean references;
    private RequestType type;
    private UriResourceSingleton uriResourceSingleton;

    public DataRequest(OData odata, ServiceMetadata serviceMetadata) {
        super(odata, serviceMetadata);
    }

    public UriResourceEntitySet getUriResourceEntitySet() {
        return this.uriResourceEntitySet;
    }

    public void setUriResourceEntitySet(UriResourceEntitySet uriResourceEntitySet) {
        this.uriResourceEntitySet = uriResourceEntitySet;
        this.type = new EntityRequest();
    }

    public void setCrossJoin(UriInfoCrossjoin info) {
        this.type = new CrossJoinRequest(info.getEntitySetNames());
    }

    public boolean isSingleton() {
        return this.uriResourceSingleton != null;
    }

    public boolean isCollection() {
        if (!this.uriNavigations.isEmpty()) {
            return this.uriNavigations.getLast().isCollection();
        }
        return this.uriResourceEntitySet != null && this.uriResourceEntitySet.isCollection();
    }

    public EdmEntitySet getEntitySet() {
        return this.uriResourceEntitySet.getEntitySet();
    }

    public boolean isCountRequest() {
        return this.countRequest;
    }

    public void setCountRequest(boolean countRequest) {
        this.countRequest = countRequest;
        this.type = new CountRequest();
    }

    public boolean isPropertyRequest() {
        return this.uriResourceProperty != null;
    }

    public boolean isPropertyComplex() {
        return this.uriResourceProperty instanceof UriResourceComplexProperty;
    }

    public boolean isPropertyStream() {
        if (this.isPropertyComplex()) {
            return false;
        }
        EdmProperty property = ((UriResourcePrimitiveProperty)this.uriResourceProperty).getProperty();
        return property.getType() == this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Stream);
    }

    public UriResourceProperty getUriResourceProperty() {
        return this.uriResourceProperty;
    }

    public void setUriResourceProperty(UriResourceProperty uriResourceProperty) {
        this.uriResourceProperty = uriResourceProperty;
        this.type = new PropertyRequest();
    }

    public LinkedList<UriResourceNavigation> getNavigations() {
        return this.uriNavigations;
    }

    public void addUriResourceNavigation(UriResourceNavigation uriResourceNavigation) {
        this.uriNavigations.add(uriResourceNavigation);
    }

    public UriResourceSingleton getUriResourceSingleton() {
        return this.uriResourceSingleton;
    }

    public void setUriResourceSingleton(UriResourceSingleton info) {
        this.uriResourceSingleton = info;
        this.type = new SingletonRequest();
    }

    public List<UriParameter> getKeyPredicates() {
        if (this.uriResourceEntitySet != null) {
            return this.uriResourceEntitySet.getKeyPredicates();
        }
        return null;
    }

    public boolean isReferenceRequest() {
        return this.references;
    }

    public void setReferenceRequest(boolean ref) {
        this.references = ref;
        this.type = new ReferenceRequest();
    }

    public boolean isValueRequest() {
        return this.valueRequest;
    }

    public void setValueRequest(boolean valueRequest) {
        this.valueRequest = valueRequest;
        this.type = new ValueRequest();
    }

    @Override
    public boolean assertHttpMethod(ODataResponse response) throws ODataHandlerException {
        return this.type.assertHttpMethod(response);
    }

    @Override
    public HttpMethod[] allowedMethods() {
        return this.type.allowedMethods();
    }

    public ContextURL getContextURL(OData odata) throws SerializerException {
        return this.type.getContextURL(odata);
    }

    @Override
    public void execute(ServiceHandler handler, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
        this.assertHttpMethod(response);
        this.type.execute(handler, response);
    }

    @Override
    public <T> T getSerializerOptions(Class<T> serilizerOptions, ContextURL contextUrl, boolean references) throws ContentNegotiatorException {
        if (serilizerOptions.isAssignableFrom(PrimitiveSerializerOptions.class)) {
            String xmlReplacement = null;
            if (this.getResponseContentType().isCompatible(ContentType.APPLICATION_XML) || this.getResponseContentType().isCompatible(ContentType.APPLICATION_ATOM_XML)) {
                xmlReplacement = this.xml10IncompatibleCharReplacement();
            }
            return (T)PrimitiveSerializerOptions.with().contextURL(contextUrl).facetsFrom(this.getUriResourceProperty().getProperty()).xml10InvalidCharReplacement(xmlReplacement).build();
        }
        return super.getSerializerOptions(serilizerOptions, contextUrl, references);
    }

    @Override
    public ContentType getResponseContentType() throws ContentNegotiatorException {
        return this.type.getResponseContentType();
    }

    private Property getPropertyValueFromClient(EdmProperty edmProperty) throws DeserializerException {
        ODataDeserializer deserializer = this.odata.createDeserializer(this.getRequestContentType(), this.getServiceMetaData());
        return deserializer.property(this.getODataRequest().getBody(), edmProperty).getProperty();
    }

    private Object getRawValueFromClient() throws DeserializerException {
        InputStream input = this.getODataRequest().getBody();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (input != null) {
            try {
                ByteBuffer inBuffer = ByteBuffer.allocate(8192);
                ReadableByteChannel ic = Channels.newChannel(input);
                WritableByteChannel oc = Channels.newChannel(buffer);
                while (ic.read(inBuffer) > 0) {
                    inBuffer.flip();
                    oc.write(inBuffer);
                    inBuffer.rewind();
                }
                return buffer.toByteArray();
            }
            catch (IOException e) {
                throw new ODataRuntimeException("Error on reading content");
            }
        }
        return null;
    }

    static ContextURL.Builder buildEntitySetContextURL(UriHelper helper, EdmBindingTarget edmEntitySet, List<UriParameter> keyPredicates, UriInfo uriInfo, LinkedList<UriResourceNavigation> navigations, boolean collectionReturn, boolean singleton, ODataRequest request) throws SerializerException {
        ContextURL.Builder builder = ContextURL.with().entitySetOrSingletonOrType(DataRequest.getTargetEntitySet(edmEntitySet, navigations));
        String select = helper.buildContextURLSelectList((EdmStructuredType)edmEntitySet.getEntityType(), uriInfo.getExpandOption(), uriInfo.getSelectOption());
        if (!singleton) {
            builder.suffix(collectionReturn ? null : ContextURL.Suffix.ENTITY);
        }
        DataRequest.setServiceRoot(builder, request);
        builder.selectList(select);
        UriInfoResource resource = uriInfo.asUriInfoResource();
        List resourceParts = resource.getUriResourceParts();
        List<String> path = DataRequest.getPropertyPath(resourceParts);
        String propertyPath = DataRequest.buildPropertyPath(path);
        String navPath = DataRequest.buildNavPath(helper, edmEntitySet.getEntityType(), navigations, collectionReturn);
        if (navPath != null && !navPath.isEmpty()) {
            if (keyPredicates != null) {
                builder.keyPath(helper.buildContextURLKeyPredicate(keyPredicates));
            }
            propertyPath = propertyPath != null ? navPath + "/" + propertyPath : navPath;
        }
        builder.navOrPropertyPath(propertyPath);
        return builder;
    }

    private static void setServiceRoot(ContextURL.Builder builder, ODataRequest request) {
        String serviceRoot = request.getRawBaseUri();
        if (serviceRoot != null) {
            try {
                if (!serviceRoot.endsWith("/")) {
                    serviceRoot = serviceRoot + "/";
                }
                builder.serviceRoot(URI.create(serviceRoot));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static List<String> getPropertyPath(List<UriResource> path) {
        LinkedList<String> result = new LinkedList<String>();
        for (int index = 1; index < path.size() && path.get(index) instanceof UriResourceProperty; ++index) {
            result.add(((UriResourceProperty)path.get(index)).getProperty().getName());
        }
        return result;
    }

    private static String buildPropertyPath(List<String> path) {
        StringBuilder result = new StringBuilder();
        for (String segment : path) {
            result.append(result.length() == 0 ? "" : Character.valueOf('/')).append(segment);
        }
        return result.length() == 0 ? null : result.toString();
    }

    static String getTargetEntitySet(EdmBindingTarget root, LinkedList<UriResourceNavigation> navigations) {
        EdmEntityType type = root.getEntityType();
        EdmBindingTarget targetEntitySet = root;
        String targetEntitySetName = root.getName();
        String name = null;
        for (UriResourceNavigation nav : navigations) {
            name = nav.getProperty().getName();
            EdmNavigationProperty property = type.getNavigationProperty(name);
            if (property.containsTarget()) {
                return root.getName();
            }
            type = nav.getProperty().getType();
            for (EdmNavigationPropertyBinding enb : targetEntitySet.getNavigationPropertyBindings()) {
                if (enb.getPath().equals(name)) {
                    targetEntitySetName = enb.getTarget();
                    continue;
                }
                if (!enb.getPath().endsWith("/" + name)) continue;
                targetEntitySetName = enb.getTarget();
            }
        }
        return targetEntitySetName;
    }

    static String buildNavPath(UriHelper helper, EdmEntityType rootType, LinkedList<UriResourceNavigation> navigations, boolean includeLastPredicates) throws SerializerException {
        if (navigations.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean containsTarget = false;
        EdmEntityType type = rootType;
        for (UriResourceNavigation nav : navigations) {
            String name = nav.getProperty().getName();
            EdmNavigationProperty property = type.getNavigationProperty(name);
            if (property.containsTarget()) {
                containsTarget = true;
            }
            type = nav.getProperty().getType();
        }
        if (containsTarget) {
            for (int i = 0; i < navigations.size(); ++i) {
                UriResourceNavigation nav;
                nav = navigations.get(i);
                if (i > 0) {
                    sb.append("/");
                }
                sb.append(nav.getProperty().getName());
                boolean skipKeys = false;
                if (navigations.size() == i + 1 && !includeLastPredicates) {
                    skipKeys = true;
                }
                if (!skipKeys && !nav.getKeyPredicates().isEmpty()) {
                    sb.append("(");
                    sb.append(helper.buildContextURLKeyPredicate(nav.getKeyPredicates()));
                    sb.append(")");
                }
                if (nav.getTypeFilterOnCollection() != null) {
                    sb.append("/").append(nav.getTypeFilterOnCollection().getFullQualifiedName().getFullQualifiedNameAsString());
                    continue;
                }
                if (nav.getTypeFilterOnEntry() == null) continue;
                sb.append("/").append(nav.getTypeFilterOnEntry().getFullQualifiedName().getFullQualifiedNameAsString());
            }
        }
        return sb.toString();
    }

    public void setApply(ApplyOption apply) {
        this.type = new ApplyRequest();
    }

    class ApplyRequest
    implements RequestType {
        ApplyRequest() {
        }

        @Override
        public boolean assertHttpMethod(ODataResponse response) throws ODataHandlerException {
            return ServiceRequest.assertHttpMethod(DataRequest.this.httpMethod(), this.allowedMethods(), response);
        }

        @Override
        public HttpMethod[] allowedMethods() {
            return new HttpMethod[]{HttpMethod.GET};
        }

        @Override
        public ContentType getResponseContentType() throws ContentNegotiatorException {
            return ContentNegotiator.doContentNegotiation((FormatOption)DataRequest.this.getUriInfo().getFormatOption(), (ODataRequest)DataRequest.this.getODataRequest(), (CustomContentTypeSupport)DataRequest.this.getCustomContentTypeSupport(), (RepresentationType)RepresentationType.COLLECTION_COMPLEX);
        }

        @Override
        public void execute(ServiceHandler handler, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
            handler.apply(DataRequest.this, response);
        }

        @Override
        public ContextURL getContextURL(OData odata) throws SerializerException {
            ContextURL.Builder builder = ContextURL.with().asCollection();
            return builder.build();
        }
    }

    class CrossJoinRequest
    implements RequestType {
        private final List<String> entitySetNames;

        public CrossJoinRequest(List<String> entitySetNames) {
            this.entitySetNames = entitySetNames;
        }

        @Override
        public boolean assertHttpMethod(ODataResponse response) throws ODataHandlerException {
            return ServiceRequest.assertHttpMethod(DataRequest.this.httpMethod(), this.allowedMethods(), response);
        }

        @Override
        public HttpMethod[] allowedMethods() {
            return new HttpMethod[]{HttpMethod.GET};
        }

        @Override
        public ContentType getResponseContentType() throws ContentNegotiatorException {
            return ContentNegotiator.doContentNegotiation((FormatOption)DataRequest.this.getUriInfo().getFormatOption(), (ODataRequest)DataRequest.this.getODataRequest(), (CustomContentTypeSupport)DataRequest.this.getCustomContentTypeSupport(), (RepresentationType)RepresentationType.COLLECTION_COMPLEX);
        }

        @Override
        public void execute(ServiceHandler handler, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
            handler.crossJoin(DataRequest.this, this.entitySetNames, response);
        }

        @Override
        public ContextURL getContextURL(OData odata) throws SerializerException {
            ContextURL.Builder builder = ContextURL.with().asCollection();
            return builder.build();
        }
    }

    class SingletonRequest
    implements RequestType {
        SingletonRequest() {
        }

        @Override
        public boolean assertHttpMethod(ODataResponse response) throws ODataHandlerException {
            return ServiceRequest.assertHttpMethod(DataRequest.this.httpMethod(), this.allowedMethods(), response);
        }

        @Override
        public HttpMethod[] allowedMethods() {
            return new HttpMethod[]{HttpMethod.GET};
        }

        @Override
        public ContentType getResponseContentType() throws ContentNegotiatorException {
            return ContentNegotiator.doContentNegotiation((FormatOption)DataRequest.this.uriInfo.getFormatOption(), (ODataRequest)DataRequest.this.getODataRequest(), (CustomContentTypeSupport)DataRequest.this.getCustomContentTypeSupport(), (RepresentationType)RepresentationType.ENTITY);
        }

        @Override
        public ContextURL getContextURL(OData odata) throws SerializerException {
            UriHelper helper = odata.createUriHelper();
            ContextURL.Builder builder = DataRequest.buildEntitySetContextURL(helper, (EdmBindingTarget)DataRequest.this.uriResourceSingleton.getSingleton(), null, DataRequest.this.getUriInfo(), DataRequest.this.getNavigations(), DataRequest.this.isCollection(), true, DataRequest.this.getODataRequest());
            return builder.build();
        }

        @Override
        public void execute(ServiceHandler handler, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
            handler.read(DataRequest.this, EntityResponse.getInstance(DataRequest.this, this.getContextURL(DataRequest.this.odata), false, response));
        }
    }

    class ValueRequest
    extends PropertyRequest {
        ValueRequest() {
        }

        @Override
        public boolean assertHttpMethod(ODataResponse response) throws ODataHandlerException {
            if (DataRequest.this.isPropertyStream() && DataRequest.this.isGET()) {
                return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "Edm.Stream properties do not support $value", this.allowedMethods());
            }
            if ((DataRequest.this.isGET() || DataRequest.this.isDELETE() || DataRequest.this.isPropertyStream()) && DataRequest.this.getReturnRepresentation() != ReturnRepresentation.NONE) {
                return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "Invalid Prefer header used", this.allowedMethods());
            }
            return ServiceRequest.assertHttpMethod(DataRequest.this.httpMethod(), this.allowedMethods(), response);
        }

        @Override
        public HttpMethod[] allowedMethods() {
            return new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT, HttpMethod.DELETE};
        }

        @Override
        public ContentType getResponseContentType() throws ContentNegotiatorException {
            RepresentationType valueRepresentationType = DataRequest.this.uriResourceProperty.getType() == DataRequest.this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Binary) ? RepresentationType.BINARY : RepresentationType.VALUE;
            return ContentNegotiator.doContentNegotiation((FormatOption)DataRequest.this.uriInfo.getFormatOption(), (ODataRequest)DataRequest.this.request, (CustomContentTypeSupport)DataRequest.this.getCustomContentTypeSupport(), (RepresentationType)valueRepresentationType);
        }

        @Override
        public void execute(ServiceHandler handler, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
            EdmProperty edmProperty = DataRequest.this.getUriResourceProperty().getProperty();
            if (DataRequest.this.isGET()) {
                handler.read(DataRequest.this, PrimitiveValueResponse.getInstance((ServiceRequest)DataRequest.this, response, DataRequest.this.isCollection(), DataRequest.this.getUriResourceProperty().getProperty()));
            } else if (DataRequest.this.isDELETE()) {
                Property property = new Property(edmProperty.getType().getFullQualifiedName().getFullQualifiedNameAsString(), edmProperty.getName());
                PropertyResponse propertyResponse = PropertyResponse.getInstance(DataRequest.this, response, edmProperty.getType(), this.getContextURL(DataRequest.this.odata), edmProperty.isCollection());
                handler.updateProperty(DataRequest.this, property, true, false, DataRequest.this.getETag(), propertyResponse);
            } else if (DataRequest.this.isPUT()) {
                PropertyResponse propertyResponse = PropertyResponse.getInstance(DataRequest.this, response, edmProperty.getType(), this.getContextURL(DataRequest.this.odata), edmProperty.isCollection());
                Property property = new Property(edmProperty.getType().getFullQualifiedName().getFullQualifiedNameAsString(), edmProperty.getName());
                property.setValue(ValueType.PRIMITIVE, DataRequest.this.getRawValueFromClient());
                handler.updateProperty(DataRequest.this, property, true, false, DataRequest.this.getETag(), propertyResponse);
            }
        }

        @Override
        public ContextURL getContextURL(OData odata) throws SerializerException {
            return null;
        }
    }

    class PropertyRequest
    implements RequestType {
        PropertyRequest() {
        }

        @Override
        public boolean assertHttpMethod(ODataResponse response) throws ODataHandlerException {
            if ((DataRequest.this.isGET() || DataRequest.this.isDELETE() || DataRequest.this.isPropertyStream()) && DataRequest.this.getReturnRepresentation() != ReturnRepresentation.NONE) {
                return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "Invalid Prefer header used", this.allowedMethods());
            }
            if (DataRequest.this.isPATCH() && (DataRequest.this.isCollection() || DataRequest.this.isPropertyStream())) {
                return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "collection properties are not supported for merge", this.allowedMethods());
            }
            return ServiceRequest.assertHttpMethod(DataRequest.this.httpMethod(), this.allowedMethods(), response);
        }

        @Override
        public HttpMethod[] allowedMethods() {
            return new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE};
        }

        @Override
        public ContentType getResponseContentType() throws ContentNegotiatorException {
            if (DataRequest.this.isPropertyComplex()) {
                return ContentNegotiator.doContentNegotiation((FormatOption)DataRequest.this.getUriInfo().getFormatOption(), (ODataRequest)DataRequest.this.getODataRequest(), (CustomContentTypeSupport)DataRequest.this.getCustomContentTypeSupport(), (RepresentationType)(DataRequest.this.isCollection() ? RepresentationType.COLLECTION_COMPLEX : RepresentationType.COMPLEX));
            }
            if (DataRequest.this.isPropertyStream()) {
                return ContentNegotiator.doContentNegotiation((FormatOption)DataRequest.this.uriInfo.getFormatOption(), (ODataRequest)DataRequest.this.request, (CustomContentTypeSupport)DataRequest.this.getCustomContentTypeSupport(), (RepresentationType)RepresentationType.BINARY);
            }
            return ContentNegotiator.doContentNegotiation((FormatOption)DataRequest.this.uriInfo.getFormatOption(), (ODataRequest)DataRequest.this.getODataRequest(), (CustomContentTypeSupport)DataRequest.this.getCustomContentTypeSupport(), (RepresentationType)(DataRequest.this.isCollection() ? RepresentationType.COLLECTION_PRIMITIVE : RepresentationType.PRIMITIVE));
        }

        @Override
        public void execute(ServiceHandler handler, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
            EdmProperty edmProperty = DataRequest.this.getUriResourceProperty().getProperty();
            if (DataRequest.this.isGET()) {
                if (DataRequest.this.isPropertyStream()) {
                    handler.read(DataRequest.this, new StreamResponse(DataRequest.this.getServiceMetaData(), response));
                } else {
                    handler.read(DataRequest.this, this.buildResponse(response, edmProperty));
                }
            } else if (DataRequest.this.isPATCH()) {
                handler.updateProperty(DataRequest.this, DataRequest.this.getPropertyValueFromClient(edmProperty), false, true, DataRequest.this.getETag(), this.buildResponse(response, edmProperty));
            } else if (DataRequest.this.isPUT()) {
                if (DataRequest.this.isPropertyStream()) {
                    handler.upsertStreamProperty(DataRequest.this, DataRequest.this.getETag(), DataRequest.this.request.getBody(), new NoContentResponse(DataRequest.this.getServiceMetaData(), response));
                } else {
                    handler.updateProperty(DataRequest.this, DataRequest.this.getPropertyValueFromClient(edmProperty), false, false, DataRequest.this.getETag(), this.buildResponse(response, edmProperty));
                }
            } else if (DataRequest.this.isDELETE()) {
                if (DataRequest.this.isPropertyStream()) {
                    handler.upsertStreamProperty(DataRequest.this, DataRequest.this.getETag(), null, new NoContentResponse(DataRequest.this.getServiceMetaData(), response));
                } else {
                    Property property = new Property(edmProperty.getType().getFullQualifiedName().getFullQualifiedNameAsString(), edmProperty.getName());
                    handler.updateProperty(DataRequest.this, property, false, false, DataRequest.this.getETag(), this.buildResponse(response, edmProperty));
                }
            }
        }

        private PropertyResponse buildResponse(ODataResponse response, EdmProperty edmProperty) throws ContentNegotiatorException, SerializerException {
            PropertyResponse propertyResponse = PropertyResponse.getInstance(DataRequest.this, response, edmProperty.getType(), this.getContextURL(DataRequest.this.odata), edmProperty.isCollection());
            return propertyResponse;
        }

        @Override
        public ContextURL getContextURL(OData odata) throws SerializerException {
            UriHelper helper = odata.createUriHelper();
            EdmProperty edmProperty = DataRequest.this.getUriResourceProperty().getProperty();
            ContextURL.Builder builder = ContextURL.with().entitySetOrSingletonOrType(DataRequest.getTargetEntitySet((EdmBindingTarget)DataRequest.this.getEntitySet(), DataRequest.this.getNavigations()));
            builder.keyPath(helper.buildContextURLKeyPredicate(DataRequest.this.getUriResourceEntitySet().getKeyPredicates()));
            String navPath = DataRequest.buildNavPath(helper, DataRequest.this.getEntitySet().getEntityType(), DataRequest.this.getNavigations(), true);
            if (navPath != null && !navPath.isEmpty()) {
                builder.navOrPropertyPath(navPath + "/" + edmProperty.getName());
            } else {
                builder.navOrPropertyPath(edmProperty.getName());
            }
            DataRequest.setServiceRoot(builder, DataRequest.this.getODataRequest());
            if (DataRequest.this.isPropertyComplex()) {
                EdmComplexType complexType = ((UriResourceComplexProperty)DataRequest.this.uriResourceProperty).getComplexType();
                String select = helper.buildContextURLSelectList((EdmStructuredType)complexType, DataRequest.this.getUriInfo().getExpandOption(), DataRequest.this.getUriInfo().getSelectOption());
                builder.selectList(select);
            }
            return builder.build();
        }
    }

    class ReferenceRequest
    implements RequestType {
        ReferenceRequest() {
        }

        @Override
        public boolean assertHttpMethod(ODataResponse response) throws ODataHandlerException {
            if ((DataRequest.this.isGET() || DataRequest.this.isDELETE()) && DataRequest.this.getReturnRepresentation() != ReturnRepresentation.NONE) {
                return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "Invalid Prefer header used", this.allowedMethods());
            }
            if (DataRequest.this.getNavigations().isEmpty()) {
                return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "References can be only used on navigation properties", this.allowedMethods());
            }
            if (DataRequest.this.isPOST() && !DataRequest.this.getNavigations().getLast().isCollection()) {
                return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "POST only allowed on collection valued navigation", this.allowedMethods());
            }
            if (DataRequest.this.isPUT() && DataRequest.this.getNavigations().getLast().isCollection()) {
                return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "PUT only allowed on single valued navigation", this.allowedMethods());
            }
            return ServiceRequest.assertHttpMethod(DataRequest.this.httpMethod(), this.allowedMethods(), response);
        }

        @Override
        public HttpMethod[] allowedMethods() {
            return new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE};
        }

        @Override
        public ContentType getResponseContentType() throws ContentNegotiatorException {
            return ContentNegotiator.doContentNegotiation((FormatOption)DataRequest.this.uriInfo.getFormatOption(), (ODataRequest)DataRequest.this.getODataRequest(), (CustomContentTypeSupport)DataRequest.this.getCustomContentTypeSupport(), (RepresentationType)(DataRequest.this.isCollection() ? RepresentationType.COLLECTION_REFERENCE : RepresentationType.REFERENCE));
        }

        @Override
        public void execute(ServiceHandler handler, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
            if (DataRequest.this.isGET()) {
                if (DataRequest.this.isCollection()) {
                    handler.read(DataRequest.this, EntitySetResponse.getInstance(DataRequest.this, this.getContextURL(DataRequest.this.odata), true, response));
                } else {
                    handler.read(DataRequest.this, EntityResponse.getInstance(DataRequest.this, this.getContextURL(DataRequest.this.odata), true, response));
                }
            } else if (DataRequest.this.isDELETE()) {
                String id = DataRequest.this.getQueryParameter("$id");
                if (id == null && DataRequest.this.isCollection()) {
                    throw new UriParserSemanticException("$id not specified for delete of reference", (ODataLibraryException.MessageKey)UriParserSemanticException.MessageKeys.RESOURCE_NOT_FOUND, new String[0]);
                }
                if (id == null) {
                    handler.deleteReference(DataRequest.this, null, DataRequest.this.getETag(), new NoContentResponse(DataRequest.this.getServiceMetaData(), response));
                } else {
                    try {
                        handler.deleteReference(DataRequest.this, new URI(id), DataRequest.this.getETag(), new NoContentResponse(DataRequest.this.getServiceMetaData(), response));
                    }
                    catch (URISyntaxException e) {
                        throw new DeserializerException("failed to read $id", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
                    }
                }
            } else if (DataRequest.this.isPUT()) {
                handler.updateReference(DataRequest.this, DataRequest.this.getETag(), this.getPayload().get(0), new NoContentResponse(DataRequest.this.getServiceMetaData(), response));
            } else if (DataRequest.this.isPOST()) {
                handler.addReference(DataRequest.this, DataRequest.this.getETag(), this.getPayload().get(0), new NoContentResponse(DataRequest.this.getServiceMetaData(), response));
            }
        }

        private List<URI> getPayload() throws DeserializerException {
            ODataDeserializer deserializer = DataRequest.this.odata.createDeserializer(DataRequest.this.getRequestContentType(), DataRequest.this.getServiceMetaData());
            return deserializer.entityReferences(DataRequest.this.getODataRequest().getBody()).getEntityReferences();
        }

        @Override
        public ContextURL getContextURL(OData odata) throws SerializerException {
            ContextURL.Builder builder = ContextURL.with().suffix(ContextURL.Suffix.REFERENCE);
            if (DataRequest.this.isCollection()) {
                builder.asCollection();
            }
            DataRequest.setServiceRoot(builder, DataRequest.this.getODataRequest());
            return builder.build();
        }
    }

    class CountRequest
    implements RequestType {
        CountRequest() {
        }

        @Override
        public boolean assertHttpMethod(ODataResponse response) throws ODataHandlerException {
            if (DataRequest.this.getReturnRepresentation() != ReturnRepresentation.NONE) {
                return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "Invalid Prefer header used", this.allowedMethods());
            }
            return ServiceRequest.assertHttpMethod(DataRequest.this.httpMethod(), this.allowedMethods(), response);
        }

        @Override
        public HttpMethod[] allowedMethods() {
            return new HttpMethod[]{HttpMethod.GET};
        }

        @Override
        public ContentType getResponseContentType() throws ContentNegotiatorException {
            return ContentType.TEXT_PLAIN;
        }

        @Override
        public void execute(ServiceHandler handler, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
            handler.read(DataRequest.this, CountResponse.getInstance(DataRequest.this, response));
        }

        @Override
        public ContextURL getContextURL(OData odata) throws SerializerException {
            return null;
        }
    }

    class EntityRequest
    implements RequestType {
        EntityRequest() {
        }

        @Override
        public boolean assertHttpMethod(ODataResponse response) throws ODataHandlerException {
            if (!DataRequest.this.getNavigations().isEmpty()) {
                if (DataRequest.this.isPOST()) {
                    UriResourceNavigation last = DataRequest.this.getNavigations().getLast();
                    if (!(DataRequest.this.getEntitySet().getRelatedBindingTarget(last.getProperty().getName()) instanceof EdmEntitySet)) {
                        return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "navigation updates must be to an entity contained in an entity set", this.allowedMethods());
                    }
                } else if (!DataRequest.this.isGET()) {
                    return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "update/delete to navigation property is done through references", this.allowedMethods());
                }
            }
            if ((DataRequest.this.isGET() || DataRequest.this.isDELETE()) && DataRequest.this.getReturnRepresentation() != ReturnRepresentation.NONE) {
                return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "Invalid prefer header used", this.allowedMethods());
            }
            if ((DataRequest.this.isPATCH() || DataRequest.this.isPUT() || DataRequest.this.isDELETE()) && (DataRequest.this.getKeyPredicates() == null || DataRequest.this.getKeyPredicates().isEmpty())) {
                return ServiceRequest.methodNotAllowed(response, DataRequest.this.httpMethod(), "No key predicates provided", this.allowedMethods());
            }
            return ServiceRequest.assertHttpMethod(DataRequest.this.httpMethod(), this.allowedMethods(), response);
        }

        @Override
        public HttpMethod[] allowedMethods() {
            return new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE};
        }

        @Override
        public ContentType getResponseContentType() throws ContentNegotiatorException {
            return ContentNegotiator.doContentNegotiation((FormatOption)DataRequest.this.uriInfo.getFormatOption(), (ODataRequest)DataRequest.this.getODataRequest(), (CustomContentTypeSupport)DataRequest.this.getCustomContentTypeSupport(), (RepresentationType)(DataRequest.this.isCollection() ? RepresentationType.COLLECTION_ENTITY : RepresentationType.ENTITY));
        }

        @Override
        public void execute(ServiceHandler handler, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
            ContextURL contextURL = this.getContextURL(DataRequest.this.odata);
            EntityResponse entityResponse = EntityResponse.getInstance(DataRequest.this, contextURL, false, response);
            if (DataRequest.this.isGET()) {
                if (DataRequest.this.isCollection()) {
                    handler.read(DataRequest.this, EntitySetResponse.getInstance(DataRequest.this, contextURL, false, response));
                } else {
                    handler.read(DataRequest.this, entityResponse);
                }
            } else if (DataRequest.this.isPUT() || DataRequest.this.isPATCH()) {
                boolean ifNoneMatch;
                boolean ifMatch = DataRequest.this.getHeader("If-Match") != null;
                boolean bl = ifNoneMatch = DataRequest.this.getHeader("If-None-Match") != null && "*".equals(DataRequest.this.getHeader("If-None-Match"));
                if (ifMatch) {
                    handler.updateEntity(DataRequest.this, this.getEntityFromClient(), DataRequest.this.isPATCH(), DataRequest.this.getETag(), entityResponse);
                } else if (ifNoneMatch) {
                    entityResponse = EntityResponse.getInstance(DataRequest.this, contextURL, false, response, DataRequest.this.getReturnRepresentation());
                    handler.createEntity(DataRequest.this, this.getEntityFromClient(), entityResponse);
                } else {
                    handler.upsertEntity(DataRequest.this, this.getEntityFromClient(), DataRequest.this.isPATCH(), DataRequest.this.getETag(), entityResponse);
                }
            } else if (DataRequest.this.isPOST()) {
                if (!DataRequest.this.getNavigations().isEmpty()) {
                    entityResponse = EntityResponse.getInstance(DataRequest.this, contextURL, false, response, DataRequest.this.getReturnRepresentation());
                    UriResourceNavigation last = DataRequest.this.getNavigations().getLast();
                    EdmEntityType navigationType = last.getProperty().getType();
                    Entity entity = this.getEntityFromClient(navigationType);
                    handler.createEntity(DataRequest.this, entity, entityResponse);
                } else {
                    entityResponse = EntityResponse.getInstance(DataRequest.this, contextURL, false, response, DataRequest.this.getReturnRepresentation());
                    handler.createEntity(DataRequest.this, this.getEntityFromClient(), entityResponse);
                }
            } else if (DataRequest.this.isDELETE()) {
                handler.deleteEntity(DataRequest.this, DataRequest.this.getETag(), entityResponse);
            }
        }

        private Entity getEntityFromClient() throws DeserializerException {
            return this.getEntityFromClient(DataRequest.this.getEntitySet().getEntityType());
        }

        private Entity getEntityFromClient(EdmEntityType entityType) throws DeserializerException {
            ODataDeserializer deserializer = DataRequest.this.odata.createDeserializer(DataRequest.this.getRequestContentType(), DataRequest.this.getServiceMetaData());
            return deserializer.entity(DataRequest.this.getODataRequest().getBody(), entityType).getEntity();
        }

        @Override
        public ContextURL getContextURL(OData odata) throws SerializerException {
            UriHelper helper = odata.createUriHelper();
            ContextURL.Builder builder = DataRequest.buildEntitySetContextURL(helper, (EdmBindingTarget)DataRequest.this.getEntitySet(), DataRequest.this.getKeyPredicates(), DataRequest.this.getUriInfo(), DataRequest.this.getNavigations(), DataRequest.this.isCollection(), false, DataRequest.this.getODataRequest());
            return builder.build();
        }
    }

    static interface RequestType {
        public HttpMethod[] allowedMethods();

        public boolean assertHttpMethod(ODataResponse var1) throws ODataHandlerException;

        public ContentType getResponseContentType() throws ContentNegotiatorException;

        public ContextURL getContextURL(OData var1) throws SerializerException;

        public void execute(ServiceHandler var1, ODataResponse var2) throws ODataLibraryException, ODataApplicationException;
    }
}

