/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.olingo.commons.api.IConstants;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.serializer.utils.ContentTypeHelper;

public class ODataJsonInstanceAnnotationSerializer {
    private final boolean isODataMetadataNone;
    private final boolean isODataMetadataFull;
    private IConstants constants;
    private final boolean isIEEE754Compatible;

    public ODataJsonInstanceAnnotationSerializer(ContentType contentType, IConstants constants) {
        this.isIEEE754Compatible = ContentTypeHelper.isODataIEEE754Compatible(contentType);
        this.isODataMetadataNone = ContentTypeHelper.isODataMetadataNone(contentType);
        this.isODataMetadataFull = ContentTypeHelper.isODataMetadataFull(contentType);
        this.constants = constants;
    }

    public void writeInstanceAnnotationsOnEntity(List<Annotation> annotations, JsonGenerator json) throws IOException, SerializerException, DecoderException {
        for (Annotation annotation : annotations) {
            if (this.isODataMetadataFull) {
                json.writeStringField(this.constants.getType(), "#" + annotation.getType());
            }
            json.writeFieldName("@" + annotation.getTerm());
            this.writeInstanceAnnotation(json, (Valuable)annotation, "");
        }
    }

    public void writeInstanceAnnotationsOnProperties(EdmProperty edmProperty, Property property, JsonGenerator json) throws IOException, SerializerException, DecoderException {
        if (property != null) {
            for (Annotation annotation : property.getAnnotations()) {
                json.writeFieldName(edmProperty.getName() + "@" + annotation.getTerm());
                this.writeInstanceAnnotation(json, (Valuable)annotation, "");
            }
        }
    }

    private void writeInstanceAnnotation(JsonGenerator json, Valuable annotation, String name) throws IOException, SerializerException, DecoderException {
        try {
            switch (annotation.getValueType()) {
                case PRIMITIVE: {
                    if (this.isODataMetadataFull && name.length() > 0) {
                        json.writeStringField(name + this.constants.getType(), "#" + annotation.getType());
                    }
                    if (name.length() > 0) {
                        json.writeFieldName(name);
                    }
                    this.writeInstanceAnnotOnPrimitiveProperty(json, annotation, annotation.getValue());
                    break;
                }
                case COLLECTION_PRIMITIVE: {
                    if (this.isODataMetadataFull && name.length() > 0) {
                        json.writeStringField(name + this.constants.getType(), "#Collection(" + annotation.getType() + ")");
                    }
                    if (name.length() > 0) {
                        json.writeFieldName(name);
                    }
                    json.writeStartArray();
                    List list = annotation.asCollection();
                    for (Object value : list) {
                        this.writeInstanceAnnotOnPrimitiveProperty(json, annotation, value);
                    }
                    json.writeEndArray();
                    break;
                }
                case COMPLEX: {
                    if (this.isODataMetadataFull && name.length() > 0) {
                        json.writeStringField(name + this.constants.getType(), "#" + annotation.getType());
                    }
                    if (name.length() > 0) {
                        json.writeFieldName(name);
                    }
                    ComplexValue complexValue = annotation.asComplex();
                    this.writeInstanceAnnotOnComplexProperty(json, annotation, complexValue);
                    break;
                }
                case COLLECTION_COMPLEX: {
                    if (this.isODataMetadataFull && name.length() > 0) {
                        json.writeStringField(name + this.constants.getType(), "#Collection(" + annotation.getType() + ")");
                    }
                    if (name.length() > 0) {
                        json.writeFieldName(name);
                    }
                    json.writeStartArray();
                    List complexValues = annotation.asCollection();
                    for (ComplexValue complxValue : complexValues) {
                        this.writeInstanceAnnotOnComplexProperty(json, annotation, complxValue);
                    }
                    json.writeEndArray();
                    break;
                }
            }
        }
        catch (EdmPrimitiveTypeException e) {
            throw new SerializerException("Wrong value for instance annotation!", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{((Annotation)annotation).getTerm(), annotation.getValue().toString()});
        }
    }

    private void writeInstanceAnnotOnComplexProperty(JsonGenerator json, Valuable annotation, ComplexValue complexValue) throws IOException, SerializerException, DecoderException {
        json.writeStartObject();
        if (this.isODataMetadataFull) {
            json.writeStringField(this.constants.getType(), "#" + complexValue.getTypeName());
        }
        List properties = complexValue.getValue();
        for (Property prop : properties) {
            this.writeInstanceAnnotation(json, (Valuable)prop, prop.getName());
        }
        json.writeEndObject();
    }

    private void writeInstanceAnnotOnPrimitiveProperty(JsonGenerator json, Valuable annotation, Object value) throws IOException, EdmPrimitiveTypeException {
        this.writePrimitiveValue("", EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.getByName((String)annotation.getType())), value, null, null, null, null, true, json);
    }

    protected void writePrimitiveValue(String name, EdmPrimitiveType type, Object primitiveValue, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws EdmPrimitiveTypeException, IOException {
        String value = type.valueToString(primitiveValue, isNullable, maxLength, precision, scale, isUnicode);
        if (value == null) {
            json.writeNull();
        } else if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Boolean)) {
            json.writeBoolean(Boolean.parseBoolean(value));
        } else if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Byte) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Double) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int16) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int32) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.SByte) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Single) || (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Decimal) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int64)) && !this.isIEEE754Compatible) {
            json.writeNumber(value);
        } else if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Stream)) {
            if (primitiveValue instanceof Link) {
                Link stream = (Link)primitiveValue;
                if (!this.isODataMetadataNone) {
                    if (stream.getMediaETag() != null) {
                        json.writeStringField(name + this.constants.getMediaEtag(), stream.getMediaETag());
                    }
                    if (stream.getType() != null) {
                        json.writeStringField(name + this.constants.getMediaContentType(), stream.getType());
                    }
                }
                if (this.isODataMetadataFull) {
                    if (stream.getRel() != null && stream.getRel().equals("http://docs.oasis-open.org/odata/ns/mediaresource/")) {
                        json.writeStringField(name + this.constants.getMediaReadLink(), stream.getHref());
                    }
                    if (stream.getRel() == null || stream.getRel().equals("http://docs.oasis-open.org/odata/ns/edit-media/")) {
                        json.writeStringField(name + this.constants.getMediaEditLink(), stream.getHref());
                    }
                }
            }
        } else {
            json.writeString(value);
        }
    }
}

