/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.core.serialization.JsonSerializer;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class JsonPropertySerializer
extends JsonSerializer {
    public JsonPropertySerializer(boolean serverMode, ContentType contentType) {
        super(serverMode, contentType);
    }

    protected void doSerialize(Property property, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        this.doContainerSerialize(new ResWrap<Property>(null, null, property), jgen);
    }

    protected void doContainerSerialize(ResWrap<Property> container, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        Property property = container.getPayload();
        jgen.writeStartObject();
        if (this.serverMode && container.getContextURL() != null && !this.isODataMetadataNone) {
            jgen.writeStringField("@odata.context", container.getContextURL().toASCIIString());
        }
        if (StringUtils.isNotBlank(property.getType()) && this.isODataMetadataFull) {
            jgen.writeStringField("@odata.type", new EdmTypeInfo.Builder().setTypeExpression(property.getType()).build().external());
        }
        for (Annotation annotation : property.getAnnotations()) {
            this.valuable(jgen, annotation, "@" + annotation.getTerm());
        }
        if (property.isNull()) {
            jgen.writeBooleanField("odata.null", true);
        } else if (property.isGeospatial() || property.isCollection()) {
            this.valuable(jgen, property, "value");
        } else if (property.isPrimitive()) {
            EdmTypeInfo typeInfo = property.getType() == null ? null : new EdmTypeInfo.Builder().setTypeExpression(property.getType()).build();
            jgen.writeFieldName("value");
            this.primitiveValue(jgen, typeInfo, property.asPrimitive());
        } else if (property.isEnum()) {
            jgen.writeStringField("value", property.asEnum().toString());
        } else if (property.isComplex()) {
            for (Property cproperty : property.asComplex().getValue()) {
                this.valuable(jgen, cproperty, cproperty.getName());
            }
        } else if (property.isComplex()) {
            for (Property cproperty : property.asComplex().getValue()) {
                this.valuable(jgen, cproperty, cproperty.getName());
            }
        }
        jgen.writeEndObject();
    }
}

