/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.annotation;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.annotation.EdmCast;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlCast;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmAnnotatableDynamicExpression;

public class EdmCastImpl
extends AbstractEdmAnnotatableDynamicExpression
implements EdmCast {
    private final CsdlCast cast;
    private EdmExpression value;
    private EdmType type;

    public EdmCastImpl(Edm edm, CsdlCast csdlExp) {
        super(edm, "Cast", (CsdlAnnotatable)csdlExp);
        this.cast = csdlExp;
    }

    public Integer getMaxLength() {
        return this.cast.getMaxLength();
    }

    public Integer getPrecision() {
        return this.cast.getPrecision();
    }

    public Integer getScale() {
        return this.cast.getScale();
    }

    public SRID getSrid() {
        return this.cast.getSrid();
    }

    public EdmType getType() {
        if (this.type == null) {
            if (this.cast.getType() == null) {
                throw new EdmException("Must specify a type for a Cast expression.");
            }
            EdmTypeInfo typeInfo = new EdmTypeInfo.Builder().setEdm(this.edm).setTypeExpression(this.cast.getType()).build();
            this.type = typeInfo.getType();
        }
        return this.type;
    }

    public EdmExpression getValue() {
        if (this.value == null) {
            if (this.cast.getValue() == null) {
                throw new EdmException("Cast expressions require an expression value.");
            }
            this.value = EdmCastImpl.getExpression(this.edm, this.cast.getValue());
        }
        return this.value;
    }

    public EdmExpression.EdmExpressionType getExpressionType() {
        return EdmExpression.EdmExpressionType.Cast;
    }
}

