/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.http;

import java.net.URI;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.olingo.client.core.http.DefaultHttpClientFactory;
import org.apache.olingo.commons.api.http.HttpMethod;

public class NTLMAuthHttpClientFactory
extends DefaultHttpClientFactory {
    private final String username;
    private final String password;
    private final String workstation;
    private final String domain;

    public NTLMAuthHttpClientFactory(String username, String password, String workstation, String domain) {
        this.username = username;
        this.password = password;
        this.workstation = workstation;
        this.domain = domain;
    }

    @Override
    public DefaultHttpClient create(HttpMethod method, URI uri) {
        DefaultHttpClient httpclient = super.create(method, uri);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(this.username, this.password, this.workstation, this.domain));
        httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        return httpclient;
    }
}

