/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.olingo.commons.api.data.EntityMediaObject;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.deserializer.batch.ODataResponsePart;
import org.apache.olingo.server.api.serializer.BatchSerializerException;
import org.apache.olingo.server.api.serializer.FixedFormatSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveValueSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerStreamResult;
import org.apache.olingo.server.core.ODataWritableContent;
import org.apache.olingo.server.core.serializer.AsyncResponseSerializer;
import org.apache.olingo.server.core.serializer.BatchResponseSerializer;

public class FixedFormatSerializerImpl
implements FixedFormatSerializer {
    public InputStream binary(byte[] binary) throws SerializerException {
        return new ByteArrayInputStream(binary);
    }

    protected void binary(EntityMediaObject mediaEntity, OutputStream outputStream) throws SerializerException {
        try {
            outputStream.write(mediaEntity.getBytes());
        }
        catch (IOException e) {
            throw new SerializerException("IO Exception occured ", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    public void binaryIntoStreamed(EntityMediaObject mediaEntity, OutputStream outputStream) throws SerializerException {
        this.binary(mediaEntity, outputStream);
    }

    public SerializerStreamResult mediaEntityStreamed(EntityMediaObject mediaEntity) throws SerializerException {
        return ODataWritableContent.with(mediaEntity, this).build();
    }

    public InputStream count(Integer count) throws SerializerException {
        try {
            return new ByteArrayInputStream(count.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializerException("UTF-8 is nott supprted as an encoding", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_ENCODING, new String[]{"UTF-8"});
        }
    }

    public InputStream primitiveValue(EdmPrimitiveType type, Object value, PrimitiveValueSerializerOptions options) throws SerializerException {
        try {
            String result = type.valueToString(value, options.isNullable(), options.getMaxLength(), options.getPrecision(), options.getScale(), options.isUnicode());
            return new ByteArrayInputStream(result.getBytes("UTF-8"));
        }
        catch (EdmPrimitiveTypeException e) {
            throw new SerializerException("Error in primitive-value formatting.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_PRIMITIVE_VALUE, new String[]{type.getFullQualifiedName().getFullQualifiedNameAsString(), value.toString()});
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializerException("Encoding exception.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    public InputStream asyncResponse(ODataResponse odataResponse) throws SerializerException {
        AsyncResponseSerializer serializer = new AsyncResponseSerializer();
        return serializer.serialize(odataResponse);
    }

    public InputStream batchResponse(List<ODataResponsePart> batchResponses, String boundary) throws BatchSerializerException {
        BatchResponseSerializer serializer = new BatchResponseSerializer();
        return serializer.serialize(batchResponses, boundary);
    }
}

