/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.commons.api.format.TypeUtil;

public final class ContentType {
    private static final String APPLICATION = "application";
    private static final String TEXT = "text";
    private static final String MULTIPART = "multipart";
    public static final String PARAMETER_CHARSET = "charset";
    public static final String PARAMETER_IEEE754_COMPATIBLE = "IEEE754Compatible";
    public static final String PARAMETER_ODATA_METADATA = "odata.metadata";
    public static final String VALUE_ODATA_METADATA_NONE = "none";
    public static final String VALUE_ODATA_METADATA_MINIMAL = "minimal";
    public static final String VALUE_ODATA_METADATA_FULL = "full";
    public static final ContentType APPLICATION_JSON = new ContentType("application", "json", null);
    public static final ContentType JSON = ContentType.create(APPLICATION_JSON, "odata.metadata", "minimal");
    public static final ContentType JSON_NO_METADATA = ContentType.create(APPLICATION_JSON, "odata.metadata", "none");
    public static final ContentType JSON_FULL_METADATA = ContentType.create(APPLICATION_JSON, "odata.metadata", "full");
    public static final ContentType APPLICATION_XML = new ContentType("application", "xml", null);
    public static final ContentType APPLICATION_ATOM_XML = new ContentType("application", "atom+xml", null);
    public static final ContentType APPLICATION_ATOM_XML_ENTRY = ContentType.create(APPLICATION_ATOM_XML, "type", "entry");
    public static final ContentType APPLICATION_ATOM_XML_ENTRY_UTF8 = ContentType.create(APPLICATION_ATOM_XML_ENTRY, "charset", "utf-8");
    public static final ContentType APPLICATION_ATOM_XML_FEED = ContentType.create(APPLICATION_ATOM_XML, "type", "feed");
    public static final ContentType APPLICATION_ATOM_XML_FEED_UTF8 = ContentType.create(APPLICATION_ATOM_XML_FEED, "charset", "utf-8");
    public static final ContentType APPLICATION_ATOM_SVC = new ContentType("application", "atomsvc+xml", null);
    public static final ContentType APPLICATION_OCTET_STREAM = new ContentType("application", "octet-stream", null);
    public static final ContentType APPLICATION_XHTML_XML = new ContentType("application", "xhtml+xml", null);
    public static final ContentType TEXT_HTML = new ContentType("text", "html", null);
    public static final ContentType TEXT_XML = new ContentType("text", "xml", null);
    public static final ContentType TEXT_PLAIN = new ContentType("text", "plain", null);
    public static final ContentType APPLICATION_SVG_XML = new ContentType("application", "svg+xml", null);
    public static final ContentType APPLICATION_FORM_URLENCODED = new ContentType("application", "x-www-form-urlencoded", null);
    public static final ContentType APPLICATION_HTTP = new ContentType("application", "http", null);
    public static final ContentType MULTIPART_MIXED = new ContentType("multipart", "mixed", null);
    public static final ContentType MULTIPART_FORM_DATA = new ContentType("multipart", "form-data", null);
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;

    private ContentType(String type, String subtype, Map<String, String> parameters) {
        this.type = this.validateType(type);
        this.subtype = this.validateType(subtype);
        if (parameters == null) {
            this.parameters = Collections.emptyMap();
        } else {
            this.parameters = TypeUtil.createParameterMap();
            this.parameters.putAll(parameters);
        }
    }

    private String validateType(String type) throws IllegalArgumentException {
        if (type == null || type.isEmpty() || "*".equals(type)) {
            throw new IllegalArgumentException("Illegal type '" + type + "'.");
        }
        if (type.indexOf(32) >= 0) {
            throw new IllegalArgumentException("Illegal whitespace found for type '" + type + "'.");
        }
        return type;
    }

    public static ContentType create(ContentType contentType, String parameterName, String parameterValue) throws IllegalArgumentException {
        TypeUtil.validateParameterNameAndValue(parameterName, parameterValue);
        ContentType type = new ContentType(contentType.type, contentType.subtype, contentType.parameters);
        type.parameters.put(parameterName.toLowerCase(Locale.ROOT), parameterValue);
        return type;
    }

    public static ContentType create(String format) throws IllegalArgumentException {
        if (format == null) {
            throw new IllegalArgumentException("Parameter format MUST NOT be NULL.");
        }
        ArrayList<String> typeSubtype = new ArrayList<String>();
        HashMap<String, String> parameters = new HashMap<String, String>();
        ContentType.parse(format, typeSubtype, parameters);
        return new ContentType((String)typeSubtype.get(0), (String)typeSubtype.get(1), parameters);
    }

    public static ContentType parse(String format) {
        try {
            return ContentType.create(format);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parse(String format, List<String> typeSubtype, Map<String, String> parameters) throws IllegalArgumentException {
        String params;
        String[] typesAndParameters = format.split(";", 2);
        String types = typesAndParameters[0];
        String string = params = typesAndParameters.length > 1 ? typesAndParameters[1] : null;
        if (!types.contains("/")) throw new IllegalArgumentException("No separator '/' was found in format '" + format + "'.");
        String[] tokens = types.split("/");
        if (tokens.length != 2) throw new IllegalArgumentException("Too many '/' in format '" + format + "'.");
        if (tokens[0] == null || tokens[0].isEmpty()) {
            throw new IllegalArgumentException("No type found in format '" + format + "'.");
        }
        if (tokens[1] == null || tokens[1].isEmpty()) {
            throw new IllegalArgumentException("No subtype found in format '" + format + "'.");
        }
        typeSubtype.add(tokens[0]);
        typeSubtype.add(tokens[1]);
        TypeUtil.parseParameters(params, parameters);
    }

    public static ContentType fromAcceptHeader(String accept) {
        String cleanedAcceptType;
        if (accept == null || accept.trim().isEmpty()) {
            return JSON;
        }
        String acceptType = accept.split(",")[0];
        if (acceptType == null || acceptType.trim().isEmpty()) {
            return JSON;
        }
        int semicolonIndex = acceptType.indexOf(59);
        if (semicolonIndex == -1) {
            cleanedAcceptType = acceptType.trim();
        } else {
            cleanedAcceptType = acceptType.trim().substring(0, semicolonIndex).trim();
            if (cleanedAcceptType.trim().isEmpty()) {
                return JSON;
            }
        }
        try {
            return ContentType.create(cleanedAcceptType);
        }
        catch (Exception exception) {
            return accept.contains("xml") ? APPLICATION_ATOM_XML : JSON;
        }
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getParameter(String name) {
        return this.parameters.get(name.toLowerCase(Locale.ROOT));
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        if (!this.isCompatible(other)) {
            return false;
        }
        if (this.parameters.size() == other.parameters.size()) {
            Iterator<Map.Entry<String, String>> entries = this.parameters.entrySet().iterator();
            Iterator<Map.Entry<String, String>> otherEntries = other.parameters.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, String> e = entries.next();
                Map.Entry<String, String> oe = otherEntries.next();
                if (ContentType.areEqual(e.getKey(), oe.getKey()) && ContentType.areEqual(e.getValue(), oe.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isCompatible(ContentType other) {
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype);
    }

    private static boolean areEqual(String first, String second) {
        return first == null && second == null || first != null && first.equalsIgnoreCase(second);
    }

    public String toContentTypeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type).append("/").append(this.subtype);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            sb.append(";").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toContentTypeString();
    }
}

