/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMin;

public class DecimalMinValidatorForString
implements ConstraintValidator<DecimalMin, String> {
    private BigDecimal minValue;

    @Override
    public void initialize(DecimalMin annotation) {
        try {
            this.minValue = new BigDecimal(annotation.value());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(annotation.value() + " does not represent a valid BigDecimal format");
        }
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        try {
            return new BigDecimal(value).compareTo(this.minValue) != -1;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

