/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import javax.persistence.Parameter;

public class ParameterImpl<T>
implements Parameter<T> {
    private final String _name;
    private final Integer _position;
    private final Class<T> _expectedValueType;

    public ParameterImpl(Integer position, Class<T> expectedValueType) {
        this._name = null;
        this._position = position;
        this._expectedValueType = expectedValueType;
    }

    public ParameterImpl(String name, Class<T> expectedValueType) {
        this._name = name;
        this._position = null;
        this._expectedValueType = expectedValueType;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final Integer getPosition() {
        return this._position;
    }

    @Override
    public Class<T> getParameterType() {
        return this._expectedValueType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Parameter)) {
            return false;
        }
        Parameter that = (Parameter)other;
        if (this._name != null) {
            return this._name.equals(that.getName());
        }
        if (this._position != null) {
            return this._position.equals(that.getPosition());
        }
        return false;
    }

    public int hashCode() {
        return this._expectedValueType.hashCode() ^ (this._name != null ? this._name.hashCode() : 0) ^ (this._position != null ? this._position.hashCode() : 0);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Parameter");
        buf.append("<" + this.getParameterType().getSimpleName() + ">");
        if (this._name != null) {
            buf.append("('" + this._name + "')");
        } else if (this._position != null) {
            buf.append("(" + this._position + ")");
        } else {
            buf.append("(?)");
        }
        return buf.toString();
    }
}

