/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.LocalVariableInstruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class LoadInstruction
extends LocalVariableInstruction {
    private static final Class[][] _mappings = new Class[][]{{Byte.TYPE, Integer.TYPE}, {Boolean.TYPE, Integer.TYPE}, {Character.TYPE, Integer.TYPE}, {Short.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}};
    String _type = null;

    LoadInstruction(Code owner) {
        super(owner);
    }

    LoadInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    @Override
    int getLength() {
        switch (this.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return super.getLength() + 1;
            }
        }
        return super.getLength();
    }

    @Override
    public int getStackChange() {
        switch (this.getOpcode()) {
            case 22: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public int getLogicalStackChange() {
        switch (this.getOpcode()) {
            case 0: {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public String getTypeName() {
        switch (this.getOpcode()) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return Integer.TYPE.getName();
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return Long.TYPE.getName();
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return Float.TYPE.getName();
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return Double.TYPE.getName();
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return Object.class.getName();
            }
        }
        return this._type;
    }

    @Override
    public TypedInstruction setType(String type) {
        type = this.mapType(type, _mappings, true);
        int local = this.getLocal();
        int len = this.getLength();
        if (type == null || local < 0) {
            this._type = type;
            this.setOpcode(0);
        } else {
            this._type = null;
            switch (type.charAt(0)) {
                case 'i': {
                    this.setOpcode(local > 3 ? 21 : 26 + local);
                    break;
                }
                case 'l': {
                    this.setOpcode(local > 3 ? 22 : 30 + local);
                    break;
                }
                case 'f': {
                    this.setOpcode(local > 3 ? 23 : 34 + local);
                    break;
                }
                case 'd': {
                    this.setOpcode(local > 3 ? 24 : 38 + local);
                    break;
                }
                default: {
                    this.setOpcode(local > 3 ? 25 : 42 + local);
                }
            }
        }
        if (len != this.getLength()) {
            this.invalidateByteIndexes();
        }
        return this;
    }

    public LoadInstruction setThis() {
        return (LoadInstruction)this.setLocal(0).setType(Object.class);
    }

    public boolean isThis() {
        return this.getLocal() == 0 && this.getType() == Object.class;
    }

    @Override
    public boolean equalsInstruction(Instruction other) {
        if (other == this) {
            return true;
        }
        if (!super.equalsInstruction(other)) {
            return false;
        }
        String type = this.getTypeName();
        String otherType = ((LoadInstruction)other).getTypeName();
        return type == null || otherType == null || type.equals(otherType);
    }

    @Override
    public void acceptVisit(BCVisitor visit) {
        visit.enterLoadInstruction(this);
        visit.exitLoadInstruction(this);
    }

    @Override
    void read(Instruction orig) {
        super.read(orig);
        LoadInstruction ins = (LoadInstruction)orig;
        this._type = ins._type;
    }

    @Override
    void read(DataInput in) throws IOException {
        super.read(in);
        switch (this.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.setLocal(in.readUnsignedByte());
            }
        }
    }

    @Override
    void write(DataOutput out) throws IOException {
        super.write(out);
        switch (this.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                out.writeByte(this.getLocal());
            }
        }
    }

    @Override
    void calculateOpcode() {
        this.setType(this.getTypeName());
    }

    @Override
    void calculateLocal() {
        switch (this.getOpcode()) {
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 42: {
                this.setLocal(0);
                break;
            }
            case 27: 
            case 31: 
            case 35: 
            case 39: 
            case 43: {
                this.setLocal(1);
                break;
            }
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: {
                this.setLocal(2);
                break;
            }
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: {
                this.setLocal(3);
            }
        }
    }
}

