/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.util.ArrayList;
import java.util.Objects;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.util.Cache;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;

public class ConfigurablePOSContextGenerator
implements POSContextGenerator {
    private Cache<String, String[]> contextsCache;
    private Object wordsKey;
    private final AdaptiveFeatureGenerator featureGenerator;

    public ConfigurablePOSContextGenerator(AdaptiveFeatureGenerator featureGenerator) {
        this(0, featureGenerator);
    }

    public ConfigurablePOSContextGenerator(int cacheSize, AdaptiveFeatureGenerator featureGenerator) {
        this.featureGenerator = Objects.requireNonNull(featureGenerator, "featureGenerator must not be null");
        if (cacheSize > 0) {
            this.contextsCache = new Cache(cacheSize);
        }
    }

    @Override
    public String[] getContext(int index, String[] tokens, String[] tags, Object[] additionalContext) {
        String tagprev = null;
        String tagprevprev = null;
        if (index - 1 >= 0) {
            tagprev = tags[index - 1];
            if (index - 2 >= 0) {
                tagprevprev = tags[index - 2];
            }
        }
        String cacheKey = index + tagprev + tagprevprev;
        if (this.contextsCache != null) {
            if (this.wordsKey == tokens) {
                String[] cachedContexts = (String[])this.contextsCache.get(cacheKey);
                if (cachedContexts != null) {
                    return cachedContexts;
                }
            } else {
                this.contextsCache.clear();
                this.wordsKey = tokens;
            }
        }
        ArrayList<String> e = new ArrayList<String>();
        this.featureGenerator.createFeatures(e, tokens, index, tags);
        String[] contexts = e.toArray(new String[0]);
        if (this.contextsCache != null) {
            this.contextsCache.put(cacheKey, contexts);
        }
        return contexts;
    }
}

