/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.paimon.memory;

import javax.annotation.Nullable;

import java.util.List;

/** MemorySegment pool from heap with no limit. */
public class UnlimitedSegmentPool implements MemorySegmentPool {

    private final int pageSize;

    public UnlimitedSegmentPool(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public int pageSize() {
        return pageSize;
    }

    @Override
    public void returnAll(List<MemorySegment> memory) {}

    @Override
    public int freePages() {
        return Integer.MAX_VALUE;
    }

    @Nullable
    @Override
    public MemorySegment nextSegment() {
        return MemorySegment.allocateHeapMemory(pageSize);
    }
}
