/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc.controller;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.PhoenixRpcSchedulerFactory;
import org.apache.phoenix.compat.hbase.CompatDelegatingHBaseRpcController;
import org.apache.phoenix.compat.hbase.CompatHBaseRpcController;

class IndexRpcController
extends CompatDelegatingHBaseRpcController {
    private final int priority;
    private final String tracingTableName;

    public IndexRpcController(CompatHBaseRpcController delegate, Configuration conf) {
        super(delegate);
        this.priority = PhoenixRpcSchedulerFactory.getIndexPriority(conf);
        this.tracingTableName = conf.get("phoenix.trace.statsTableName", "SYSTEM.TRACING_STATS");
    }

    @Override
    public void setPriority(TableName tn) {
        if (!tn.isSystemTable() && !tn.getNameAsString().equals(this.tracingTableName)) {
            this.setPriority(this.priority);
        } else {
            super.setPriority(tn);
        }
    }
}

