/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.curator.framework.CuratorFramework;
import org.apache.omid.timestamp.storage.ZKModule;
import org.apache.omid.tso.LeaseManagement;
import org.apache.omid.tso.LeaseManager;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.TSOChannelHandler;
import org.apache.omid.tso.TSOStateManager;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HALeaseManagementModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(HALeaseManagementModule.class);
    private long leasePeriodInMs = 10000L;
    private String tsoLeasePath = "/tso-lease";
    private String currentTsoPath = "/current-tso";
    private String zkCluster = "localhost:2181";
    private String zkNamespace = "omid";

    public HALeaseManagementModule() {
    }

    @VisibleForTesting
    public HALeaseManagementModule(long leasePeriodInMs, String tsoLeasePath, String currentTsoPath, String zkCluster, String zkNamespace) {
        this.leasePeriodInMs = leasePeriodInMs;
        this.tsoLeasePath = tsoLeasePath;
        this.currentTsoPath = currentTsoPath;
        this.zkCluster = zkCluster;
        this.zkNamespace = zkNamespace;
    }

    protected void configure() {
        this.install((Module)new ZKModule(this.zkCluster, this.zkNamespace));
    }

    @Provides
    @Singleton
    LeaseManagement provideLeaseManager(@Named(value="tso.hostandport") String tsoHostAndPort, TSOChannelHandler tsoChannelHandler, TSOStateManager stateManager, CuratorFramework zkClient, Panicker panicker) throws LeaseManagement.LeaseManagementException {
        LOG.info("Connection to HA cluster [{}]", (Object)zkClient.getState());
        return new LeaseManager(tsoHostAndPort, tsoChannelHandler, stateManager, this.leasePeriodInMs, this.tsoLeasePath, this.currentTsoPath, zkClient, panicker);
    }

    public String getCurrentTsoPath() {
        return this.currentTsoPath;
    }

    public void setCurrentTsoPath(String currentTsoPath) {
        this.currentTsoPath = currentTsoPath;
    }

    public long getLeasePeriodInMs() {
        return this.leasePeriodInMs;
    }

    public void setLeasePeriodInMs(long leasePeriodInMs) {
        this.leasePeriodInMs = leasePeriodInMs;
    }

    public String getTsoLeasePath() {
        return this.tsoLeasePath;
    }

    public void setTsoLeasePath(String tsoLeasePath) {
        this.tsoLeasePath = tsoLeasePath;
    }

    public String getZkCluster() {
        return this.zkCluster;
    }

    public void setZkCluster(String zkCluster) {
        this.zkCluster = zkCluster;
    }

    public String getZkNamespace() {
        return this.zkNamespace;
    }

    public void setZkNamespace(String zkNamespace) {
        this.zkNamespace = zkNamespace;
    }
}

