/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.omid.TestUtils;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.tso.PausableTimestampOracle;
import org.apache.omid.tso.TSOMockModule;
import org.apache.omid.tso.TSOServer;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.TimestampOracle;
import org.apache.omid.tso.client.CellId;
import org.apache.omid.tso.client.ConnectionException;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.omid.tso.client.ServiceUnavailableException;
import org.apache.omid.tso.client.TSOClient;
import org.apache.omid.tso.client.TSOClientAccessor;
import org.apache.omid.tso.client.TSOClientOneShot;
import org.apache.omid.tso.client.TSOClientRaw;
import org.apache.omid.tso.client.TSOFuture;
import org.apache.omid.tso.util.DummyCellIdImpl;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestTSOClientRequestAndResponseBehaviours {
    private static final Logger LOG = LoggerFactory.getLogger(TestTSOClientRequestAndResponseBehaviours.class);
    private static final String TSO_SERVER_HOST = "localhost";
    private static final int TSO_SERVER_PORT = 1234;
    private static final CellId c1 = new DummyCellIdImpl(3735928559L);
    private static final CellId c2 = new DummyCellIdImpl(4276996862L);
    private static final Set<CellId> testWriteSet = Sets.newHashSet((Object[])new CellId[]{c1, c2});
    private OmidClientConfiguration tsoClientConf;
    private TSOServer tsoServer;
    private PausableTimestampOracle pausableTSOracle;
    private CommitTable commitTable;

    @BeforeMethod
    public void beforeMethod() throws Exception {
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setConflictMapSize(1000);
        tsoConfig.setPort(1234);
        tsoConfig.setTimestampType(TSOServerConfig.TIMESTAMP_TYPE.INCREMENTAL.toString());
        tsoConfig.setNumConcurrentCTWriters(2);
        TSOMockModule tsoServerMockModule = new TSOMockModule(tsoConfig);
        Injector injector = Guice.createInjector((Module[])new Module[]{tsoServerMockModule});
        LOG.info("==================================================================================================");
        LOG.info("======================================= Init TSO Server ==========================================");
        LOG.info("==================================================================================================");
        this.tsoServer = (TSOServer)((Object)injector.getInstance(TSOServer.class));
        this.tsoServer.startAsync();
        this.tsoServer.awaitRunning();
        TestUtils.waitForSocketListening(TSO_SERVER_HOST, 1234, 100);
        LOG.info("==================================================================================================");
        LOG.info("===================================== TSO Server Initialized =====================================");
        LOG.info("==================================================================================================");
        this.pausableTSOracle = (PausableTimestampOracle)injector.getInstance(TimestampOracle.class);
        this.commitTable = (CommitTable)injector.getInstance(CommitTable.class);
        OmidClientConfiguration tsoClientConf = new OmidClientConfiguration();
        tsoClientConf.setConnectionString("localhost:1234");
        this.tsoClientConf = tsoClientConf;
    }

    @AfterMethod
    public void afterMethod() throws Exception {
        this.tsoServer.stopAsync();
        this.tsoServer.awaitTerminated();
        this.tsoServer = null;
        TestUtils.waitForSocketNotListening(TSO_SERVER_HOST, 1234, 1000);
        this.pausableTSOracle.resume();
    }

    @Test(timeOut=30000L)
    public void testTimeoutsAreCancelled() throws Exception {
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        int requestTimeoutInMs = 500;
        int requestMaxRetries = 5;
        LOG.info("Request timeout {} ms; Max retries {}", (Object)requestTimeoutInMs, (Object)requestMaxRetries);
        TSOFuture<Long> f = null;
        for (int i = 0; i < requestMaxRetries * 10; ++i) {
            f = client.getNewStartTimestamp();
        }
        if (f != null) {
            f.get();
        }
        this.pausableTSOracle.pause();
        long msToSleep = (long)((double)requestTimeoutInMs * 0.75);
        LOG.info("Sleeping for {} ms", (Object)msToSleep);
        TimeUnit.MILLISECONDS.sleep(msToSleep);
        f = client.getNewStartTimestamp();
        msToSleep = (long)((double)requestTimeoutInMs * 0.9);
        LOG.info("Sleeping for {} ms", (Object)msToSleep);
        TimeUnit.MILLISECONDS.sleep(msToSleep);
        LOG.info("Resuming");
        this.pausableTSOracle.resume();
        f.get();
    }

    @Test(timeOut=30000L)
    public void testCommitGetsServiceUnavailableExceptionWhenCommunicationFails() throws Exception {
        OmidClientConfiguration testTSOClientConf = new OmidClientConfiguration();
        testTSOClientConf.setConnectionString("localhost:1234");
        testTSOClientConf.setRequestMaxRetries(0);
        TSOClient client = TSOClient.newInstance(testTSOClientConf);
        ArrayList startTimestamps = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            startTimestamps.add(client.getNewStartTimestamp().get());
        }
        this.pausableTSOracle.pause();
        ArrayList<TSOFuture<Long>> futures = new ArrayList<TSOFuture<Long>>();
        Iterator iterator = startTimestamps.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            futures.add(client.commit(l, Sets.newHashSet()));
        }
        TSOClientAccessor.closeChannel(client);
        for (Future future : futures) {
            try {
                future.get();
                Assert.fail((String)"Shouldn't be able to complete");
            }
            catch (ExecutionException ee) {
                Assert.assertTrue((boolean)(ee.getCause() instanceof ServiceUnavailableException), (String)"Should be a service unavailable exception");
            }
        }
    }

    @Test(timeOut=30000L)
    public void testHandshakeBetweenOldClientAndCurrentServer() throws Exception {
        TSOClientRaw raw = new TSOClientRaw(TSO_SERVER_HOST, 1234);
        TSOProto.Request request = TSOProto.Request.newBuilder().setTimestampRequest(TSOProto.TimestampRequest.newBuilder().build()).build();
        raw.write(request);
        try {
            raw.getResponse().get();
            Assert.fail((String)"Channel should be closed");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(ee.getCause().getClass(), ConnectionException.class, (String)"Should be channel closed exception");
        }
        raw.close();
    }

    @Test(timeOut=30000L)
    public void testOutOfOrderMessages() throws Exception {
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        TSOClientOneShot clientOneShot = new TSOClientOneShot(TSO_SERVER_HOST, 1234);
        long ts1 = (Long)client.getNewStartTimestamp().get();
        TSOProto.Response response1 = clientOneShot.makeRequest(this.createCommitRequest(ts1, true, testWriteSet));
        TSOProto.Response response2 = clientOneShot.makeRequest(this.createCommitRequest(ts1, false, testWriteSet));
        Assert.assertFalse((boolean)response1.getCommitResponse().getAborted(), (String)"Retry Transaction should commit");
        Assert.assertTrue((boolean)response2.getCommitResponse().getAborted(), (String)"Transaction should abort");
    }

    @Test(timeOut=30000L)
    public void testDuplicateCommitAborting() throws Exception {
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        TSOClientOneShot clientOneShot = new TSOClientOneShot(TSO_SERVER_HOST, 1234);
        long ts1 = (Long)client.getNewStartTimestamp().get();
        long ts2 = (Long)client.getNewStartTimestamp().get();
        client.commit(ts2, testWriteSet).get();
        TSOProto.Response response1 = clientOneShot.makeRequest(this.createCommitRequest(ts1, false, testWriteSet));
        TSOProto.Response response2 = clientOneShot.makeRequest(this.createCommitRequest(ts1, true, testWriteSet));
        Assert.assertTrue((boolean)response1.getCommitResponse().getAborted(), (String)"Transaction should abort");
        Assert.assertTrue((boolean)response2.getCommitResponse().getAborted(), (String)"Retry commit should abort");
    }

    @Test(timeOut=30000L)
    public void testDuplicateCommit() throws Exception {
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        TSOClientOneShot clientOneShot = new TSOClientOneShot(TSO_SERVER_HOST, 1234);
        long ts1 = (Long)client.getNewStartTimestamp().get();
        TSOProto.Response response1 = clientOneShot.makeRequest(this.createCommitRequest(ts1, false, testWriteSet));
        TSOProto.Response response2 = clientOneShot.makeRequest(this.createCommitRequest(ts1, true, testWriteSet));
        if (client.isLowLatency()) {
            Assert.assertTrue((boolean)response1.hasCommitResponse());
            Assert.assertTrue((boolean)response2.getCommitResponse().getAborted());
        } else {
            Assert.assertEquals((long)response2.getCommitResponse().getCommitTimestamp(), (long)response1.getCommitResponse().getCommitTimestamp(), (String)"Commit timestamp should be the same");
        }
    }

    @Test(timeOut=30000L)
    public void testCommitCanSucceedWhenChannelDisconnected() throws Exception {
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        long ts1 = (Long)client.getNewStartTimestamp().get();
        if (client.isLowLatency()) {
            return;
        }
        this.pausableTSOracle.pause();
        TSOFuture<Long> future = client.commit(ts1, testWriteSet);
        TSOClientAccessor.closeChannel(client);
        this.pausableTSOracle.resume();
        future.get();
    }

    @Test(timeOut=30000L)
    public void testCommitCanSucceedWithMultipleTimeouts() throws Exception {
        OmidClientConfiguration testTSOClientConf = new OmidClientConfiguration();
        testTSOClientConf.setConnectionString("localhost:1234");
        testTSOClientConf.setRequestTimeoutInMs(100);
        testTSOClientConf.setRequestMaxRetries(10000);
        TSOClient client = TSOClient.newInstance(testTSOClientConf);
        long ts1 = (Long)client.getNewStartTimestamp().get();
        this.pausableTSOracle.pause();
        TSOFuture<Long> future = client.commit(ts1, testWriteSet);
        TimeUnit.SECONDS.sleep(1L);
        this.pausableTSOracle.resume();
        future.get();
    }

    @Test(timeOut=30000L)
    public void testCommitFailWhenTSOIsDown() throws Exception {
        OmidClientConfiguration testTSOClientConf = new OmidClientConfiguration();
        testTSOClientConf.setConnectionString("localhost:1234");
        testTSOClientConf.setRequestTimeoutInMs(100);
        testTSOClientConf.setRequestMaxRetries(10);
        TSOClient client = TSOClient.newInstance(testTSOClientConf);
        long ts1 = (Long)client.getNewStartTimestamp().get();
        this.pausableTSOracle.pause();
        TSOFuture<Long> future = client.commit(ts1, testWriteSet);
        try {
            future.get();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(e.getCause().getClass(), ServiceUnavailableException.class, (String)"Should be a ServiceUnavailableExeption");
        }
    }

    @Test(timeOut=30000L)
    public void testTimestampRequestSucceedWithMultipleTimeouts() throws Exception {
        OmidClientConfiguration testTSOClientConf = new OmidClientConfiguration();
        testTSOClientConf.setConnectionString("localhost:1234");
        testTSOClientConf.setRequestTimeoutInMs(100);
        testTSOClientConf.setRequestMaxRetries(10000);
        TSOClient client = TSOClient.newInstance(testTSOClientConf);
        this.pausableTSOracle.pause();
        TSOFuture<Long> future = client.getNewStartTimestamp();
        TimeUnit.SECONDS.sleep(1L);
        this.pausableTSOracle.resume();
        future.get();
    }

    @Test(timeOut=30000L)
    public void testCommitTimestampPresentInCommitTableReturnsCommit() throws Exception {
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        TSOClientOneShot clientOneShot = new TSOClientOneShot(TSO_SERVER_HOST, 1234);
        long tx1ST = (Long)client.getNewStartTimestamp().get();
        clientOneShot.makeRequest(this.createRetryCommitRequest(tx1ST));
        TSOProto.Response response = clientOneShot.makeRequest(this.createRetryCommitRequest(tx1ST));
        if (client.isLowLatency()) {
            Assert.assertTrue((boolean)response.getCommitResponse().getAborted(), (String)"Transaction should be aborted");
        } else {
            Assert.assertFalse((boolean)response.getCommitResponse().getAborted(), (String)"Transaction should be committed");
            Assert.assertEquals((long)response.getCommitResponse().getCommitTimestamp(), (long)(tx1ST + 50L));
        }
    }

    @Test(timeOut=30000L)
    public void testInvalidCommitTimestampPresentInCommitTableReturnsAbort() throws Exception {
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        TSOClientOneShot clientOneShot = new TSOClientOneShot(TSO_SERVER_HOST, 1234);
        long tx1ST = (Long)client.getNewStartTimestamp().get();
        this.commitTable.getClient().tryInvalidateTransaction(tx1ST);
        clientOneShot.makeRequest(this.createRetryCommitRequest(tx1ST));
        TSOProto.Response response = clientOneShot.makeRequest(this.createRetryCommitRequest(tx1ST));
        Assert.assertTrue((boolean)response.getCommitResponse().getAborted(), (String)"Transaction should be aborted");
        Assert.assertEquals((long)response.getCommitResponse().getCommitTimestamp(), (long)0L);
    }

    @Test(timeOut=30000L)
    public void testCommitTimestampNotPresentInCommitTableReturnsAnAbort() throws Exception {
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        TSOClientOneShot clientOneShot = new TSOClientOneShot(TSO_SERVER_HOST, 1234);
        long tx1ST = (Long)client.getNewStartTimestamp().get();
        clientOneShot.makeRequest(this.createRetryCommitRequest(tx1ST));
        this.commitTable.getClient().deleteCommitEntry(tx1ST);
        TSOProto.Response response = clientOneShot.makeRequest(this.createRetryCommitRequest(tx1ST));
        Assert.assertTrue((boolean)response.getCommitResponse().getAborted(), (String)"Transaction should abort");
        Assert.assertEquals((long)response.getCommitResponse().getCommitTimestamp(), (long)0L);
    }

    private TSOProto.Request createRetryCommitRequest(long ts) {
        return this.createCommitRequest(ts, true, testWriteSet);
    }

    private TSOProto.Request createCommitRequest(long ts, boolean retry, Set<CellId> writeSet) {
        TSOProto.Request.Builder builder = TSOProto.Request.newBuilder();
        TSOProto.CommitRequest.Builder commitBuilder = TSOProto.CommitRequest.newBuilder();
        commitBuilder.setStartTimestamp(ts);
        commitBuilder.setIsRetry(retry);
        for (CellId cell : writeSet) {
            commitBuilder.addCellId(cell.getCellId());
        }
        return builder.setCommitRequest(commitBuilder.build()).build();
    }
}

