/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.exception.MultiIndexWriteFailureException;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.IndexFailurePolicy;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.TrackingParallelWriterIndexCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryIndexWriter
extends IndexWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecoveryIndexWriter.class);
    private Set<HTableInterfaceReference> nonExistingTablesList = new HashSet<HTableInterfaceReference>();
    private HBaseAdmin admin;

    public RecoveryIndexWriter(IndexFailurePolicy policy, RegionCoprocessorEnvironment env, String name) throws IOException {
        super(new TrackingParallelWriterIndexCommitter(), policy, env, name);
        this.admin = new HBaseAdmin(env.getConfiguration());
    }

    @Override
    public void write(Collection<Pair<Mutation, byte[]>> toWrite, boolean allowLocalUpdates, int clientVersion) throws IOException {
        try {
            this.write(this.resolveTableReferences(toWrite), allowLocalUpdates, clientVersion);
        }
        catch (MultiIndexWriteFailureException e) {
            for (HTableInterfaceReference table : e.getFailedTables()) {
                if (!this.admin.tableExists(table.getTableName())) {
                    LOGGER.warn("Failure due to non existing table: " + table.getTableName());
                    this.nonExistingTablesList.add(table);
                    continue;
                }
                throw e;
            }
        }
    }

    @Override
    protected Multimap<HTableInterfaceReference, Mutation> resolveTableReferences(Collection<Pair<Mutation, byte[]>> indexUpdates) {
        ArrayListMultimap updates = ArrayListMultimap.create();
        HashMap<ImmutableBytesPtr, HTableInterfaceReference> tables = new HashMap<ImmutableBytesPtr, HTableInterfaceReference>(updates.size());
        for (Pair<Mutation, byte[]> entry : indexUpdates) {
            byte[] tableName = (byte[])entry.getSecond();
            ImmutableBytesPtr ptr = new ImmutableBytesPtr(tableName);
            HTableInterfaceReference table = (HTableInterfaceReference)tables.get((Object)ptr);
            if (this.nonExistingTablesList.contains(table)) {
                LOGGER.debug("Edits found for non existing table: " + table.getTableName() + " so skipping it!!");
                continue;
            }
            if (table == null) {
                table = new HTableInterfaceReference(ptr);
                tables.put(ptr, table);
            }
            updates.put((Object)table, entry.getFirst());
        }
        return updates;
    }

    @Override
    public void stop(String why) {
        super.stop(why);
        if (this.admin != null) {
            try {
                this.admin.close();
            }
            catch (IOException e) {
                LOGGER.error("Closing the admin failed: ", (Throwable)e);
            }
        }
    }
}

