/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.iterate.BaseResultIterator;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.EncodedColumnQualiferCellsList;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.PositionBasedMultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;

public class RegionScannerResultIterator
extends BaseResultIterator {
    private final RegionScanner scanner;
    private final Pair<Integer, Integer> minMaxQualifiers;
    private final boolean useQualifierAsIndex;
    private final PTable.QualifierEncodingScheme encodingScheme;

    public RegionScannerResultIterator(RegionScanner scanner, Pair<Integer, Integer> minMaxQualifiers, PTable.QualifierEncodingScheme encodingScheme) {
        this.scanner = scanner;
        this.useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex(minMaxQualifiers);
        this.minMaxQualifiers = minMaxQualifiers;
        this.encodingScheme = encodingScheme;
    }

    @Override
    public Tuple next() throws SQLException {
        RegionScanner regionScanner = this.scanner;
        synchronized (regionScanner) {
            try {
                List<Cell> results = this.useQualifierAsIndex ? new EncodedColumnQualiferCellsList((Integer)this.minMaxQualifiers.getFirst(), (Integer)this.minMaxQualifiers.getSecond(), this.encodingScheme) : new ArrayList();
                boolean hasMore = this.scanner.nextRaw((List)results);
                if (!hasMore && results.isEmpty()) {
                    return null;
                }
                if (ScanUtil.isDummy(results)) {
                    return new ResultTuple(Result.create(results));
                }
                BaseTuple tuple = this.useQualifierAsIndex ? new PositionBasedMultiKeyValueTuple() : new MultiKeyValueTuple();
                tuple.setKeyValues(results);
                return tuple;
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
        }
    }

    public String toString() {
        return "RegionScannerResultIterator [scanner=" + this.scanner + "]";
    }
}

