/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.AggregateFunction;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.UDFExpression;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.schema.ArgumentTypeMismatchException;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.ValueRangeExcpetion;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDataTypeFactory;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.SchemaUtil;

public class FunctionParseNode
extends CompoundParseNode {
    private final String name;
    private BuiltInFunctionInfo info;

    FunctionParseNode(String name, List<ParseNode> children, BuiltInFunctionInfo info) {
        super(children);
        this.name = SchemaUtil.normalizeIdentifier(name);
        this.info = info;
    }

    public BuiltInFunctionInfo getInfo() {
        return this.info;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    public boolean isAggregate() {
        if (this.getInfo() == null) {
            return false;
        }
        return this.getInfo().isAggregate();
    }

    public boolean evalToNullIfParamIsNull(StatementContext context, int index) throws SQLException {
        return true;
    }

    private static Constructor<? extends FunctionParseNode> getParseNodeCtor(Class<? extends FunctionParseNode> clazz) {
        Constructor<? extends FunctionParseNode> ctor;
        try {
            ctor = clazz.getDeclaredConstructor(String.class, List.class, BuiltInFunctionInfo.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctor.setAccessible(true);
        return ctor;
    }

    private static Constructor<? extends FunctionExpression> getExpressionCtor(Class<? extends FunctionExpression> clazz, PFunction function) {
        Constructor<? extends FunctionExpression> ctor;
        try {
            ctor = function == null ? clazz.getDeclaredConstructor(List.class) : clazz.getDeclaredConstructor(List.class, PFunction.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctor.setAccessible(true);
        return ctor;
    }

    public List<Expression> validate(List<Expression> children, StatementContext context) throws SQLException {
        int i;
        BuiltInFunctionInfo info = this.getInfo();
        BuiltInFunctionArgInfo[] args = info.getArgs();
        if (args.length < children.size() || info.getRequiredArgCount() > children.size()) {
            throw new FunctionNotFoundException(this.name);
        }
        if (args.length > children.size()) {
            ArrayList<Expression> moreChildren = new ArrayList<Expression>(children);
            for (i = children.size(); i < info.getArgs().length; ++i) {
                moreChildren.add(LiteralExpression.newConstant(null, args[i].allowedTypes.length == 0 ? null : PDataTypeFactory.getInstance().instanceFromClass(args[i].allowedTypes[0]), Determinism.ALWAYS));
            }
            children = moreChildren;
        }
        List<ParseNode> nodeChildren = this.getChildren();
        for (i = 0; i < children.size(); ++i) {
            Expression child;
            BindParseNode bindNode = null;
            Class<? extends PDataType>[] allowedTypes = args[i].getAllowedTypes();
            if (i < nodeChildren.size() && nodeChildren.get(i) instanceof BindParseNode) {
                bindNode = (BindParseNode)nodeChildren.get(i);
            }
            if ((child = children.get(i)).getDataType() == null || i >= nodeChildren.size()) {
                if (args[i].getDefaultValue() != null) {
                    LiteralExpression defaultValue = args[i].getDefaultValue();
                    children.set(i, defaultValue);
                    if (bindNode == null) continue;
                    context.getBindManager().addParamMetaData(bindNode, defaultValue);
                    continue;
                }
                if (bindNode != null) {
                    if (child.getDataType() == null) {
                        if (allowedTypes.length <= 0) continue;
                        context.getBindManager().addParamMetaData(bindNode, LiteralExpression.newConstant(null, PDataTypeFactory.getInstance().instanceFromClass(allowedTypes[0]), Determinism.ALWAYS));
                        continue;
                    }
                    context.getBindManager().addParamMetaData(bindNode, child);
                    continue;
                }
                if (allowedTypes.length <= 0) continue;
                children.set(i, LiteralExpression.newConstant(null, PDataTypeFactory.getInstance().instanceFromClass(allowedTypes[0]), Determinism.ALWAYS));
                continue;
            }
            FunctionParseNode.validateFunctionArguement(info, i, child);
        }
        return children;
    }

    public static void validateFunctionArguement(BuiltInFunctionInfo info, int childIndex, Expression child) throws ArgumentTypeMismatchException, ValueRangeExcpetion {
        BuiltInFunctionArgInfo arg = info.getArgs()[childIndex];
        if (arg.getAllowedTypes().length > 0) {
            boolean isCoercible = false;
            for (Class<? extends PDataType> type : arg.getAllowedTypes()) {
                if (!child.getDataType().isCoercibleTo(PDataTypeFactory.getInstance().instanceFromClass(type))) continue;
                isCoercible = true;
                break;
            }
            if (!isCoercible) {
                throw new ArgumentTypeMismatchException(arg.getAllowedTypes(), child.getDataType(), info.getName() + " argument " + (childIndex + 1));
            }
            if (child instanceof LiteralExpression) {
                LiteralExpression valueExp = (LiteralExpression)child;
                LiteralExpression minValue = arg.getMinValue();
                LiteralExpression maxValue = arg.getMaxValue();
                if (minValue != null && minValue.getDataType().compareTo(minValue.getValue(), valueExp.getValue(), valueExp.getDataType()) > 0) {
                    throw new ValueRangeExcpetion(minValue, maxValue == null ? "" : maxValue, valueExp.getValue(), info.getName() + " argument " + (childIndex + 1));
                }
                if (maxValue != null && maxValue.getDataType().compareTo(maxValue.getValue(), valueExp.getValue(), valueExp.getDataType()) < 0) {
                    throw new ValueRangeExcpetion(minValue == null ? "" : minValue, maxValue, valueExp.getValue(), info.getName() + " argument " + (childIndex + 1));
                }
            }
        }
        if (arg.isConstant() && !(child instanceof LiteralExpression)) {
            throw new ArgumentTypeMismatchException("constant", child.toString(), info.getName() + " argument " + (childIndex + 1));
        }
        if (!arg.getAllowedValues().isEmpty()) {
            Object value = ((LiteralExpression)child).getValue();
            if (!arg.getAllowedValues().contains(value.toString().toUpperCase())) {
                throw new ArgumentTypeMismatchException(Arrays.toString(arg.getAllowedValues().toArray(new String[0])), value.toString(), info.getName() + " argument " + (childIndex + 1));
            }
        }
    }

    public Expression create(List<Expression> children, StatementContext context) throws SQLException {
        return this.create(children, null, context);
    }

    public Expression create(List<Expression> children, PFunction function, StatementContext context) throws SQLException {
        try {
            Constructor<? extends FunctionExpression> fCtor = this.info.getFuncCtor();
            if (fCtor == null) {
                fCtor = FunctionParseNode.getExpressionCtor(this.info.func, null);
            }
            if (function == null) {
                return fCtor.newInstance(children);
            }
            return fCtor.newInstance(children, function);
        }
        catch (InstantiationException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new SQLException(e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionParseNode other = (FunctionParseNode)obj;
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append(' ');
        buf.append(this.name);
        buf.append('(');
        List<ParseNode> children = this.getChildren();
        if (!children.isEmpty()) {
            for (ParseNode child : children) {
                child.toSQL(resolver, buf);
                buf.append(',');
            }
            buf.setLength(buf.length() - 1);
        }
        buf.append(')');
    }

    @Immutable
    public static class BuiltInFunctionArgInfo {
        private static final Class<? extends PDataType>[] ENUMERATION_TYPES = new Class[]{PVarchar.class};
        private final Class<? extends PDataType>[] allowedTypes;
        private final boolean isConstant;
        private final Set<String> allowedValues;
        private final LiteralExpression defaultValue;
        private final LiteralExpression minValue;
        private final LiteralExpression maxValue;

        BuiltInFunctionArgInfo(Argument argument) {
            if (argument.enumeration().length() > 0) {
                this.isConstant = true;
                this.defaultValue = null;
                this.minValue = null;
                this.maxValue = null;
                this.allowedTypes = ENUMERATION_TYPES;
                Class<?> clazz = null;
                String packageName = FunctionExpression.class.getPackage().getName();
                try {
                    clazz = Class.forName(packageName + "." + argument.enumeration());
                }
                catch (ClassNotFoundException e) {
                    try {
                        clazz = Class.forName(argument.enumeration());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (clazz == null || !clazz.isEnum()) {
                    throw new IllegalStateException("The enumeration annotation '" + argument.enumeration() + "' does not resolve to a enumeration class");
                }
                Class<?> enumClass = clazz;
                Enum[] enums = (Enum[])enumClass.getEnumConstants();
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (Enum en : enums) {
                    builder.add((Object)en.name());
                }
                this.allowedValues = builder.build();
            } else {
                this.allowedValues = Collections.emptySet();
                this.isConstant = argument.isConstant();
                this.allowedTypes = argument.allowedTypes();
                this.defaultValue = this.getExpFromConstant(argument.defaultValue());
                this.minValue = this.getExpFromConstant(argument.minValue());
                this.maxValue = this.getExpFromConstant(argument.maxValue());
            }
        }

        BuiltInFunctionArgInfo(PFunction.FunctionArgument arg) {
            PDataType dataType = arg.isArrayType() ? PDataType.fromTypeId(PDataType.sqlArrayType(SchemaUtil.normalizeIdentifier(SchemaUtil.normalizeIdentifier(arg.getArgumentType())))) : PDataType.fromSqlTypeName(SchemaUtil.normalizeIdentifier(arg.getArgumentType()));
            this.allowedValues = Collections.emptySet();
            this.allowedTypes = new Class[]{dataType.getClass()};
            this.isConstant = arg.isConstant();
            this.defaultValue = arg.getDefaultValue() == null ? null : arg.getDefaultValue();
            this.minValue = arg.getMinValue() == null ? null : arg.getMinValue();
            this.maxValue = arg.getMaxValue() == null ? null : arg.getMaxValue();
        }

        private LiteralExpression getExpFromConstant(String strValue) {
            LiteralExpression exp = null;
            if (strValue.length() > 0) {
                SQLParser parser = new SQLParser(strValue);
                try {
                    LiteralParseNode node = parser.parseLiteral();
                    LiteralExpression defaultValue = LiteralExpression.newConstant(node.getValue(), PDataTypeFactory.getInstance().instanceFromClass(this.allowedTypes[0]), Determinism.ALWAYS);
                    if (this.getAllowedTypes().length > 0) {
                        for (Class<? extends PDataType> type : this.getAllowedTypes()) {
                            if (defaultValue.getDataType() != null && !defaultValue.getDataType().isCoercibleTo(PDataTypeFactory.getInstance().instanceFromClass(type), node.getValue())) continue;
                            return LiteralExpression.newConstant(node.getValue(), PDataTypeFactory.getInstance().instanceFromClass(type), Determinism.ALWAYS);
                        }
                        throw new IllegalStateException("Unable to coerce default value " + strValue + " to any of the allowed types of " + Arrays.toString(this.getAllowedTypes()));
                    }
                    exp = defaultValue;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return exp;
        }

        public boolean isConstant() {
            return this.isConstant;
        }

        public LiteralExpression getDefaultValue() {
            return this.defaultValue;
        }

        public LiteralExpression getMinValue() {
            return this.minValue;
        }

        public LiteralExpression getMaxValue() {
            return this.maxValue;
        }

        public Class<? extends PDataType>[] getAllowedTypes() {
            return this.allowedTypes;
        }

        public Set<String> getAllowedValues() {
            return this.allowedValues;
        }
    }

    @Immutable
    public static final class BuiltInFunctionInfo {
        private final String name;
        private final Class<? extends FunctionExpression> func;
        private final Constructor<? extends FunctionExpression> funcCtor;
        private final Constructor<? extends FunctionParseNode> nodeCtor;
        private final BuiltInFunctionArgInfo[] args;
        private final boolean isAggregate;
        private final int requiredArgCount;
        private final FunctionClassType classType;
        private final Class<? extends FunctionExpression>[] derivedFunctions;

        public BuiltInFunctionInfo(Class<? extends FunctionExpression> f, BuiltInFunction d) {
            this.name = SchemaUtil.normalizeIdentifier(d.name());
            this.func = f;
            this.funcCtor = d.nodeClass() == FunctionParseNode.class ? FunctionParseNode.getExpressionCtor(f, null) : null;
            this.nodeCtor = d.nodeClass() == FunctionParseNode.class ? null : FunctionParseNode.getParseNodeCtor(d.nodeClass());
            this.args = new BuiltInFunctionArgInfo[d.args().length];
            int requiredArgCount = 0;
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = new BuiltInFunctionArgInfo(d.args()[i]);
                if (this.args[i].getDefaultValue() != null) continue;
                requiredArgCount = i + 1;
            }
            this.requiredArgCount = requiredArgCount;
            this.isAggregate = AggregateFunction.class.isAssignableFrom(f);
            this.classType = d.classType();
            this.derivedFunctions = d.derivedFunctions();
        }

        public BuiltInFunctionInfo(PFunction function) {
            this.name = SchemaUtil.normalizeIdentifier(function.getFunctionName());
            this.func = null;
            this.funcCtor = FunctionParseNode.getExpressionCtor(UDFExpression.class, function);
            this.nodeCtor = FunctionParseNode.getParseNodeCtor(UDFParseNode.class);
            this.args = new BuiltInFunctionArgInfo[function.getFunctionArguments().size()];
            int requiredArgCount = 0;
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = new BuiltInFunctionArgInfo(function.getFunctionArguments().get(i));
                if (this.args[i].getDefaultValue() != null) continue;
                requiredArgCount = i + 1;
            }
            this.requiredArgCount = requiredArgCount;
            this.isAggregate = AggregateFunction.class.isAssignableFrom(UDFExpression.class);
            this.classType = FunctionClassType.UDF;
            this.derivedFunctions = null;
        }

        public int getRequiredArgCount() {
            return this.requiredArgCount;
        }

        public String getName() {
            return this.name;
        }

        public Class<? extends FunctionExpression> getFunc() {
            return this.func;
        }

        public Constructor<? extends FunctionExpression> getFuncCtor() {
            return this.funcCtor;
        }

        public Constructor<? extends FunctionParseNode> getNodeCtor() {
            return this.nodeCtor;
        }

        public boolean isAggregate() {
            return this.isAggregate;
        }

        public BuiltInFunctionArgInfo[] getArgs() {
            return this.args;
        }

        public FunctionClassType getClassType() {
            return this.classType;
        }

        public Class<? extends FunctionExpression>[] getDerivedFunctions() {
            return this.derivedFunctions;
        }
    }

    public static enum FunctionClassType {
        NONE,
        ABSTRACT,
        DERIVED,
        ALIAS,
        UDF;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Argument {
        public Class<? extends PDataType>[] allowedTypes() default {};

        public boolean isConstant() default false;

        public String defaultValue() default "";

        public String enumeration() default "";

        public String minValue() default "";

        public String maxValue() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface BuiltInFunction {
        public String name();

        public Argument[] args() default {};

        public Class<? extends FunctionParseNode> nodeClass() default FunctionParseNode.class;

        public Class<? extends FunctionExpression>[] derivedFunctions() default {};

        public FunctionClassType classType() default FunctionClassType.NONE;
    }
}

