/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.util.PrefixByteDecoder;
import org.apache.phoenix.util.PrefixByteEncoder;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class PrefixByteCodec {
    public static List<byte[]> decodeBytes(ImmutableBytesWritable encodedBytes, int maxLength) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(encodedBytes.get(), encodedBytes.getOffset(), encodedBytes.getLength());
        DataInputStream input = new DataInputStream(stream);
        PrefixByteDecoder decoder = new PrefixByteDecoder(maxLength);
        ArrayList listOfBytes = Lists.newArrayList();
        try {
            while (true) {
                ImmutableBytesWritable ptr = decoder.decode(input);
                listOfBytes.add(ptr.copyBytes());
            }
        }
        catch (EOFException eOFException) {
            return listOfBytes;
        }
    }

    public static int encodeBytes(List<byte[]> listOfBytes, ImmutableBytesWritable ptr) throws IOException {
        try (TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(PrefixByteCodec.calculateSize(listOfBytes));){
            DataOutputStream output = new DataOutputStream(stream);
            PrefixByteEncoder encoder = new PrefixByteEncoder();
            for (byte[] bytes : listOfBytes) {
                encoder.encode(output, bytes, 0, bytes.length);
            }
            ptr.set(stream.getBuffer(), 0, stream.size());
            int n = encoder.getMaxLength();
            return n;
        }
    }

    public static int calculateSize(List<byte[]> listOfBytes) {
        int size = 0;
        for (byte[] bytes : listOfBytes) {
            size += bytes.length;
        }
        return size;
    }

    public static ImmutableBytesWritable decode(PrefixByteDecoder decoder, DataInput input) throws EOFException {
        try {
            ImmutableBytesWritable val = decoder.decode(input);
            return val;
        }
        catch (EOFException eof) {
            throw eof;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

