/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.runtime;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import org.apache.twill.common.Cancellable;
import org.apache.twill.discovery.Discoverable;
import org.apache.twill.discovery.DiscoveryService;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.apache.twill.discovery.InMemoryDiscoveryService;
import org.apache.twill.discovery.ServiceDiscovered;
import org.apache.twill.discovery.ZKDiscoveryService;
import org.apache.twill.zookeeper.ZKClientService;

public final class DiscoveryModules {
    public Module getInMemoryModules() {
        return new InMemoryDiscoveryModule();
    }

    public Module getSingleNodeModules() {
        return new InMemoryDiscoveryModule();
    }

    public Module getDistributedModules() {
        return new ZKDiscoveryModule();
    }

    private static final class ZKDiscoveryModule
    extends PrivateModule {
        private ZKDiscoveryModule() {
        }

        protected void configure() {
            this.expose(DiscoveryService.class);
            this.expose(DiscoveryServiceClient.class);
        }

        @Provides
        @Singleton
        private ZKDiscoveryService providesZKDiscoveryService(ZKClientService zkClient) {
            return new ZKDiscoveryService(zkClient);
        }

        @Provides
        @Singleton
        private DiscoveryService providesDiscoveryService(final ZKClientService zkClient, final ZKDiscoveryService delegate) {
            return new DiscoveryService(){

                @Override
                public Cancellable register(Discoverable discoverable) {
                    if (!zkClient.isRunning()) {
                        zkClient.startAndWait();
                    }
                    return delegate.register(discoverable);
                }
            };
        }

        @Provides
        @Singleton
        private DiscoveryServiceClient providesDiscoveryServiceClient(final ZKClientService zkClient, final ZKDiscoveryService delegate) {
            return new DiscoveryServiceClient(){

                @Override
                public ServiceDiscovered discover(String s) {
                    if (!zkClient.isRunning()) {
                        zkClient.startAndWait();
                    }
                    return delegate.discover(s);
                }
            };
        }
    }

    private static final class InMemoryDiscoveryModule
    extends AbstractModule {
        private static final InMemoryDiscoveryService IN_MEMORY_DISCOVERY_SERVICE = new InMemoryDiscoveryService();

        private InMemoryDiscoveryModule() {
        }

        protected void configure() {
            InMemoryDiscoveryService discovery = IN_MEMORY_DISCOVERY_SERVICE;
            this.bind(DiscoveryService.class).toInstance((Object)discovery);
            this.bind(DiscoveryServiceClient.class).toInstance((Object)discovery);
        }
    }
}

