/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.tso.client.AbortException;
import org.apache.omid.tso.client.CellId;
import org.apache.omid.tso.client.ForwardingTSOFuture;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.omid.tso.client.TSOFuture;
import org.apache.omid.tso.client.TSOProtocol;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.SettableFuture;

public class MockTSOClient
implements TSOProtocol {
    private static final int CONFLICT_MAP_SIZE = 1000000;
    private final AtomicLong timestampGenerator = new AtomicLong();
    private final long[] conflictMap = new long[1000000];
    private final Map<Long, Long> fenceMap = new HashMap<Long, Long>();
    private final AtomicLong lwm = new AtomicLong();
    private final CommitTable.Writer commitTable;

    public MockTSOClient(CommitTable.Writer commitTable) {
        this.commitTable = commitTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSOFuture<Long> getNewStartTimestamp() {
        long[] lArray = this.conflictMap;
        synchronized (this.conflictMap) {
            SettableFuture f = SettableFuture.create();
            f.set((Object)this.timestampGenerator.incrementAndGet());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new ForwardingTSOFuture<Long>((ListenableFuture<Long>)f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSOFuture<Long> getFence(long tableId) {
        long[] lArray = this.conflictMap;
        synchronized (this.conflictMap) {
            SettableFuture f = SettableFuture.create();
            long fenceTimestamp = this.timestampGenerator.incrementAndGet();
            f.set((Object)fenceTimestamp);
            this.fenceMap.put(tableId, fenceTimestamp);
            try {
                this.commitTable.addCommittedTransaction(fenceTimestamp, fenceTimestamp);
                this.commitTable.flush();
            }
            catch (IOException ioe) {
                f.setException((Throwable)ioe);
            }
            return new ForwardingTSOFuture<Long>((ListenableFuture<Long>)f);
        }
    }

    private boolean hasConflictsWithFences(long transactionId, Set<? extends CellId> cells) {
        HashSet<Long> tableIDs = new HashSet<Long>();
        for (CellId cellId : cells) {
            tableIDs.add(cellId.getTableId());
        }
        if (!this.fenceMap.isEmpty()) {
            Iterator<CellId> iterator = tableIDs.iterator();
            while (iterator.hasNext()) {
                long l = (Long)((Object)iterator.next());
                Long fence = this.fenceMap.get(l);
                if (fence != null && transactionId < fence) {
                    return true;
                }
                if (fence == null || fence >= this.lwm.get()) continue;
                this.fenceMap.remove(l);
            }
        }
        return false;
    }

    private boolean hasConflictsWithCommittedTransactions(long transactionId, Set<? extends CellId> cells) {
        for (CellId cellId : cells) {
            int index = Math.abs((int)(cellId.getCellId() % 1000000L));
            if (this.conflictMap[index] < transactionId) continue;
            return true;
        }
        return false;
    }

    @Override
    public TSOFuture<Long> commit(long transactionId, Set<? extends CellId> cells, Set<? extends CellId> conflictFreeWriteSet) {
        return this.commit(transactionId, cells);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSOFuture<Long> commit(long transactionId, Set<? extends CellId> cells) {
        long[] lArray = this.conflictMap;
        synchronized (this.conflictMap) {
            SettableFuture f = SettableFuture.create();
            if (transactionId < this.lwm.get()) {
                f.setException((Throwable)new AbortException());
                // ** MonitorExit[lArray] (shouldn't be in output)
                return new ForwardingTSOFuture<Long>((ListenableFuture<Long>)f);
            }
            if (!this.hasConflictsWithFences(transactionId, cells) && !this.hasConflictsWithCommittedTransactions(transactionId, cells)) {
                long commitTimestamp = this.timestampGenerator.incrementAndGet();
                for (CellId cellId : cells) {
                    int index = Math.abs((int)(cellId.getCellId() % 1000000L));
                    long oldVal = this.conflictMap[index];
                    this.conflictMap[index] = commitTimestamp;
                    long curLwm = this.lwm.get();
                    while (oldVal > curLwm && !this.lwm.compareAndSet(curLwm, oldVal)) {
                        curLwm = this.lwm.get();
                    }
                }
                f.set((Object)commitTimestamp);
                try {
                    this.commitTable.addCommittedTransaction(transactionId, commitTimestamp);
                    this.commitTable.updateLowWatermark(this.lwm.get());
                    this.commitTable.flush();
                }
                catch (IOException ioe) {
                    f.setException((Throwable)ioe);
                }
            } else {
                f.setException((Throwable)new AbortException());
            }
            // ** MonitorExit[lArray] (shouldn't be in output)
            return new ForwardingTSOFuture<Long>((ListenableFuture<Long>)f);
        }
    }

    @Override
    public TSOFuture<Void> close() {
        SettableFuture f = SettableFuture.create();
        f.set(null);
        return new ForwardingTSOFuture<Void>((ListenableFuture<Void>)f);
    }

    @Override
    public boolean isLowLatency() {
        return false;
    }

    @Override
    public void setConflictDetectionLevel(OmidClientConfiguration.ConflictDetectionLevel conflictDetectionLevel) {
    }

    @Override
    public OmidClientConfiguration.ConflictDetectionLevel getConflictDetectionLevel() {
        return null;
    }

    @Override
    public long getEpoch() {
        return 0L;
    }
}

