/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.TableRef;

public class PostDDLCompiler {
    private final PhoenixConnection connection;
    private final Scan scan;

    public PostDDLCompiler(PhoenixConnection connection) {
        this(connection, new Scan());
    }

    public PostDDLCompiler(PhoenixConnection connection, Scan scan) {
        this.connection = connection;
        this.scan = scan;
        scan.setAttribute("_UngroupedAgg", QueryConstants.TRUE);
    }

    public MutationPlan compile(List<TableRef> tableRefs, byte[] emptyCF, List<byte[]> projectCFs, List<PColumn> deleteList, long timestamp) throws SQLException {
        PhoenixStatement statement = new PhoenixStatement(this.connection);
        StatementContext context = new StatementContext(statement, new MultipleTableRefColumnResolver(tableRefs), this.scan, new SequenceManager(statement));
        return new PostDDLMutationPlan(context, tableRefs, timestamp, emptyCF, deleteList, projectCFs);
    }

    static /* synthetic */ PhoenixConnection access$000(PostDDLCompiler x0) {
        return x0.connection;
    }

    private class PostDDLMutationPlan
    extends BaseMutationPlan {
        private final StatementContext context;
        private final List<TableRef> tableRefs;
        private final long timestamp;
        private final byte[] emptyCF;
        private final List<PColumn> deleteList;
        private final List<byte[]> projectCFs;

        public PostDDLMutationPlan(StatementContext context, List<TableRef> tableRefs, long timestamp, byte[] emptyCF, List<PColumn> deleteList, List<byte[]> projectCFs) {
            super(context, PhoenixStatement.Operation.UPSERT);
            this.context = context;
            this.tableRefs = tableRefs;
            this.timestamp = timestamp;
            this.emptyCF = emptyCF;
            this.deleteList = deleteList;
            this.projectCFs = projectCFs;
        }

        /*
         * Exception decompiling
         */
        @Override
        public MutationState execute() throws SQLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private class SingleTableRefColumnResolver
        implements ColumnResolver {
            private final TableRef tableRef;

            public SingleTableRefColumnResolver(TableRef tableRef) {
                this.tableRef = tableRef;
            }

            @Override
            public List<TableRef> getTables() {
                return Collections.singletonList(this.tableRef);
            }

            @Override
            public List<PFunction> getFunctions() {
                return Collections.emptyList();
            }

            @Override
            public TableRef resolveTable(String schemaName, String tableName) throws SQLException {
                throw new UnsupportedOperationException();
            }

            @Override
            public ColumnRef resolveColumn(String schemaName, String tableName, String colName) throws SQLException {
                PColumn column = tableName != null ? this.tableRef.getTable().getColumnFamily(tableName).getPColumnForColumnName(colName) : this.tableRef.getTable().getColumnForColumnName(colName);
                return new ColumnRef(this.tableRef, column.getPosition());
            }

            @Override
            public PFunction resolveFunction(String functionName) throws SQLException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasUDFs() {
                return false;
            }

            @Override
            public List<PSchema> getSchemas() {
                throw new UnsupportedOperationException();
            }

            @Override
            public PSchema resolveSchema(String schemaName) throws SQLException {
                throw new SchemaNotFoundException(schemaName);
            }
        }
    }

    private static class MultipleTableRefColumnResolver
    implements ColumnResolver {
        private final List<TableRef> tableRefs;

        public MultipleTableRefColumnResolver(List<TableRef> tableRefs) {
            this.tableRefs = tableRefs;
        }

        @Override
        public List<TableRef> getTables() {
            return this.tableRefs;
        }

        @Override
        public TableRef resolveTable(String schemaName, String tableName) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ColumnRef resolveColumn(String schemaName, String tableName, String colName) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PFunction> getFunctions() {
            return Collections.emptyList();
        }

        @Override
        public PFunction resolveFunction(String functionName) throws SQLException {
            throw new FunctionNotFoundException(functionName);
        }

        @Override
        public boolean hasUDFs() {
            return false;
        }

        @Override
        public PSchema resolveSchema(String schemaName) throws SQLException {
            throw new SchemaNotFoundException(schemaName);
        }

        @Override
        public List<PSchema> getSchemas() {
            throw new UnsupportedOperationException();
        }
    }
}

