/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;

public abstract class AndOrExpression
extends BaseCompoundExpression {
    private BitSet partialEvalState;
    private boolean seenNull = false;

    public AndOrExpression() {
    }

    public AndOrExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public PDataType getDataType() {
        return PBoolean.INSTANCE;
    }

    @Override
    public void reset() {
        if (this.partialEvalState == null) {
            this.partialEvalState = new BitSet(this.children.size());
        } else {
            this.partialEvalState.clear();
        }
        this.seenNull = false;
        super.reset();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        boolean childFailed = false;
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.partialEvalState != null && this.partialEvalState.get(i)) continue;
            Expression child = (Expression)this.children.get(i);
            if (child.evaluate(tuple, ptr)) {
                if (this.isStopValue((Boolean)PBoolean.INSTANCE.toObject(ptr, child.getDataType()))) {
                    return true;
                }
                if (ptr.getLength() == 0) {
                    this.seenNull = true;
                }
                if (this.partialEvalState == null) continue;
                this.partialEvalState.set(i);
                continue;
            }
            childFailed = true;
        }
        if (childFailed) {
            return false;
        }
        if (this.seenNull) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
        }
        return true;
    }

    protected abstract boolean isStopValue(Boolean var1);
}

